/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.core.Workflow;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowImpl
implements Workflow {
    private String workflowID = null;
    private WorkflowElement rootWorkflowElement = null;
    private DN baseDN = null;
    private boolean isPrivate = false;
    private static TreeMap<String, Workflow> registeredWorkflows = new TreeMap();
    private static Object registeredWorkflowsLock = new Object();

    public WorkflowImpl(String workflowId, DN baseDN, WorkflowElement rootWorkflowElement) {
        this.workflowID = workflowId;
        this.baseDN = baseDN;
        this.rootWorkflowElement = rootWorkflowElement;
        if (this.rootWorkflowElement != null) {
            this.isPrivate = rootWorkflowElement.isPrivate();
        }
    }

    public void finalizeWorkflow() {
    }

    @Override
    public DN getBaseDN() {
        return this.baseDN;
    }

    public String getWorkflowId() {
        return this.workflowID;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public void execute(Operation operation) throws CanceledOperationException {
        this.rootWorkflowElement.execute(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() throws DirectoryException {
        Validator.ensureNotNull(this.workflowID);
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            if (registeredWorkflows.containsKey(this.workflowID)) {
                Message message = CoreMessages.ERR_REGISTER_WORKFLOW_ALREADY_EXISTS.get(this.workflowID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            TreeMap<String, Workflow> newRegisteredWorkflows = new TreeMap<String, Workflow>((SortedMap<String, Workflow>)registeredWorkflows);
            newRegisteredWorkflows.put(this.workflowID, this);
            registeredWorkflows = newRegisteredWorkflows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister() {
        Validator.ensureNotNull(this.workflowID);
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            TreeMap<String, Workflow> newWorkflows = new TreeMap<String, Workflow>((SortedMap<String, Workflow>)registeredWorkflows);
            newWorkflows.remove(this.workflowID);
            registeredWorkflows = newWorkflows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowImpl deregister(String workflowID) {
        WorkflowImpl workflowToDeregister = null;
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            if (registeredWorkflows.containsKey(workflowID)) {
                workflowToDeregister = (WorkflowImpl)registeredWorkflows.get(workflowID);
                workflowToDeregister.deregister();
            }
        }
        return workflowToDeregister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterAllOnShutdown() {
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            registeredWorkflows = new TreeMap();
        }
    }

    public static Workflow getWorkflow(String workflowID) {
        return registeredWorkflows.get(workflowID);
    }

    public static Collection<Workflow> getWorkflows() {
        return registeredWorkflows.values();
    }

    WorkflowElement getRootWorkflowElement() {
        return this.rootWorkflowElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConfig() {
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            registeredWorkflows = new TreeMap();
        }
    }
}

