/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.WorkflowResultCode;
import org.opends.server.core.WorkflowTopology;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.DN;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.SearchScope;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTopologyNode
extends WorkflowTopology {
    private WorkflowTopologyNode parent = null;
    private ArrayList<WorkflowTopologyNode> subordinates = new ArrayList();

    public WorkflowTopologyNode(WorkflowImpl workflowImpl, WorkflowElement[] preWorkflowElements, WorkflowElement[] postWorkflowElements) {
        super(workflowImpl);
    }

    @Override
    public void execute(Operation operation) throws CanceledOperationException {
        this.getWorkflowImpl().execute(operation);
        if (operation.getOperationType() == OperationType.SEARCH) {
            this.executeSearchOnSubordinates((SearchOperation)operation);
        }
    }

    private void executeSearchOnSubordinates(SearchOperation searchOp) throws CanceledOperationException {
        SearchScope originalScope = searchOp.getScope();
        if (originalScope == SearchScope.BASE_OBJECT) {
            return;
        }
        SearchScope newScope = this.elaborateScopeForSearchInSubordinates(originalScope);
        searchOp.setScope(newScope);
        WorkflowResultCode workflowResultCode = new WorkflowResultCode(searchOp.getResultCode(), searchOp.getErrorMessage());
        DN originalBaseDN = searchOp.getBaseDN();
        for (WorkflowTopologyNode subordinate : this.getSubordinates()) {
            DN subordinateDN = subordinate.getBaseDN();
            if (newScope == SearchScope.BASE_OBJECT && !subordinateDN.getParent().equals(originalBaseDN) || !originalBaseDN.isAncestorOf(subordinateDN)) continue;
            searchOp.setBaseDN(subordinateDN);
            subordinate.execute(searchOp);
            boolean sendReferenceEntry = workflowResultCode.elaborateGlobalResultCode(searchOp.getResultCode(), searchOp.getErrorMessage());
            if (!sendReferenceEntry) continue;
        }
        searchOp.setBaseDN(originalBaseDN);
        searchOp.setScope(originalScope);
        searchOp.setResultCode(workflowResultCode.resultCode());
        searchOp.setErrorMessage(workflowResultCode.errorMessage());
    }

    public void setParent(WorkflowTopologyNode parent) {
        this.parent = parent;
    }

    public WorkflowTopologyNode getParent() {
        return this.parent;
    }

    public boolean isPrivate() {
        return this.getWorkflowImpl().isPrivate();
    }

    public DN getParentBaseDN(DN dn) {
        if (dn == null) {
            return null;
        }
        DN parentBaseDN = null;
        DN curBaseDN = this.getBaseDN();
        if (curBaseDN != null && dn.isDescendantOf(curBaseDN)) {
            WorkflowTopologyNode subordinate;
            Iterator<WorkflowTopologyNode> i$ = this.getSubordinates().iterator();
            while (i$.hasNext() && (parentBaseDN = (subordinate = i$.next()).getParentBaseDN(dn)) == null) {
            }
            if (parentBaseDN == null) {
                parentBaseDN = curBaseDN;
            }
        }
        return parentBaseDN;
    }

    private void addSubordinateNoCheck(WorkflowTopologyNode newWorkflow, WorkflowTopologyNode parentWorkflow) {
        this.subordinates.add(newWorkflow);
        newWorkflow.setParent(parentWorkflow);
    }

    private void addSubordinate(WorkflowTopologyNode newWorkflow) {
        if (newWorkflow == this) {
            return;
        }
        ArrayList<WorkflowTopologyNode> curSubordinateList = new ArrayList<WorkflowTopologyNode>(this.getSubordinates());
        for (WorkflowTopologyNode curSubordinate : curSubordinateList) {
            DN subordinateDN;
            DN newDN = newWorkflow.getBaseDN();
            if (newDN.equals(subordinateDN = curSubordinate.getBaseDN())) {
                return;
            }
            if (!subordinateDN.isDescendantOf(newDN)) continue;
            this.removeSubordinate(curSubordinate);
            newWorkflow.addSubordinate(curSubordinate);
        }
        this.addSubordinateNoCheck(newWorkflow, this);
    }

    public void removeSubordinate(WorkflowTopologyNode subordinate) {
        this.subordinates.remove(subordinate);
    }

    public boolean insertSubordinate(WorkflowTopologyNode newWorkflow) {
        DN newBaseDN;
        if (newWorkflow == this) {
            return false;
        }
        boolean insertDone = false;
        DN parentBaseDN = this.getBaseDN();
        if (parentBaseDN.equals(newBaseDN = newWorkflow.getBaseDN())) {
            return false;
        }
        if (newBaseDN.isDescendantOf(parentBaseDN)) {
            WorkflowTopologyNode subordinate;
            Iterator<WorkflowTopologyNode> i$ = this.getSubordinates().iterator();
            while (i$.hasNext() && !(insertDone = (subordinate = i$.next()).insertSubordinate(newWorkflow))) {
            }
            if (!insertDone) {
                this.addSubordinate(newWorkflow);
                insertDone = true;
            }
        }
        return insertDone;
    }

    public void remove() {
        WorkflowTopologyNode parent = this.getParent();
        if (parent != null) {
            parent.removeSubordinate(this);
        }
        for (WorkflowTopologyNode subordinate : this.getSubordinates()) {
            subordinate.setParent(parent);
            if (parent == null) continue;
            parent.addSubordinateNoCheck(subordinate, parent);
        }
    }

    public ArrayList<WorkflowTopologyNode> getSubordinates() {
        return this.subordinates;
    }

    public WorkflowTopologyNode getWorkflowCandidate(DN requestDN) {
        WorkflowTopologyNode workflowCandidate = null;
        DN baseDN = this.getParentBaseDN(requestDN);
        if (baseDN != null) {
            WorkflowTopologyNode subordinate;
            Iterator<WorkflowTopologyNode> i$ = this.getSubordinates().iterator();
            while (i$.hasNext() && (workflowCandidate = (subordinate = i$.next()).getWorkflowCandidate(requestDN)) == null) {
            }
            if (workflowCandidate == null) {
                workflowCandidate = this;
            }
        }
        return workflowCandidate;
    }

    public StringBuilder toString(String leftMargin) {
        StringBuilder sb = new StringBuilder();
        DN baseDN = this.getBaseDN();
        String workflowID = this.getWorkflowImpl().getWorkflowId();
        sb.append(leftMargin + "Workflow ID = " + workflowID + "\n");
        sb.append(leftMargin + "         baseDN:[");
        if (baseDN.isNullDN()) {
            sb.append(" \"\"");
        } else {
            sb.append(" \"" + baseDN.toString() + "\"");
        }
        sb.append(" ]\n");
        sb.append(leftMargin + "         Root Workflow Element: " + this.getWorkflowImpl().getRootWorkflowElement() + "\n");
        sb.append(leftMargin + "         Parent: " + this.getParent() + "\n");
        sb.append(leftMargin + "         List of subordinates:\n");
        ArrayList<WorkflowTopologyNode> subordinates = this.getSubordinates();
        if (subordinates.isEmpty()) {
            sb.append(leftMargin + "            NONE\n");
        } else {
            for (WorkflowTopologyNode subordinate : this.getSubordinates()) {
                sb.append((CharSequence)subordinate.toString(leftMargin + "            "));
            }
        }
        return sb;
    }
}

