/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.crypto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.GetSymmetricKeyExtendedOperationHandlerCfg;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSymmetricKeyExtendedOperation
extends ExtendedOperationHandler<GetSymmetricKeyExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte TYPE_SYMMETRIC_KEY_ELEMENT = -128;
    public static final byte TYPE_INSTANCE_KEY_ID_ELEMENT = -127;
    private Set<String> supportedControlOIDs = new HashSet<String>(0);

    @Override
    public void initializeExtendedOperationHandler(GetSymmetricKeyExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        this.supportedControlOIDs = new HashSet<String>();
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.26027.1.6.3", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.26027.1.6.3");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public Set<String> getSupportedControls() {
        return this.supportedControlOIDs;
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        String requestSymmetricKey = null;
        String instanceKeyID = null;
        ASN1OctetString requestValue = operation.getRequestValue();
        if (requestValue == null) {
            Message message = ExtensionMessages.ERR_GET_SYMMETRIC_KEY_NO_VALUE.get();
            operation.appendErrorMessage(message);
            return;
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(requestValue.value());
            block10: for (ASN1Element e : valueSequence.elements()) {
                switch (e.getType()) {
                    case -128: {
                        requestSymmetricKey = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block10;
                    }
                    case -127: {
                        instanceKeyID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block10;
                    }
                }
                Message message = ExtensionMessages.ERR_GET_SYMMETRIC_KEY_INVALID_TYPE.get(StaticUtils.byteToHex(e.getType()));
                operation.appendErrorMessage(message);
                return;
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message message = ExtensionMessages.ERR_GET_SYMMETRIC_KEY_ASN1_DECODE_EXCEPTION.get(ae.getMessage());
            operation.appendErrorMessage(message);
            return;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            Message message = ExtensionMessages.ERR_GET_SYMMETRIC_KEY_DECODE_EXCEPTION.get(StaticUtils.getExceptionMessage(e));
            operation.appendErrorMessage(message);
            return;
        }
        CryptoManagerImpl cm = DirectoryServer.getCryptoManager();
        try {
            String responseSymmetricKey = cm.reencodeSymmetricKeyAttribute(requestSymmetricKey, instanceKeyID);
            operation.setResponseOID("1.3.6.1.4.1.26027.1.6.3");
            operation.setResponseValue(new ASN1OctetString(responseSymmetricKey));
            operation.setResultCode(ResultCode.SUCCESS);
        }
        catch (CryptoManagerException e) {
            operation.setResultCode(DirectoryServer.getServerErrorResultCode());
            operation.appendErrorMessage(e.getMessageObject());
        }
        catch (Exception e) {
            operation.setResultCode(DirectoryServer.getServerErrorResultCode());
            operation.appendErrorMessage(StaticUtils.getExceptionMessage(e));
        }
    }

    public static ASN1OctetString encodeRequestValue(String symmetricKey, String instanceKeyID) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        ASN1OctetString symmetricKeyElement = new ASN1OctetString(-128, symmetricKey);
        elements.add(symmetricKeyElement);
        ASN1OctetString instanceKeyIDElement = new ASN1OctetString(-127, instanceKeyID);
        elements.add(instanceKeyIDElement);
        ASN1Sequence valueSequence = new ASN1Sequence(elements);
        return new ASN1OctetString(valueSequence.encode());
    }
}

