/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.util.Arrays;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.MD5PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MD5PasswordStorageScheme
extends PasswordStorageScheme<MD5PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.MD5PasswordStorageScheme";
    private MessageDigest messageDigest;
    private Object digestLock;

    @Override
    public void initializePasswordStorageScheme(MD5PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_INITIALIZE_MESSAGE_DIGEST.get("MD5", String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.digestLock = new Object();
    }

    @Override
    public String getStorageSchemeName() {
        return "MD5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        Object object = this.digestLock;
        synchronized (object) {
            try {
                digestBytes = this.messageDigest.digest(plaintext.value());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        return ByteStringFactory.create(Base64.encode(digestBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("MD5");
        buffer.append('}');
        Object object = this.digestLock;
        synchronized (object) {
            try {
                digestBytes = this.messageDigest.digest(plaintext.value());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        buffer.append(Base64.encode(digestBytes));
        return ByteStringFactory.create(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        byte[] storedPWDigestBytes;
        byte[] userPWDigestBytes;
        Object object = this.digestLock;
        synchronized (object) {
            try {
                userPWDigestBytes = this.messageDigest.digest(plaintextPassword.value());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return false;
            }
        }
        try {
            storedPWDigestBytes = Base64.decode(storedPassword.stringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(storedPassword.stringValue(), String.valueOf(e)));
            return false;
        }
        return Arrays.equals(userPWDigestBytes, storedPWDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("MD5");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }
}

