/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ReplicationMessage;

public class AckMessage
extends ReplicationMessage {
    private ChangeNumber changeNumber;

    public AckMessage(ChangeNumber changeNumber) {
        this.changeNumber = changeNumber;
    }

    public AckMessage(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 5) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String changenumberStr = new String(in, pos, length, "UTF-8");
            this.changeNumber = new ChangeNumber(changenumberStr);
            pos += 24;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public byte[] getBytes() {
        try {
            byte[] changeNumberByte = this.changeNumber.toString().getBytes("UTF-8");
            int length = 1 + changeNumberByte.length + 1;
            byte[] resultByteArray = new byte[length];
            int pos = 1;
            resultByteArray[0] = 5;
            pos = this.addByteArray(changeNumberByte, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

