/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

public class InitializeRequestMessage
extends RoutableMessage
implements Serializable {
    private static final long serialVersionUID = 8303271162942249215L;
    private String baseDn = null;

    public InitializeRequestMessage(DN baseDn, short senderID, short destination) {
        super(senderID, destination);
        this.baseDn = baseDn.toNormalizedString();
    }

    public InitializeRequestMessage(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 10) {
                throw new DataFormatException("input is not a valid InitializeRequestMessage");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String sourceServerIdString = new String(in, pos, length, "UTF-8");
            this.senderID = Short.valueOf(sourceServerIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String destinationServerIdString = new String(in, pos, length, "UTF-8");
            this.destination = Short.valueOf(destinationServerIdString);
            pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public DN getBaseDn() {
        if (this.baseDn == null) {
            return null;
        }
        try {
            return DN.decode(this.baseDn);
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    public byte[] getBytes() {
        try {
            byte[] baseDNBytes = this.baseDn.getBytes("UTF-8");
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            int length = 1 + baseDNBytes.length + 1 + senderBytes.length + 1 + destinationBytes.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 10;
            int pos = 1;
            pos = this.addByteArray(baseDNBytes, resultByteArray, pos);
            pos = this.addByteArray(senderBytes, resultByteArray, pos);
            pos = this.addByteArray(destinationBytes, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toString() {
        return "InitializeRequestMessage: baseDn=" + this.baseDn + " senderId=" + this.senderID + " destination=" + this.destination;
    }
}

