/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightweightServerHandler
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    short serverId;
    ServerHandler replServerHandler;
    ReplicationServerDomain rsDomain;
    DN baseDn;

    public LightweightServerHandler(String serverId, ServerHandler replServerHandler) {
        super("Server Handler");
        this.serverId = Short.valueOf(serverId);
        this.replServerHandler = replServerHandler;
        this.rsDomain = replServerHandler.getDomain();
        this.baseDn = this.rsDomain.getBaseDn();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + replServerHandler.getDomain().getReplicationServer().getMonitorInstanceName() + " LWSH for remote server " + this.serverId + " connected to:" + this.replServerHandler.getMonitorInstanceName() + " ()");
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public void startHandler() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replServerHandler.getDomain().getReplicationServer().getMonitorInstanceName() + " LWSH for remote server " + this.serverId + " connected to:" + this.replServerHandler.getMonitorInstanceName() + " start");
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
        DirectoryServer.registerMonitorProvider(this);
    }

    public void stopHandler() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replServerHandler.getDomain().getReplicationServer().getMonitorInstanceName() + " LWSH for remote server " + this.serverId + " connected to:" + this.replServerHandler.getMonitorInstanceName() + " stop");
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        String serverURL = "";
        String str = this.baseDn.toString() + " " + serverURL + " " + String.valueOf(this.serverId);
        return "Undirect LDAP Server " + str;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("server-id", String.valueOf(this.serverId)));
        attributes.add(new Attribute("base-dn", this.rsDomain.getBaseDn().toNormalizedString()));
        attributes.add(new Attribute("connected-to", this.replServerHandler.getMonitorInstanceName()));
        try {
            MonitorData md = this.rsDomain.getMonitorData();
            ServerState remoteState = md.getLDAPServerState(this.serverId);
            if (remoteState == null) {
                remoteState = new ServerState();
            }
            String ATTR_SERVER_STATE = "server-state";
            AttributeType type = DirectoryServer.getDefaultAttributeType("server-state");
            LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
            for (String str : remoteState.toStringSet()) {
                values.add(new AttributeValue(type, str));
            }
            if (values.size() == 0) {
                values.add(new AttributeValue(type, "unknown"));
            }
            Attribute attr = new Attribute(type, "server-state", values);
            attributes.add(attr);
            Long approxFirstMissingDate = md.getApproxFirstMissingDate(this.serverId);
            if (approxFirstMissingDate != null && approxFirstMissingDate > 0L) {
                Date date = new Date(approxFirstMissingDate);
                attributes.add(new Attribute("approx-older-change-not-synchronized", date.toString()));
                attributes.add(new Attribute("approx-older-change-not-synchronized-millis", String.valueOf(approxFirstMissingDate)));
            }
            long missingChanges = md.getMissingChanges(this.serverId);
            attributes.add(new Attribute("missing-changes", String.valueOf(missingChanges)));
            long delay = md.getApproxDelay(this.serverId);
            attributes.add(new Attribute("approximate-delay", String.valueOf(delay)));
        }
        catch (Exception e) {
            attributes.add(new Attribute("error", StaticUtils.stackTraceToSingleLineString(e)));
        }
        return attributes;
    }
}

