/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.ErrorMessage;
import org.opends.server.replication.protocol.MonitorMessage;
import org.opends.server.replication.protocol.MonitorRequestMessage;
import org.opends.server.replication.protocol.ReplServerInfoMessage;
import org.opends.server.replication.protocol.ResetGenerationId;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServerDomain {
    private final Object flowControlLock = new Object();
    private final DN baseDn;
    private final Map<Short, ServerHandler> connectedServers = new ConcurrentHashMap<Short, ServerHandler>();
    private final Map<Short, ServerHandler> replicationServers = new ConcurrentHashMap<Short, ServerHandler>();
    private final Map<Short, DbHandler> sourceDbHandlers = new ConcurrentHashMap<Short, DbHandler>();
    private ReplicationServer replicationServer;
    private long generationId = -1L;
    private boolean generationIdSavedStatus = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long monitorDataLifeTime = 500L;
    Semaphore remoteMonitorResponsesSemaphore;
    private MonitorData monitorData = new MonitorData();
    private MonitorData wrkMonitorData;

    public ReplicationServerDomain(DN baseDn, ReplicationServer replicationServer) {
        this.baseDn = baseDn;
        this.replicationServer = replicationServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UpdateMessage update, ServerHandler sourceHandler) throws IOException {
        short id = update.getChangeNumber().getServerId();
        sourceHandler.updateServerState(update);
        sourceHandler.incrementInCount();
        if (update.isAssured()) {
            int count = this.NumServers();
            if (count > 1) {
                if (sourceHandler.isReplicationServer()) {
                    ServerHandler.addWaitingAck(update, sourceHandler.getServerId(), this, count - 1);
                } else {
                    sourceHandler.addWaitingAck(update, count - 1);
                }
            } else {
                sourceHandler.sendAck(update.getChangeNumber());
            }
        }
        if (this.generationId < 0L) {
            this.generationId = sourceHandler.getGenerationId();
        }
        DbHandler dbHandler = null;
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            dbHandler = this.sourceDbHandlers.get(id);
            if (dbHandler == null) {
                try {
                    dbHandler = this.replicationServer.newDbHandler(id, this.baseDn);
                    this.generationIdSavedStatus = true;
                }
                catch (DatabaseException e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    this.replicationServer.shutdown();
                    return;
                }
                this.sourceDbHandlers.put(id, dbHandler);
            }
        }
        dbHandler.add(update);
        if (!sourceHandler.isReplicationServer()) {
            for (ServerHandler handler : this.replicationServers.values()) {
                handler.add(update, sourceHandler);
            }
        }
        for (ServerHandler handler : this.connectedServers.values()) {
            if (handler == sourceHandler) continue;
            handler.add(update, sourceHandler);
        }
    }

    public void waitDisconnection(short serverId) {
        if (this.connectedServers.containsKey(serverId)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startServer(ServerHandler handler) throws Exception {
        Map<Short, ServerHandler> map = this.connectedServers;
        synchronized (map) {
            ServerHandler oldHandler = this.connectedServers.get(handler.getServerId());
            if (this.connectedServers.containsKey(handler.getServerId())) {
                Message message = ReplicationMessages.ERR_DUPLICATE_SERVER_ID.get(oldHandler.toString(), handler.toString(), handler.getServerId());
                ErrorLogger.logError(message);
                return false;
            }
            this.connectedServers.put(handler.getServerId(), handler);
            this.sendReplServerInfo();
            return true;
        }
    }

    public void stopServer(ServerHandler handler) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " stopServer " + handler.getMonitorInstanceName());
        }
        if (handler.isReplicationServer()) {
            if (this.replicationServers.containsValue(handler)) {
                this.replicationServers.remove(handler.getServerId());
                handler.stopHandler();
                this.sendReplServerInfo();
            }
        } else if (this.connectedServers.containsValue(handler)) {
            this.connectedServers.remove(handler.getServerId());
            handler.stopHandler();
            this.sendReplServerInfo();
        }
    }

    protected void mayResetGenerationId() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId generationIdSavedStatus=" + this.generationIdSavedStatus);
        }
        boolean lDAPServersConnectedInTheTopology = false;
        if (this.connectedServers.isEmpty()) {
            for (ServerHandler rsh : this.replicationServers.values()) {
                if (this.generationId != rsh.getGenerationId()) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId skip RS" + rsh.getMonitorInstanceName() + " thas different genId");
                    continue;
                }
                if (!rsh.hasRemoteLDAPServers()) continue;
                lDAPServersConnectedInTheTopology = true;
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId RS" + rsh.getMonitorInstanceName() + " has servers connected to it - will not reset generationId");
            }
        } else {
            lDAPServersConnectedInTheTopology = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " has servers connected to it - will not reset generationId");
            }
        }
        if (!lDAPServersConnectedInTheTopology && !this.generationIdSavedStatus && this.generationId != -1L) {
            this.setGenerationId(-1L, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startReplicationServer(ServerHandler handler) throws Exception {
        Map<Short, ServerHandler> map = this.replicationServers;
        synchronized (map) {
            ServerHandler oldHandler = this.replicationServers.get(handler.getServerId());
            if (oldHandler != null) {
                if (!oldHandler.getServerAddressURL().equals(handler.getServerAddressURL())) {
                    Message message = ReplicationMessages.ERR_DUPLICATE_REPLICATION_SERVER_ID.get(oldHandler.getServerAddressURL(), handler.getServerAddressURL(), handler.getServerId());
                    ErrorLogger.logError(message);
                }
                return false;
            }
            this.replicationServers.put(handler.getServerId(), handler);
            handler.sendInfo(new ReplServerInfoMessage(this.getConnectedLDAPservers(), this.generationId));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMessage take(ServerHandler handler) {
        UpdateMessage msg = handler.take();
        Object object = this.flowControlLock;
        synchronized (object) {
            if (handler.restartAfterSaturation(null)) {
                this.flowControlLock.notifyAll();
            }
        }
        return msg;
    }

    public Set<String> getChangelogs() {
        LinkedHashSet<String> mySet = new LinkedHashSet<String>();
        for (ServerHandler handler : this.replicationServers.values()) {
            mySet.add(handler.getServerAddressURL());
        }
        return mySet;
    }

    public Set<Short> getServers() {
        return this.sourceDbHandlers.keySet();
    }

    public List<String> getConnectedLDAPservers() {
        ArrayList<String> mySet = new ArrayList<String>(0);
        for (ServerHandler handler : this.connectedServers.values()) {
            mySet.add(String.valueOf(handler.getServerId()));
        }
        return mySet;
    }

    public ReplicationIterator getChangelogIterator(short serverId, ChangeNumber changeNumber) {
        DbHandler handler = this.sourceDbHandlers.get(serverId);
        if (handler == null) {
            return null;
        }
        try {
            return handler.generateIterator(changeNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getChangesCount() {
        long entryCount = 0L;
        for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
            entryCount += dbHandler.getChangesCount();
        }
        return entryCount;
    }

    public DN getBaseDn() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDbHandler(short serverId, DbHandler dbHandler) throws DatabaseException {
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            this.sourceDbHandlers.put(serverId, dbHandler);
        }
    }

    private int NumServers() {
        return this.replicationServers.size() + this.connectedServers.size();
    }

    public void ack(AckMessage message, short fromServerId) {
        ServerHandler handler = this.connectedServers.get(message.getChangeNumber().getServerId());
        if (handler != null) {
            handler.ack(message, fromServerId);
        } else {
            ServerHandler.ackChangelog(message, fromServerId);
        }
    }

    protected List<ServerHandler> getDestinationServers(RoutableMessage msg, ServerHandler senderHandler) {
        ArrayList<ServerHandler> servers;
        block4: {
            block6: {
                block5: {
                    servers = new ArrayList<ServerHandler>();
                    if (msg.getDestination() == -3) break block4;
                    if (msg.getDestination() != -2) break block5;
                    if (!senderHandler.isReplicationServer()) {
                        for (ServerHandler rsh : this.replicationServers.values()) {
                            if (!rsh.hasRemoteLDAPServers()) continue;
                            servers.add(rsh);
                        }
                    }
                    for (ServerHandler destinationHandler : this.connectedServers.values()) {
                        if (destinationHandler == senderHandler) continue;
                        servers.add(destinationHandler);
                    }
                    break block4;
                }
                ServerHandler destinationHandler = this.connectedServers.get(msg.getDestination());
                if (destinationHandler == null) break block6;
                servers.add(destinationHandler);
                break block4;
            }
            if (!senderHandler.isLDAPserver()) break block4;
            for (ServerHandler h : this.replicationServers.values()) {
                if (!h.isRemoteLDAPServer(msg.getDestination())) continue;
                servers.add(h);
            }
        }
        return servers;
    }

    public void process(RoutableMessage msg, ServerHandler senderHandler) {
        if (msg.getDestination() == this.replicationServer.getServerId()) {
            if (msg instanceof ErrorMessage) {
                ErrorMessage errorMsg = (ErrorMessage)msg;
                ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
            } else if (msg instanceof MonitorRequestMessage) {
                MonitorRequestMessage replServerMonitorRequestMsg = (MonitorRequestMessage)msg;
                MonitorMessage monitorMsg = new MonitorMessage(replServerMonitorRequestMsg.getDestination(), replServerMonitorRequestMsg.getsenderID());
                for (ServerHandler lsh : this.connectedServers.values()) {
                    monitorMsg.setServerState(lsh.getServerId(), lsh.getServerState(), lsh.getApproxFirstMissingDate(), true);
                }
                for (ServerHandler rsh : this.replicationServers.values()) {
                    monitorMsg.setServerState(rsh.getServerId(), rsh.getServerState(), rsh.getApproxFirstMissingDate(), false);
                }
                monitorMsg.setReplServerDbState(this.getDbServerState());
                try {
                    senderHandler.send(monitorMsg);
                }
                catch (Exception e) {
                    ErrorLogger.logError(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get(Short.toString(msg.getDestination())));
                }
            } else if (msg instanceof MonitorMessage) {
                MonitorMessage monitorMsg = (MonitorMessage)msg;
                this.receivesMonitorDataResponse(monitorMsg);
            } else {
                ErrorLogger.logError(ReplicationMessages.NOTE_ERR_ROUTING_TO_SERVER.get(msg.getClass().getCanonicalName()));
            }
            return;
        }
        List<ServerHandler> servers = this.getDestinationServers(msg, senderHandler);
        if (servers.isEmpty()) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get());
            mb.append(" In Replication Server=" + this.replicationServer.getMonitorInstanceName());
            mb.append(" domain =" + this.baseDn);
            mb.append(" unroutable message =" + msg.toString());
            mb.append(" routing table is empty");
            ErrorMessage errMsg = new ErrorMessage(this.replicationServer.getServerId(), msg.getsenderID(), mb.toMessage());
            ErrorLogger.logError(mb.toMessage());
            try {
                senderHandler.send(errMsg);
            }
            catch (IOException ioe) {
                MessageBuilder mb2 = new MessageBuilder();
                mb2.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_ERROR.get(this.toString()));
                mb2.append(StaticUtils.stackTraceToSingleLineString(ioe));
                ErrorLogger.logError(mb2.toMessage());
                senderHandler.shutdown();
            }
        } else {
            for (ServerHandler targetHandler : servers) {
                try {
                    targetHandler.send(msg);
                }
                catch (IOException ioe) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get(this.toString()));
                    mb.append(StaticUtils.stackTraceToSingleLineString(ioe));
                    mb.append(" ");
                    mb.append(msg.getClass().getCanonicalName());
                    ErrorLogger.logError(mb.toMessage());
                    MessageBuilder mb1 = new MessageBuilder();
                    mb1.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get());
                    mb1.append("serverID:" + msg.getDestination());
                    ErrorMessage errMsg = new ErrorMessage(msg.getsenderID(), mb1.toMessage());
                    try {
                        senderHandler.send(errMsg);
                    }
                    catch (IOException ioe1) {
                        senderHandler.shutdown();
                        targetHandler.shutdown();
                    }
                }
            }
        }
    }

    public void sendAck(ChangeNumber changeNumber, boolean isLDAPserver) {
        short serverId = changeNumber.getServerId();
        this.sendAck(changeNumber, isLDAPserver, serverId);
    }

    public void sendAck(ChangeNumber changeNumber, boolean isLDAPserver, short serverId) {
        ServerHandler handler = isLDAPserver ? this.connectedServers.get(serverId) : this.replicationServers.get(serverId);
        try {
            handler.sendAck(changeNumber);
        }
        catch (IOException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_ACK.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            handler.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (ServerHandler serverHandler : this.replicationServers.values()) {
            serverHandler.shutdown();
        }
        for (ServerHandler serverHandler : this.connectedServers.values()) {
            serverHandler.shutdown();
        }
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                dbHandler.shutdown();
            }
            this.sourceDbHandlers.clear();
        }
    }

    public ServerState getDbServerState() {
        ServerState serverState = new ServerState();
        for (DbHandler db : this.sourceDbHandlers.values()) {
            serverState.update(db.getLastChange());
        }
        return serverState;
    }

    public String toString() {
        return "ReplicationServerDomain " + this.baseDn;
    }

    public void checkAllSaturation() throws IOException {
        for (ServerHandler handler : this.replicationServers.values()) {
            handler.checkWindow();
        }
        for (ServerHandler handler : this.connectedServers.values()) {
            handler.checkWindow();
        }
    }

    public boolean restartAfterSaturation(ServerHandler sourceHandler) {
        for (ServerHandler handler : this.replicationServers.values()) {
            if (handler.restartAfterSaturation(sourceHandler)) continue;
            return false;
        }
        for (ServerHandler handler : this.connectedServers.values()) {
            if (handler.restartAfterSaturation(sourceHandler)) continue;
            return false;
        }
        return true;
    }

    private void sendReplServerInfo() {
        ReplServerInfoMessage info = new ReplServerInfoMessage(this.getConnectedLDAPservers(), this.generationId);
        for (ServerHandler handler : this.replicationServers.values()) {
            try {
                handler.sendInfo(info);
            }
            catch (IOException e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_INFO.get(this.toString()));
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                handler.shutdown();
            }
        }
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public boolean getGenerationIdSavedStatus() {
        return this.generationIdSavedStatus;
    }

    public synchronized void setGenerationId(long generationId, boolean savedStatus) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " RCache.set GenerationId=" + generationId);
        }
        if (this.generationId != generationId) {
            this.clearDbs();
            this.generationId = generationId;
            this.generationIdSavedStatus = savedStatus;
            for (ServerHandler handler : this.connectedServers.values()) {
                if (generationId == handler.getGenerationId()) continue;
                handler.warnBadGenerationId();
            }
        }
    }

    public void resetGenerationId(ServerHandler senderHandler, ResetGenerationId genIdMsg) {
        long newGenId = genIdMsg.getGenerationId();
        if (newGenId != this.generationId) {
            this.setGenerationId(newGenId, false);
        }
        for (ServerHandler rsHandler : this.replicationServers.values()) {
            try {
                rsHandler.setGenerationId(newGenId);
                if (!senderHandler.isLDAPserver()) continue;
                rsHandler.forwardGenerationIdToRS(genIdMsg);
            }
            catch (IOException e) {
                ErrorLogger.logError(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_INFO.get(rsHandler.getMonitorInstanceName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDbs() {
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                try {
                    dbHandler.clear();
                }
                catch (Exception e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(dbHandler.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
                    ErrorLogger.logError(mb.toMessage());
                }
            }
            this.sourceDbHandlers.clear();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " The source db handler has been cleared");
            }
        }
        try {
            this.replicationServer.clearGenerationId(this.baseDn);
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw("Exception caught while clearing generationId:" + e.getLocalizedMessage(), new Object[0]));
        }
    }

    public boolean isDegradedDueToGenerationId(short serverId) {
        ServerHandler handler;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " isDegraded serverId=" + serverId + " given local generation Id=" + this.generationId);
        }
        if ((handler = this.replicationServers.get(serverId)) == null && (handler = this.connectedServers.get(serverId)) == null) {
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " Compute degradation of serverId=" + serverId + " LS server generation Id=" + handler.getGenerationId());
        }
        return handler.getGenerationId() != this.generationId;
    }

    public ReplicationServer getReplicationServer() {
        return this.replicationServer;
    }

    public void receiveReplServerInfo(ReplServerInfoMessage infoMsg, ServerHandler handler) throws IOException {
        if (DebugLogger.debugEnabled() && handler.isReplicationServer()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Receiving replServerInfo from " + handler.getServerId() + " baseDn=" + this.baseDn + " genId=" + infoMsg.getGenerationId());
        }
        this.mayResetGenerationId();
        if (this.generationId < 0L) {
            this.generationId = handler.getGenerationId();
        }
        if (this.generationId > 0L && this.generationId != infoMsg.getGenerationId()) {
            Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID.get(this.baseDn.toNormalizedString(), Short.toString(handler.getServerId()), Long.toString(infoMsg.getGenerationId()), Long.toString(this.generationId));
            ErrorMessage errorMsg = new ErrorMessage(this.getReplicationServer().getServerId(), handler.getServerId(), message);
            handler.sendError(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized MonitorData getMonitorData() throws DirectoryException {
        if (this.monitorData.getBuildDate() + this.monitorDataLifeTime > TimeThread.getTime()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " getRemoteMonitorData in cache");
            }
            return this.monitorData;
        }
        MonitorData monitorData = this.wrkMonitorData = new MonitorData();
        synchronized (monitorData) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Computing monitor data ");
            }
            for (ServerHandler directlsh : this.connectedServers.values()) {
                short serverID = directlsh.getServerId();
                ServerState directlshState = directlsh.getServerState().duplicate();
                ChangeNumber maxcn = directlshState.getMaxChangeNumber(serverID);
                if (maxcn == null) {
                    maxcn = new ChangeNumber(0L, 0, serverID);
                }
                this.wrkMonitorData.setMaxCN(serverID, maxcn);
                this.wrkMonitorData.setLDAPServerState(serverID, directlshState);
                this.wrkMonitorData.setFirstMissingDate(serverID, directlsh.getApproxFirstMissingDate());
            }
            ServerState dbServerState = this.getDbServerState();
            for (short sid : dbServerState) {
                ChangeNumber storedCN = dbServerState.getMaxChangeNumber(sid);
                this.wrkMonitorData.setMaxCN(sid, storedCN);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Local monitor data: " + this.wrkMonitorData.toString());
            }
        }
        if (this.remoteMonitorResponsesSemaphore == null) {
            this.remoteMonitorResponsesSemaphore = new Semaphore(0);
            short requestCnt = this.sendMonitorDataRequest();
            this.waitMonitorDataResponses(requestCnt);
        } else {
            while (this.remoteMonitorResponsesSemaphore != null) {
                this.waitMonitorDataResponses(1);
            }
        }
        this.wrkMonitorData.completeComputing();
        MonitorData monitorData2 = this.monitorData;
        synchronized (monitorData2) {
            this.monitorData = this.wrkMonitorData;
            this.wrkMonitorData = null;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " *** Computed MonitorData: " + this.monitorData.toString());
            }
        }
        return this.monitorData;
    }

    protected short sendMonitorDataRequest() throws DirectoryException {
        short sent = 0;
        try {
            for (ServerHandler rs : this.replicationServers.values()) {
                MonitorRequestMessage msg = new MonitorRequestMessage(this.replicationServer.getServerId(), rs.getServerId());
                rs.send(msg);
                sent = (short)(sent + 1);
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_SENDING_REMOTE_MONITOR_DATA_REQUEST.get();
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, e);
        }
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitMonitorDataResponses(int expectedResponses) throws DirectoryException {
        try {
            boolean allPermitsAcquired;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " waiting for " + expectedResponses + " expected monitor messages");
            }
            if (!(allPermitsAcquired = this.remoteMonitorResponsesSemaphore.tryAcquire(expectedResponses, 5000L, TimeUnit.MILLISECONDS))) {
                ErrorLogger.logError(ReplicationMessages.ERR_MISSING_REMOTE_MONITOR_DATA.get());
            } else if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Successfully received all " + expectedResponses + " expected monitor messages");
            }
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_PROCESSING_REMOTE_MONITOR_DATA.get(e.getMessage()));
        }
        finally {
            this.remoteMonitorResponsesSemaphore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivesMonitorDataResponse(MonitorMessage msg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + "Receiving " + msg + " from " + msg.getsenderID() + this.remoteMonitorResponsesSemaphore);
        }
        if (this.remoteMonitorResponsesSemaphore == null) {
            ErrorLogger.logError(ReplicationMessages.NOTE_IGNORING_REMOTE_MONITOR_DATA.get(Short.toString(msg.getsenderID())));
            return;
        }
        try {
            MonitorData monitorData = this.wrkMonitorData;
            synchronized (monitorData) {
                ServerState replServerState = msg.getReplServerDbState();
                this.wrkMonitorData.setMaxCNs(replServerState);
                Iterator<Short> lsidIterator = msg.ldapIterator();
                while (lsidIterator.hasNext()) {
                    short sid = lsidIterator.next();
                    this.wrkMonitorData.setLDAPServerState(sid, msg.getLDAPServerState(sid).duplicate());
                    this.wrkMonitorData.setFirstMissingDate(sid, msg.getLDAPApproxFirstMissingDate(sid));
                }
                Iterator<Short> rsidIterator = msg.rsIterator();
                while (rsidIterator.hasNext()) {
                    Long newfmd;
                    short rsid = rsidIterator.next();
                    if (rsid == this.replicationServer.getServerId()) {
                        for (ServerHandler connectedlsh : this.connectedServers.values()) {
                            short connectedlsid = connectedlsh.getServerId();
                            newfmd = msg.getRSApproxFirstMissingDate(rsid);
                            this.wrkMonitorData.setFirstMissingDate(connectedlsid, newfmd);
                        }
                        continue;
                    }
                    ServerHandler rsjHdr = this.replicationServers.get(rsid);
                    if (rsjHdr == null) continue;
                    for (short remotelsid : rsjHdr.getConnectedServerIds()) {
                        newfmd = msg.getRSApproxFirstMissingDate(rsid);
                        this.wrkMonitorData.setFirstMissingDate(remotelsid, newfmd);
                    }
                }
                if (DebugLogger.debugEnabled() && DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDn=" + this.baseDn + " Processed msg from " + msg.getsenderID() + " New monitor data: " + this.wrkMonitorData.toString());
                }
            }
            this.remoteMonitorResponsesSemaphore.release();
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_PROCESSING_REMOTE_MONITOR_DATA.get(e.getMessage() + StaticUtils.stackTraceToSingleLineString(e)));
            this.remoteMonitorResponsesSemaphore.notifyAll();
        }
    }

    void setPurgeDelay(long delay) {
        for (DbHandler handler : this.sourceDbHandlers.values()) {
            handler.setPurgeDelay(delay);
        }
    }
}

