/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

public class ObjectIdentifierFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "objectIdentifierFirstComponentMatch";
    }

    public String getOID() {
        return "2.5.13.30";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        String value2String;
        char c;
        int pos;
        String value1String = value1.stringValue();
        int value1Length = value1String.length();
        if (value1Length == 0 || value1String.charAt(0) != '(') {
            return false;
        }
        for (pos = 1; pos < value1Length && (c = value1String.charAt(pos)) == ' '; ++pos) {
        }
        if (pos >= value1Length) {
            return false;
        }
        int startPos = pos++;
        while (pos < value1Length && (c = value1String.charAt(pos)) != ' ') {
            ++pos;
        }
        if (pos >= value1Length) {
            return false;
        }
        String oid = value1String.substring(startPos, pos);
        if (oid.equals(value2String = value2.stringValue())) {
            return true;
        }
        AttributeType attrType1 = DirectoryServer.getAttributeType(oid);
        if (attrType1 != null) {
            AttributeType attrType2 = DirectoryServer.getAttributeType(value2String);
            if (attrType2 == null) {
                return false;
            }
            return attrType1.equals(attrType2);
        }
        ObjectClass oc1 = DirectoryServer.getObjectClass(oid);
        if (oc1 != null) {
            ObjectClass oc2 = DirectoryServer.getObjectClass(value2String);
            if (oc2 == null) {
                return false;
            }
            return oc1.equals(oc2);
        }
        AttributeSyntax syntax1 = DirectoryServer.getAttributeSyntax(oid, false);
        if (syntax1 != null) {
            AttributeSyntax syntax2 = DirectoryServer.getAttributeSyntax(value2String, false);
            if (syntax2 == null) {
                return false;
            }
            return syntax1.equals(syntax2);
        }
        MatchingRule mr1 = DirectoryServer.getMatchingRule(oid);
        if (mr1 != null) {
            MatchingRule mr2 = DirectoryServer.getMatchingRule(value2String);
            if (mr2 == null) {
                return false;
            }
            return mr1.equals(mr2);
        }
        NameForm nf1 = DirectoryServer.getNameForm(oid);
        if (nf1 != null) {
            NameForm nf2 = DirectoryServer.getNameForm(value2String);
            if (nf2 == null) {
                return false;
            }
            return nf1.equals(nf2);
        }
        return false;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        return 1;
    }
}

