/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.MakeLDIFInputStream;
import org.opends.server.tools.makeldif.TemplateFile;

class MakeLDIFInputStreamThread
extends DirectoryThread {
    private MakeLDIFInputStream inputStream;
    private TemplateFile templateFile;

    public MakeLDIFInputStreamThread(MakeLDIFInputStream inputStream, TemplateFile templateFile) {
        super("MakeLDIF Input Stream Thread");
        this.inputStream = inputStream;
        this.templateFile = templateFile;
    }

    public void run() {
        try {
            this.templateFile.generateLDIF(this.inputStream);
        }
        catch (MakeLDIFException mle) {
            this.inputStream.setIOException(new IOException(mle.getMessage()));
            this.inputStream.closeEntryWriter();
        }
        catch (IOException ioe) {
            this.inputStream.setIOException(ioe);
            this.inputStream.closeEntryWriter();
        }
    }
}

