/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.tasks.TaskClient;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.types.LDAPException;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentGroup;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskTool
implements TaskScheduleInformation {
    public static final String NOW = "0";
    private static final int RUN_OFFLINE = 51;
    private static final int RUN_ONLINE = 52;
    private static final int SYNCHRONOUS_TASK_POLL_INTERVAL = 1000;
    LDAPConnectionArgumentParser argParser;
    StringArgument startArg;
    StringArgument completionNotificationArg;
    StringArgument errorNotificationArg;
    StringArgument dependencyArg;
    StringArgument failedDependencyActionArg;
    TaskClient taskClient;
    BooleanArgument testIfOfflineArg;

    protected abstract int processLocal(boolean var1, PrintStream var2, PrintStream var3);

    protected LDAPConnectionArgumentParser createArgParser(String className, Message toolDescription) {
        ArgumentGroup ldapGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_TASK_LDAP_ARGS.get(), 1001);
        this.argParser = new LDAPConnectionArgumentParser(className, toolDescription, false, ldapGroup);
        ArgumentGroup taskGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_TASK_TASK_ARGS.get(), 1000);
        try {
            StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            this.argParser.addArgument(propertiesFileArgument);
            this.argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            this.argParser.addArgument(noPropertiesFileArgument);
            this.argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            this.startArg = new StringArgument("start", ToolConstants.OPTION_SHORT_START_DATETIME, "start", false, false, true, ToolMessages.INFO_START_DATETIME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_START_DATETIME.get());
            this.argParser.addArgument(this.startArg, taskGroup);
            this.completionNotificationArg = new StringArgument("completionNotify", ToolConstants.OPTION_SHORT_COMPLETION_NOTIFICATION_EMAIL, "completionNotify", false, true, true, ToolMessages.INFO_EMAIL_ADDRESS_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_COMPLETION_NOTIFICATION.get());
            this.argParser.addArgument(this.completionNotificationArg, taskGroup);
            this.errorNotificationArg = new StringArgument("errorNotify", ToolConstants.OPTION_SHORT_ERROR_NOTIFICATION_EMAIL, "errorNotify", false, true, true, ToolMessages.INFO_EMAIL_ADDRESS_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_ERROR_NOTIFICATION.get());
            this.argParser.addArgument(this.errorNotificationArg, taskGroup);
            this.dependencyArg = new StringArgument("dependency", ToolConstants.OPTION_SHORT_DEPENDENCY, "dependency", false, true, true, ToolMessages.INFO_TASK_ID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_DEPENDENCY_ID.get());
            this.argParser.addArgument(this.dependencyArg, taskGroup);
            EnumSet<FailedDependencyAction> fdaValSet = EnumSet.allOf(FailedDependencyAction.class);
            this.failedDependencyActionArg = new StringArgument("failedDependencyAction", ToolConstants.OPTION_SHORT_FAILED_DEPENDENCY_ACTION, "failedDependencyAction", false, true, true, ToolMessages.INFO_ACTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_FAILED_DEPENDENCY_ACTION.get(StaticUtils.collectionToString(fdaValSet, ","), FailedDependencyAction.defaultValue().name()));
            this.argParser.addArgument(this.failedDependencyActionArg, taskGroup);
            this.testIfOfflineArg = new BooleanArgument("testIfOffline", null, "testIfOffline", ToolMessages.INFO_DESCRIPTION_TEST_IF_OFFLINE.get());
            this.testIfOfflineArg.setHidden(true);
            this.argParser.addArgument(this.testIfOfflineArg);
        }
        catch (ArgumentException e) {
            // empty catch block
        }
        return this.argParser;
    }

    protected void validateTaskArgs() throws ArgumentException {
        LinkedList<String> addrs;
        if (this.startArg.isPresent() && !NOW.equals(this.startArg.getValue())) {
            try {
                StaticUtils.parseDateTimeString(this.startArg.getValue());
            }
            catch (ParseException pe) {
                throw new ArgumentException(ToolMessages.ERR_START_DATETIME_FORMAT.get());
            }
        }
        if (!this.processAsTask() && this.completionNotificationArg.isPresent()) {
            throw new ArgumentException(ToolMessages.ERR_TASKTOOL_OPTIONS_FOR_TASK_ONLY.get(this.completionNotificationArg.getLongIdentifier()));
        }
        if (!this.processAsTask() && this.errorNotificationArg.isPresent()) {
            throw new ArgumentException(ToolMessages.ERR_TASKTOOL_OPTIONS_FOR_TASK_ONLY.get(this.errorNotificationArg.getLongIdentifier()));
        }
        if (!this.processAsTask() && this.dependencyArg.isPresent()) {
            throw new ArgumentException(ToolMessages.ERR_TASKTOOL_OPTIONS_FOR_TASK_ONLY.get(this.dependencyArg.getLongIdentifier()));
        }
        if (!this.processAsTask() && this.failedDependencyActionArg.isPresent()) {
            throw new ArgumentException(ToolMessages.ERR_TASKTOOL_OPTIONS_FOR_TASK_ONLY.get(this.failedDependencyActionArg.getLongIdentifier()));
        }
        if (this.completionNotificationArg.isPresent()) {
            addrs = this.completionNotificationArg.getValues();
            for (String addr : addrs) {
                if (StaticUtils.isEmailAddress(addr)) continue;
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_INVALID_EMAIL_ADDRESS.get(addr, this.completionNotificationArg.getLongIdentifier()));
            }
        }
        if (this.errorNotificationArg.isPresent()) {
            addrs = this.errorNotificationArg.getValues();
            for (String addr : addrs) {
                if (StaticUtils.isEmailAddress(addr)) continue;
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_INVALID_EMAIL_ADDRESS.get(addr, this.errorNotificationArg.getLongIdentifier()));
            }
        }
        if (this.failedDependencyActionArg.isPresent()) {
            if (!this.dependencyArg.isPresent()) {
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_FDA_WITH_NO_DEPENDENCY.get());
            }
            String fda = this.failedDependencyActionArg.getValue();
            if (null == FailedDependencyAction.fromString(fda)) {
                EnumSet<FailedDependencyAction> fdaValSet = EnumSet.allOf(FailedDependencyAction.class);
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_INVALID_FDA.get(fda, StaticUtils.collectionToString(fdaValSet, ",")));
            }
        }
    }

    @Override
    public Date getStartDateTime() {
        Date start = null;
        if (this.startArg != null && this.startArg.isPresent()) {
            if (NOW.equals(this.startArg.getValue())) {
                start = new Date();
            } else {
                try {
                    start = StaticUtils.parseDateTimeString(this.startArg.getValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return start;
    }

    @Override
    public List<String> getDependencyIds() {
        if (this.dependencyArg.isPresent()) {
            return this.dependencyArg.getValues();
        }
        return Collections.emptyList();
    }

    @Override
    public FailedDependencyAction getFailedDependencyAction() {
        FailedDependencyAction fda = null;
        if (this.failedDependencyActionArg.isPresent()) {
            String fdaString = this.failedDependencyActionArg.getValue();
            fda = FailedDependencyAction.fromString(fdaString);
        }
        return fda;
    }

    @Override
    public List<String> getNotifyUponCompletionEmailAddresses() {
        if (this.completionNotificationArg.isPresent()) {
            return this.completionNotificationArg.getValues();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getNotifyUponErrorEmailAddresses() {
        if (this.errorNotificationArg.isPresent()) {
            return this.errorNotificationArg.getValues();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int process(LDAPConnectionArgumentParser argParser, boolean initializeServer, PrintStream out, PrintStream err) {
        int ret;
        if (this.testIfOffline()) {
            if (!this.processAsTask()) {
                return 51;
            }
            return 52;
        }
        if (this.processAsTask()) {
            Message message;
            if (initializeServer) {
                try {
                    DirectoryServer.bootstrapClient();
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    Message message2 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            LDAPConnection conn = null;
            try {
                conn = argParser.connect(out, err);
                TaskClient tc = new TaskClient(conn);
                TaskEntry taskEntry = tc.schedule(this);
                Message startTime = taskEntry.getScheduledStartTime();
                if (startTime == null || startTime.length() == 0) {
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_SCHEDULED_NOW.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                } else {
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_SCHEDULED_FUTURE.get(taskEntry.getType(), taskEntry.getId(), taskEntry.getScheduledStartTime()), ServerConstants.MAX_LINE_WIDTH));
                }
                if (!this.startArg.isPresent()) {
                    String taskId = taskEntry.getId();
                    HashSet<Message> printedLogMessages = new HashSet<Message>();
                    do {
                        taskEntry = tc.getTaskEntry(taskId);
                        List<Message> logs = taskEntry.getLogMessages();
                        for (Message log : logs) {
                            if (printedLogMessages.contains(log)) continue;
                            printedLogMessages.add(log);
                            out.println(log);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (!taskEntry.isDone());
                    if (TaskState.isSuccessful(taskEntry.getTaskState())) {
                        out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_SUCESSFULL.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                        int n = 0;
                        return n;
                    }
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_NOT_SUCESSFULL.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    return n;
                }
                ret = 0;
            }
            catch (LDAPConnectionException e) {
                message = ToolMessages.ERR_TASK_TOOL_START_TIME_NO_LDAP.get(e.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (IOException ioe) {
                message = ToolMessages.ERR_TASK_TOOL_IO_ERROR.get(String.valueOf(ioe));
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (ASN1Exception ae) {
                message = ToolMessages.ERR_TASK_TOOL_DECODE_ERROR.get(ae.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (LDAPException le) {
                message = ToolMessages.ERR_TASK_TOOL_DECODE_ERROR.get(le.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (OpenDsException e) {
                message = e.getMessageObject();
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close(null);
                    }
                    catch (Throwable t) {}
                }
            }
        } else {
            ret = this.processLocal(initializeServer, out, err);
        }
        return ret;
    }

    private boolean processAsTask() {
        return this.argParser.connectionArgumentsPresent();
    }

    private boolean testIfOffline() {
        boolean returnValue = false;
        if (this.testIfOfflineArg != null) {
            returnValue = this.testIfOfflineArg.isPresent();
        }
        return returnValue;
    }
}

