/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class AttributeValue {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString normalizedValue;
    private final ByteString value;
    private final AttributeType attributeType;

    public AttributeValue(AttributeType attributeType, ByteString value) {
        Validator.ensureNotNull(attributeType, value);
        this.attributeType = attributeType;
        this.value = value;
        this.normalizedValue = null;
    }

    public AttributeValue(AttributeType attributeType, String value) {
        Validator.ensureNotNull(attributeType, value);
        this.attributeType = attributeType;
        this.value = new ASN1OctetString(value);
        this.normalizedValue = null;
    }

    public AttributeValue(ByteString value, ByteString normalizedValue) {
        Validator.ensureNotNull(value, normalizedValue);
        this.value = value;
        this.normalizedValue = normalizedValue;
        this.attributeType = null;
    }

    public ByteString getValue() {
        return this.value;
    }

    public byte[] getValueBytes() {
        return this.value.value();
    }

    public String getStringValue() {
        return this.value.stringValue();
    }

    public ByteString getNormalizedValue() throws DirectoryException {
        if (this.normalizedValue == null) {
            this.normalizedValue = this.attributeType.normalize(this.value);
        }
        return this.normalizedValue;
    }

    public byte[] getNormalizedValueBytes() throws DirectoryException {
        return this.getNormalizedValue().value();
    }

    public String getNormalizedStringValue() throws DirectoryException {
        if (this.normalizedValue == null) {
            this.normalizedValue = this.attributeType.normalize(this.value);
        }
        return this.normalizedValue.stringValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof AttributeValue) {
            AttributeValue attrValue = (AttributeValue)o;
            try {
                if (this.attributeType != null) {
                    EqualityMatchingRule matchingRule = this.attributeType.getEqualityMatchingRule();
                    if (matchingRule == null) {
                        return this.getNormalizedValue().equals(attrValue.getNormalizedValue());
                    }
                    return matchingRule.valuesMatch(this.getNormalizedValue(), attrValue.getNormalizedValue()) == ConditionResult.TRUE;
                }
                if (attrValue.attributeType != null) {
                    EqualityMatchingRule matchingRule = attrValue.attributeType.getEqualityMatchingRule();
                    if (matchingRule == null) {
                        return this.getNormalizedValue().equals(attrValue.getNormalizedValue());
                    }
                    return matchingRule.valuesMatch(this.getNormalizedValue(), attrValue.getNormalizedValue()) == ConditionResult.TRUE;
                }
                return this.normalizedValue.equals(attrValue.getNormalizedValue());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return this.value.equals(attrValue.getValue());
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            if (this.attributeType == null) {
                if (this.normalizedValue != null) {
                    return this.normalizedValue.hashCode();
                }
                return this.value.hashCode();
            }
            return this.attributeType.generateHashCode(this);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return this.value.hashCode();
        }
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.stringValue();
    }

    public void toString(StringBuilder buffer) {
        buffer.append(((Object)this.value).toString());
    }
}

