/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.util.args.Argument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentGroup
implements Comparable<ArgumentGroup> {
    private Message description = null;
    private List<Argument> args = null;
    private Integer priority;

    public ArgumentGroup(Message description, int priority) {
        this.description = description;
        this.priority = priority;
        this.args = new LinkedList<Argument>();
    }

    public Message getDescription() {
        return this.description;
    }

    public void setDescription(Message description) {
        this.description = description;
    }

    List<Argument> getArguments() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public int compareTo(ArgumentGroup o) {
        return -1 * this.priority.compareTo(o.priority);
    }

    boolean containsArguments() {
        return this.args.size() > 0;
    }

    boolean containsNonHiddenArguments() {
        for (Argument arg : this.args) {
            if (arg.isHidden()) continue;
            return true;
        }
        return false;
    }

    boolean addArgument(Argument arg) {
        boolean success = false;
        if (arg != null) {
            Character newShort = arg.getShortIdentifier();
            String newLong = arg.getLongIdentifier();
            Iterator<Argument> it = this.args.iterator();
            while (it.hasNext()) {
                Argument a = it.next();
                if ((newShort == null || !newShort.equals(a.getShortIdentifier())) && (newLong == null || !newLong.equals(a.getLongIdentifier()))) continue;
                it.remove();
                break;
            }
            success = this.args.add(arg);
        }
        return success;
    }

    boolean removeArgument(Argument arg) {
        return this.args.remove(arg);
    }
}

