/*
 * Copyright 1999,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

/* Generated By:JJTree&JavaCC: Do not edit this line. Parser.java */
package org.apache.taglibs.standard.lang.jpath.expression;

import java.io.StringReader;

public class Parser/*@bgen(jjtree)*/implements ParserTreeConstants, ParserConstants {/*@bgen(jjtree)*/
  protected JJTParserState jjtree = new JJTParserState();public static Expression parse(String expressionText)
            throws ParseException {
        Parser parser;
        Expression expression;
        parser = new Parser(new StringReader(expressionText));
        parser.Expression();
        expression  = (Expression)parser.jjtree.rootNode();
        return expression;
    }

    void jjtreeOpenNodeScope(Node n) {
        ((SimpleNode)n).firstToken = getToken(0);
    }

    void jjtreeCloseNodeScope(Node n) {
        ((SimpleNode)n).lastToken = getToken(0);
    }

/*
 * Expression syntax follows.
 */
  final public void Expression() throws ParseException {
 /*@bgen(jjtree) #Expression( 1) */
  Expression jjtn000 = new Expression(JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      Expr();
      jj_consume_token(0);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  1);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/* [1] Expr ::= OrExpr */
  final public void Expr() throws ParseException {
    OrExpr();
  }

/* [2] OrExpr ::= AndExpr ( 'or' AndExpr )* */
  final public void OrExpr() throws ParseException {
    AndExpr();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
           OrOperator jjtn001 = new OrOperator(JJTOROPERATOR);
           boolean jjtc001 = true;
           jjtree.openNodeScope(jjtn001);
           jjtreeOpenNodeScope(jjtn001);
      try {
        AndExpr();
      } catch (Throwable jjte001) {
           if (jjtc001) {
             jjtree.clearNodeScope(jjtn001);
             jjtc001 = false;
           } else {
             jjtree.popNode();
           }
           if (jjte001 instanceof RuntimeException) {
             {if (true) throw (RuntimeException)jjte001;}
           }
           if (jjte001 instanceof ParseException) {
             {if (true) throw (ParseException)jjte001;}
           }
           {if (true) throw (Error)jjte001;}
      } finally {
           if (jjtc001) {
             jjtree.closeNodeScope(jjtn001,  2);
             jjtreeCloseNodeScope(jjtn001);
           }
      }
    }
  }

/* [3] AndExpr ::= EqualityExpr ( 'and' EqualityExpr )* */
  final public void AndExpr() throws ParseException {
    EqualityExpr();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
            AndOperator jjtn001 = new AndOperator(JJTANDOPERATOR);
            boolean jjtc001 = true;
            jjtree.openNodeScope(jjtn001);
            jjtreeOpenNodeScope(jjtn001);
      try {
        EqualityExpr();
      } catch (Throwable jjte001) {
            if (jjtc001) {
              jjtree.clearNodeScope(jjtn001);
              jjtc001 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte001 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte001;}
            }
            if (jjte001 instanceof ParseException) {
              {if (true) throw (ParseException)jjte001;}
            }
            {if (true) throw (Error)jjte001;}
      } finally {
            if (jjtc001) {
              jjtree.closeNodeScope(jjtn001,  2);
              jjtreeCloseNodeScope(jjtn001);
            }
      }
    }
  }

/* [4] EqualityExpr ::= RelationalExpr ( ( '=' | '!-' ) RelationExpr )* */
  final public void EqualityExpr() throws ParseException {
    RelationalExpr();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NEQ:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
            EqualsOperator jjtn001 = new EqualsOperator(JJTEQUALSOPERATOR);
            boolean jjtc001 = true;
            jjtree.openNodeScope(jjtn001);
            jjtreeOpenNodeScope(jjtn001);
        try {
          RelationalExpr();
        } catch (Throwable jjte001) {
            if (jjtc001) {
              jjtree.clearNodeScope(jjtn001);
              jjtc001 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte001 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte001;}
            }
            if (jjte001 instanceof ParseException) {
              {if (true) throw (ParseException)jjte001;}
            }
            {if (true) throw (Error)jjte001;}
        } finally {
            if (jjtc001) {
              jjtree.closeNodeScope(jjtn001,  2);
              jjtreeCloseNodeScope(jjtn001);
            }
        }
        break;
      case NEQ:
        jj_consume_token(NEQ);
             NotEqualsOperator jjtn002 = new NotEqualsOperator(JJTNOTEQUALSOPERATOR);
             boolean jjtc002 = true;
             jjtree.openNodeScope(jjtn002);
             jjtreeOpenNodeScope(jjtn002);
        try {
          RelationalExpr();
        } catch (Throwable jjte002) {
             if (jjtc002) {
               jjtree.clearNodeScope(jjtn002);
               jjtc002 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte002 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte002;}
             }
             if (jjte002 instanceof ParseException) {
               {if (true) throw (ParseException)jjte002;}
             }
             {if (true) throw (Error)jjte002;}
        } finally {
             if (jjtc002) {
               jjtree.closeNodeScope(jjtn002,  2);
               jjtreeCloseNodeScope(jjtn002);
             }
        }
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* [5] RelationalExpr ::= AdditiveExpr ( ( '<' | '>' | '<=' | '>=' ) AdditiveExpr )* */
  final public void RelationalExpr() throws ParseException {
    AdditiveExpr();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
      case LTE:
      case GT:
      case GTE:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        jj_consume_token(LT);
           LessThanOperator jjtn001 = new LessThanOperator(JJTLESSTHANOPERATOR);
           boolean jjtc001 = true;
           jjtree.openNodeScope(jjtn001);
           jjtreeOpenNodeScope(jjtn001);
        try {
          AdditiveExpr();
        } catch (Throwable jjte001) {
           if (jjtc001) {
             jjtree.clearNodeScope(jjtn001);
             jjtc001 = false;
           } else {
             jjtree.popNode();
           }
           if (jjte001 instanceof RuntimeException) {
             {if (true) throw (RuntimeException)jjte001;}
           }
           if (jjte001 instanceof ParseException) {
             {if (true) throw (ParseException)jjte001;}
           }
           {if (true) throw (Error)jjte001;}
        } finally {
           if (jjtc001) {
             jjtree.closeNodeScope(jjtn001,  2);
             jjtreeCloseNodeScope(jjtn001);
           }
        }
        break;
      case GT:
        jj_consume_token(GT);
           GreaterThanOperator jjtn002 = new GreaterThanOperator(JJTGREATERTHANOPERATOR);
           boolean jjtc002 = true;
           jjtree.openNodeScope(jjtn002);
           jjtreeOpenNodeScope(jjtn002);
        try {
          AdditiveExpr();
        } catch (Throwable jjte002) {
           if (jjtc002) {
             jjtree.clearNodeScope(jjtn002);
             jjtc002 = false;
           } else {
             jjtree.popNode();
           }
           if (jjte002 instanceof RuntimeException) {
             {if (true) throw (RuntimeException)jjte002;}
           }
           if (jjte002 instanceof ParseException) {
             {if (true) throw (ParseException)jjte002;}
           }
           {if (true) throw (Error)jjte002;}
        } finally {
           if (jjtc002) {
             jjtree.closeNodeScope(jjtn002,  2);
             jjtreeCloseNodeScope(jjtn002);
           }
        }
        break;
      case LTE:
        jj_consume_token(LTE);
            LessThanEqualOperator jjtn003 = new LessThanEqualOperator(JJTLESSTHANEQUALOPERATOR);
            boolean jjtc003 = true;
            jjtree.openNodeScope(jjtn003);
            jjtreeOpenNodeScope(jjtn003);
        try {
          AdditiveExpr();
        } catch (Throwable jjte003) {
            if (jjtc003) {
              jjtree.clearNodeScope(jjtn003);
              jjtc003 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte003 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte003;}
            }
            if (jjte003 instanceof ParseException) {
              {if (true) throw (ParseException)jjte003;}
            }
            {if (true) throw (Error)jjte003;}
        } finally {
            if (jjtc003) {
              jjtree.closeNodeScope(jjtn003,  2);
              jjtreeCloseNodeScope(jjtn003);
            }
        }
        break;
      case GTE:
        jj_consume_token(GTE);
            GreaterThanEqualOperator jjtn004 = new GreaterThanEqualOperator(JJTGREATERTHANEQUALOPERATOR);
            boolean jjtc004 = true;
            jjtree.openNodeScope(jjtn004);
            jjtreeOpenNodeScope(jjtn004);
        try {
          AdditiveExpr();
        } catch (Throwable jjte004) {
            if (jjtc004) {
              jjtree.clearNodeScope(jjtn004);
              jjtc004 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte004 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte004;}
            }
            if (jjte004 instanceof ParseException) {
              {if (true) throw (ParseException)jjte004;}
            }
            {if (true) throw (Error)jjte004;}
        } finally {
            if (jjtc004) {
              jjtree.closeNodeScope(jjtn004,  2);
              jjtreeCloseNodeScope(jjtn004);
            }
        }
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* [6] AdditiveExpr ::= MultiplicitiveExpr ( ( '+' | '-' ) MultiplicitiveExpr )* */
  final public void AdditiveExpr() throws ParseException {
    MultiplicativeExpr();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
             AdditionOperator jjtn001 = new AdditionOperator(JJTADDITIONOPERATOR);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
        try {
          MultiplicativeExpr();
        } catch (Throwable jjte001) {
             if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte001;}
             }
             if (jjte001 instanceof ParseException) {
               {if (true) throw (ParseException)jjte001;}
             }
             {if (true) throw (Error)jjte001;}
        } finally {
             if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  2);
               jjtreeCloseNodeScope(jjtn001);
             }
        }
        break;
      case MINUS:
        jj_consume_token(MINUS);
              SubtractionOperator jjtn002 = new SubtractionOperator(JJTSUBTRACTIONOPERATOR);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
        try {
          MultiplicativeExpr();
        } catch (Throwable jjte002) {
              if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte002;}
              }
              if (jjte002 instanceof ParseException) {
                {if (true) throw (ParseException)jjte002;}
              }
              {if (true) throw (Error)jjte002;}
        } finally {
              if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  2);
                jjtreeCloseNodeScope(jjtn002);
              }
        }
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* [7] MultiplicitiveExpr ::= UnaryExpr ( ( '*' | '/' | '%' ) UnaryExpr )* */
  final public void MultiplicativeExpr() throws ParseException {
    UnaryExpr();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIV:
      case MULT:
      case MOD:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULT:
        jj_consume_token(MULT);
             MultiplicationOperator jjtn001 = new MultiplicationOperator(JJTMULTIPLICATIONOPERATOR);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
        try {
          UnaryExpr();
        } catch (Throwable jjte001) {
             if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte001;}
             }
             if (jjte001 instanceof ParseException) {
               {if (true) throw (ParseException)jjte001;}
             }
             {if (true) throw (Error)jjte001;}
        } finally {
             if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  2);
               jjtreeCloseNodeScope(jjtn001);
             }
        }
        break;
      case DIV:
        jj_consume_token(DIV);
            DivisionOperator jjtn002 = new DivisionOperator(JJTDIVISIONOPERATOR);
            boolean jjtc002 = true;
            jjtree.openNodeScope(jjtn002);
            jjtreeOpenNodeScope(jjtn002);
        try {
          UnaryExpr();
        } catch (Throwable jjte002) {
            if (jjtc002) {
              jjtree.clearNodeScope(jjtn002);
              jjtc002 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte002 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte002;}
            }
            if (jjte002 instanceof ParseException) {
              {if (true) throw (ParseException)jjte002;}
            }
            {if (true) throw (Error)jjte002;}
        } finally {
            if (jjtc002) {
              jjtree.closeNodeScope(jjtn002,  2);
              jjtreeCloseNodeScope(jjtn002);
            }
        }
        break;
      case MOD:
        jj_consume_token(MOD);
            ModulusOperator jjtn003 = new ModulusOperator(JJTMODULUSOPERATOR);
            boolean jjtc003 = true;
            jjtree.openNodeScope(jjtn003);
            jjtreeOpenNodeScope(jjtn003);
        try {
          UnaryExpr();
        } catch (Throwable jjte003) {
            if (jjtc003) {
              jjtree.clearNodeScope(jjtn003);
              jjtc003 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte003 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte003;}
            }
            if (jjte003 instanceof ParseException) {
              {if (true) throw (ParseException)jjte003;}
            }
            {if (true) throw (Error)jjte003;}
        } finally {
            if (jjtc003) {
              jjtree.closeNodeScope(jjtn003,  2);
              jjtreeCloseNodeScope(jjtn003);
            }
        }
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* [7] UnaryExpr ::= UnionExpr | '-' UnaryExpr */
  final public void UnaryExpr() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIST_BEGIN:
    case FUNCTION_BEGIN:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case SCOPE_LIMIT_NAME:
    case BOOLEAN_LITERAL:
    case STRING_LITERAL:
    case NUMBER_LITERAL:
    case IDENTIFIER:
      UnionExpr();
      break;
    case MINUS:
      jj_consume_token(MINUS);
      UnaryExpr();
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [7] UnionExpr ::= IntrospectiveExpr ( '|' IntrospectiveExpr )* */
  final public void UnionExpr() throws ParseException {
    IntrospectiveExpr();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNION:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_7;
      }
      jj_consume_token(UNION);
                                  UnionOperator jjtn001 = new UnionOperator(JJTUNIONOPERATOR);
                                  boolean jjtc001 = true;
                                  jjtree.openNodeScope(jjtn001);
                                  jjtreeOpenNodeScope(jjtn001);
      try {
        IntrospectiveExpr();
      } catch (Throwable jjte001) {
                                  if (jjtc001) {
                                    jjtree.clearNodeScope(jjtn001);
                                    jjtc001 = false;
                                  } else {
                                    jjtree.popNode();
                                  }
                                  if (jjte001 instanceof RuntimeException) {
                                    {if (true) throw (RuntimeException)jjte001;}
                                  }
                                  if (jjte001 instanceof ParseException) {
                                    {if (true) throw (ParseException)jjte001;}
                                  }
                                  {if (true) throw (Error)jjte001;}
      } finally {
                                  if (jjtc001) {
                                    jjtree.closeNodeScope(jjtn001,  2);
                                    jjtreeCloseNodeScope(jjtn001);
                                  }
      }
    }
  }

/* [7] IntrospectiveExpr ::= PathExpr ( '.' PathExpr )* */
  final public void IntrospectiveExpr() throws ParseException {
    PathExpr();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTROSPECT:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_8;
      }
      jj_consume_token(INTROSPECT);
                   IntrospectionOperator jjtn001 = new IntrospectionOperator(JJTINTROSPECTIONOPERATOR);
                   boolean jjtc001 = true;
                   jjtree.openNodeScope(jjtn001);
                   jjtreeOpenNodeScope(jjtn001);
      try {
        PathExpr();
      } catch (Throwable jjte001) {
                   if (jjtc001) {
                     jjtree.clearNodeScope(jjtn001);
                     jjtc001 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte001 instanceof RuntimeException) {
                     {if (true) throw (RuntimeException)jjte001;}
                   }
                   if (jjte001 instanceof ParseException) {
                     {if (true) throw (ParseException)jjte001;}
                   }
                   {if (true) throw (Error)jjte001;}
      } finally {
                   if (jjtc001) {
                     jjtree.closeNodeScope(jjtn001,  2);
                     jjtreeCloseNodeScope(jjtn001);
                   }
      }
    }
  }

/* [7] PathExpr ::= FilterExpr */
  final public void PathExpr() throws ParseException {
    FilterExpr();
  }

/* [7] FilterExpr ::= PrimaryExpr ( Predicate )* */
  final public void FilterExpr() throws ParseException {
    PrimaryExpr();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PREDICATE_BEGIN:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_9;
      }
                  FilterOperator jjtn001 = new FilterOperator(JJTFILTEROPERATOR);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        Predicate();
      } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001,  2);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
    }
  }

/* [] Predicate ::= '[' PredicateExpr ']' */
  final public void Predicate() throws ParseException {
 /*@bgen(jjtree) #Predicate( 1) */
  Predicate jjtn000 = new Predicate(JJTPREDICATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(PREDICATE_BEGIN);
      PredicateExpr();
      jj_consume_token(PREDICATE_END);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  1);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/* [] PredicateExpr ::= Expr */
  final public void PredicateExpr() throws ParseException {
    Expr();
  }

/* [7] PrimaryExpr ::= Literal | '(' Expr ')' | FunctionCall | ScopeLimitExpr | Identifier */
  final public void PrimaryExpr() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIST_BEGIN:
    case BOOLEAN_LITERAL:
    case STRING_LITERAL:
    case NUMBER_LITERAL:
      Literal();
      break;
    case FUNCTION_BEGIN:
      jj_consume_token(FUNCTION_BEGIN);
      Expr();
      jj_consume_token(FUNCTION_END);
      break;
    default:
      jj_la1[14] = jj_gen;
      if (jj_2_1(2)) {
        Function();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE_LIMIT_NAME:
          ScopeLimitExpr();
          break;
        default:
          jj_la1[15] = jj_gen;
          if (jj_2_2(2)) {
            Identifier();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

/* FunctionCall ::= FunctionName '(' ( Argument ( ',' Argument)*)? ')'  */
/* FunctionName ::= 'boolean' | 'number' | 'string' | 'not' | ...  */
  final public void Function() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 29:
      jj_consume_token(29);
      Argument();
                           BooleanFunction jjtn001 = new BooleanFunction(JJTBOOLEANFUNCTION);
                           boolean jjtc001 = true;
                           jjtree.openNodeScope(jjtn001);
                           jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                           if (jjtc001) {
                             jjtree.closeNodeScope(jjtn001,  1);
                             jjtreeCloseNodeScope(jjtn001);
                           }
      }
      break;
    case 30:
      jj_consume_token(30);
      Argument();
                          NumberFunction jjtn002 = new NumberFunction(JJTNUMBERFUNCTION);
                          boolean jjtc002 = true;
                          jjtree.openNodeScope(jjtn002);
                          jjtreeOpenNodeScope(jjtn002);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                          if (jjtc002) {
                            jjtree.closeNodeScope(jjtn002,  1);
                            jjtreeCloseNodeScope(jjtn002);
                          }
      }
      break;
    case 31:
      jj_consume_token(31);
      Argument();
                          StringFunction jjtn003 = new StringFunction(JJTSTRINGFUNCTION);
                          boolean jjtc003 = true;
                          jjtree.openNodeScope(jjtn003);
                          jjtreeOpenNodeScope(jjtn003);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                          if (jjtc003) {
                            jjtree.closeNodeScope(jjtn003,  1);
                            jjtreeCloseNodeScope(jjtn003);
                          }
      }
      break;
    case 32:
      jj_consume_token(32);
      Argument();
                       NotFunction jjtn004 = new NotFunction(JJTNOTFUNCTION);
                       boolean jjtc004 = true;
                       jjtree.openNodeScope(jjtn004);
                       jjtreeOpenNodeScope(jjtn004);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                       if (jjtc004) {
                         jjtree.closeNodeScope(jjtn004,  1);
                         jjtreeCloseNodeScope(jjtn004);
                       }
      }
      break;
    case 33:
      jj_consume_token(33);
      Argument();
                         FloorFunction jjtn005 = new FloorFunction(JJTFLOORFUNCTION);
                         boolean jjtc005 = true;
                         jjtree.openNodeScope(jjtn005);
                         jjtreeOpenNodeScope(jjtn005);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                         if (jjtc005) {
                           jjtree.closeNodeScope(jjtn005,  1);
                           jjtreeCloseNodeScope(jjtn005);
                         }
      }
      break;
    case 34:
      jj_consume_token(34);
      Argument();
                           CeilingFunction jjtn006 = new CeilingFunction(JJTCEILINGFUNCTION);
                           boolean jjtc006 = true;
                           jjtree.openNodeScope(jjtn006);
                           jjtreeOpenNodeScope(jjtn006);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                           if (jjtc006) {
                             jjtree.closeNodeScope(jjtn006,  1);
                             jjtreeCloseNodeScope(jjtn006);
                           }
      }
      break;
    case 35:
      jj_consume_token(35);
      Argument();
                         RoundFunction jjtn007 = new RoundFunction(JJTROUNDFUNCTION);
                         boolean jjtc007 = true;
                         jjtree.openNodeScope(jjtn007);
                         jjtreeOpenNodeScope(jjtn007);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                         if (jjtc007) {
                           jjtree.closeNodeScope(jjtn007,  1);
                           jjtreeCloseNodeScope(jjtn007);
                         }
      }
      break;
    case 36:
     FormatNumberFunction jjtn008 = new FormatNumberFunction(JJTFORMATNUMBERFUNCTION);
     boolean jjtc008 = true;
     jjtree.openNodeScope(jjtn008);
     jjtreeOpenNodeScope(jjtn008);
      try {
        jj_consume_token(36);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEPARATOR:
          jj_consume_token(SEPARATOR);
          Argument();
          break;
        default:
          jj_la1[16] = jj_gen;
          ;
        }
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte008) {
     if (jjtc008) {
       jjtree.clearNodeScope(jjtn008);
       jjtc008 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte008 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte008;}
     }
     if (jjte008 instanceof ParseException) {
       {if (true) throw (ParseException)jjte008;}
     }
     {if (true) throw (Error)jjte008;}
      } finally {
     if (jjtc008) {
       jjtree.closeNodeScope(jjtn008, jjtree.nodeArity() > 1);
       jjtreeCloseNodeScope(jjtn008);
     }
      }
      break;
    case 37:
     ConcatFunction jjtn009 = new ConcatFunction(JJTCONCATFUNCTION);
     boolean jjtc009 = true;
     jjtree.openNodeScope(jjtn009);
     jjtreeOpenNodeScope(jjtn009);
      try {
        jj_consume_token(37);
        Argument();
        label_10:
        while (true) {
          jj_consume_token(SEPARATOR);
          Argument();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEPARATOR:
            ;
            break;
          default:
            jj_la1[17] = jj_gen;
            break label_10;
          }
        }
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte009) {
     if (jjtc009) {
       jjtree.clearNodeScope(jjtn009);
       jjtc009 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte009 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte009;}
     }
     if (jjte009 instanceof ParseException) {
       {if (true) throw (ParseException)jjte009;}
     }
     {if (true) throw (Error)jjte009;}
      } finally {
     if (jjtc009) {
       jjtree.closeNodeScope(jjtn009, jjtree.nodeArity() > 1);
       jjtreeCloseNodeScope(jjtn009);
     }
      }
      break;
    case 38:
      jj_consume_token(38);
      Argument();
                              EncodeUrlFunction jjtn010 = new EncodeUrlFunction(JJTENCODEURLFUNCTION);
                              boolean jjtc010 = true;
                              jjtree.openNodeScope(jjtn010);
                              jjtreeOpenNodeScope(jjtn010);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                              if (jjtc010) {
                                jjtree.closeNodeScope(jjtn010,  1);
                                jjtreeCloseNodeScope(jjtn010);
                              }
      }
      break;
    case 39:
      jj_consume_token(39);
      Argument();
                               EncodeHtmlFunction jjtn011 = new EncodeHtmlFunction(JJTENCODEHTMLFUNCTION);
                               boolean jjtc011 = true;
                               jjtree.openNodeScope(jjtn011);
                               jjtreeOpenNodeScope(jjtn011);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                               if (jjtc011) {
                                 jjtree.closeNodeScope(jjtn011,  1);
                                 jjtreeCloseNodeScope(jjtn011);
                               }
      }
      break;
    case 40:
      jj_consume_token(40);
      Argument();
                                 StringLengthFunction jjtn012 = new StringLengthFunction(JJTSTRINGLENGTHFUNCTION);
                                 boolean jjtc012 = true;
                                 jjtree.openNodeScope(jjtn012);
                                 jjtreeOpenNodeScope(jjtn012);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                                 if (jjtc012) {
                                   jjtree.closeNodeScope(jjtn012,  1);
                                   jjtreeCloseNodeScope(jjtn012);
                                 }
      }
      break;
    case 41:
     SubstringFunction jjtn013 = new SubstringFunction(JJTSUBSTRINGFUNCTION);
     boolean jjtc013 = true;
     jjtree.openNodeScope(jjtn013);
     jjtreeOpenNodeScope(jjtn013);
      try {
        jj_consume_token(41);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEPARATOR:
          jj_consume_token(SEPARATOR);
          Argument();
          break;
        default:
          jj_la1[18] = jj_gen;
          ;
        }
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte013) {
     if (jjtc013) {
       jjtree.clearNodeScope(jjtn013);
       jjtc013 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte013 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte013;}
     }
     if (jjte013 instanceof ParseException) {
       {if (true) throw (ParseException)jjte013;}
     }
     {if (true) throw (Error)jjte013;}
      } finally {
     if (jjtc013) {
       jjtree.closeNodeScope(jjtn013, jjtree.nodeArity() > 1);
       jjtreeCloseNodeScope(jjtn013);
     }
      }
      break;
    case 42:
     StartsWithFunction jjtn014 = new StartsWithFunction(JJTSTARTSWITHFUNCTION);
     boolean jjtc014 = true;
     jjtree.openNodeScope(jjtn014);
     jjtreeOpenNodeScope(jjtn014);
      try {
        jj_consume_token(42);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte014) {
     if (jjtc014) {
       jjtree.clearNodeScope(jjtn014);
       jjtc014 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte014 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte014;}
     }
     if (jjte014 instanceof ParseException) {
       {if (true) throw (ParseException)jjte014;}
     }
     {if (true) throw (Error)jjte014;}
      } finally {
     if (jjtc014) {
       jjtree.closeNodeScope(jjtn014,  2);
       jjtreeCloseNodeScope(jjtn014);
     }
      }
      break;
    case 43:
     ContainsFunction jjtn015 = new ContainsFunction(JJTCONTAINSFUNCTION);
     boolean jjtc015 = true;
     jjtree.openNodeScope(jjtn015);
     jjtreeOpenNodeScope(jjtn015);
      try {
        jj_consume_token(43);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte015) {
     if (jjtc015) {
       jjtree.clearNodeScope(jjtn015);
       jjtc015 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte015 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte015;}
     }
     if (jjte015 instanceof ParseException) {
       {if (true) throw (ParseException)jjte015;}
     }
     {if (true) throw (Error)jjte015;}
      } finally {
     if (jjtc015) {
       jjtree.closeNodeScope(jjtn015,  2);
       jjtreeCloseNodeScope(jjtn015);
     }
      }
      break;
    case 44:
     SubstringBeforeFunction jjtn016 = new SubstringBeforeFunction(JJTSUBSTRINGBEFOREFUNCTION);
     boolean jjtc016 = true;
     jjtree.openNodeScope(jjtn016);
     jjtreeOpenNodeScope(jjtn016);
      try {
        jj_consume_token(44);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte016) {
     if (jjtc016) {
       jjtree.clearNodeScope(jjtn016);
       jjtc016 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte016 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte016;}
     }
     if (jjte016 instanceof ParseException) {
       {if (true) throw (ParseException)jjte016;}
     }
     {if (true) throw (Error)jjte016;}
      } finally {
     if (jjtc016) {
       jjtree.closeNodeScope(jjtn016,  2);
       jjtreeCloseNodeScope(jjtn016);
     }
      }
      break;
    case 45:
     SubstringAfterFunction jjtn017 = new SubstringAfterFunction(JJTSUBSTRINGAFTERFUNCTION);
     boolean jjtc017 = true;
     jjtree.openNodeScope(jjtn017);
     jjtreeOpenNodeScope(jjtn017);
      try {
        jj_consume_token(45);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte017) {
     if (jjtc017) {
       jjtree.clearNodeScope(jjtn017);
       jjtc017 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte017 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte017;}
     }
     if (jjte017 instanceof ParseException) {
       {if (true) throw (ParseException)jjte017;}
     }
     {if (true) throw (Error)jjte017;}
      } finally {
     if (jjtc017) {
       jjtree.closeNodeScope(jjtn017,  2);
       jjtreeCloseNodeScope(jjtn017);
     }
      }
      break;
    case 46:
     TranslateFunction jjtn018 = new TranslateFunction(JJTTRANSLATEFUNCTION);
     boolean jjtc018 = true;
     jjtree.openNodeScope(jjtn018);
     jjtreeOpenNodeScope(jjtn018);
      try {
        jj_consume_token(46);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte018) {
     if (jjtc018) {
       jjtree.clearNodeScope(jjtn018);
       jjtc018 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte018 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte018;}
     }
     if (jjte018 instanceof ParseException) {
       {if (true) throw (ParseException)jjte018;}
     }
     {if (true) throw (Error)jjte018;}
      } finally {
     if (jjtc018) {
       jjtree.closeNodeScope(jjtn018,  3);
       jjtreeCloseNodeScope(jjtn018);
     }
      }
      break;
    case 47:
      jj_consume_token(47);
                 PositionFunction jjtn019 = new PositionFunction(JJTPOSITIONFUNCTION);
                 boolean jjtc019 = true;
                 jjtree.openNodeScope(jjtn019);
                 jjtreeOpenNodeScope(jjtn019);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                 if (jjtc019) {
                   jjtree.closeNodeScope(jjtn019,  0);
                   jjtreeCloseNodeScope(jjtn019);
                 }
      }
      break;
    case 48:
      jj_consume_token(48);
                CurrentFunction jjtn020 = new CurrentFunction(JJTCURRENTFUNCTION);
                boolean jjtc020 = true;
                jjtree.openNodeScope(jjtn020);
                jjtreeOpenNodeScope(jjtn020);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                if (jjtc020) {
                  jjtree.closeNodeScope(jjtn020,  0);
                  jjtreeCloseNodeScope(jjtn020);
                }
      }
      break;
    case 49:
      jj_consume_token(49);
             LastFunction jjtn021 = new LastFunction(JJTLASTFUNCTION);
             boolean jjtc021 = true;
             jjtree.openNodeScope(jjtn021);
             jjtreeOpenNodeScope(jjtn021);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
             if (jjtc021) {
               jjtree.closeNodeScope(jjtn021,  0);
               jjtreeCloseNodeScope(jjtn021);
             }
      }
      break;
    case 50:
      jj_consume_token(50);
      Argument();
                         CountFunction jjtn022 = new CountFunction(JJTCOUNTFUNCTION);
                         boolean jjtc022 = true;
                         jjtree.openNodeScope(jjtn022);
                         jjtreeOpenNodeScope(jjtn022);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                         if (jjtc022) {
                           jjtree.closeNodeScope(jjtn022,  1);
                           jjtreeCloseNodeScope(jjtn022);
                         }
      }
      break;
    case 51:
      jj_consume_token(51);
      Argument();
                       SumFunction jjtn023 = new SumFunction(JJTSUMFUNCTION);
                       boolean jjtc023 = true;
                       jjtree.openNodeScope(jjtn023);
                       jjtreeOpenNodeScope(jjtn023);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
                       if (jjtc023) {
                         jjtree.closeNodeScope(jjtn023,  1);
                         jjtreeCloseNodeScope(jjtn023);
                       }
      }
      break;
    case 52:
      jj_consume_token(52);
            NowFunction jjtn024 = new NowFunction(JJTNOWFUNCTION);
            boolean jjtc024 = true;
            jjtree.openNodeScope(jjtn024);
            jjtreeOpenNodeScope(jjtn024);
      try {
        jj_consume_token(FUNCTION_END);
      } finally {
            if (jjtc024) {
              jjtree.closeNodeScope(jjtn024,  0);
              jjtreeCloseNodeScope(jjtn024);
            }
      }
      break;
    case 53:
     DateFunction jjtn025 = new DateFunction(JJTDATEFUNCTION);
     boolean jjtc025 = true;
     jjtree.openNodeScope(jjtn025);
     jjtreeOpenNodeScope(jjtn025);
      try {
        jj_consume_token(53);
        Argument();
        label_11:
        while (true) {
          jj_consume_token(SEPARATOR);
          Argument();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEPARATOR:
            ;
            break;
          default:
            jj_la1[19] = jj_gen;
            break label_11;
          }
        }
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte025) {
     if (jjtc025) {
       jjtree.clearNodeScope(jjtn025);
       jjtc025 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte025 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte025;}
     }
     if (jjte025 instanceof ParseException) {
       {if (true) throw (ParseException)jjte025;}
     }
     {if (true) throw (Error)jjte025;}
      } finally {
     if (jjtc025) {
       jjtree.closeNodeScope(jjtn025, jjtree.nodeArity() > 1);
       jjtreeCloseNodeScope(jjtn025);
     }
      }
      break;
    case 54:
     FormatDateFunction jjtn026 = new FormatDateFunction(JJTFORMATDATEFUNCTION);
     boolean jjtc026 = true;
     jjtree.openNodeScope(jjtn026);
     jjtreeOpenNodeScope(jjtn026);
      try {
        jj_consume_token(54);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEPARATOR:
          jj_consume_token(SEPARATOR);
          Argument();
          break;
        default:
          jj_la1[20] = jj_gen;
          ;
        }
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte026) {
     if (jjtc026) {
       jjtree.clearNodeScope(jjtn026);
       jjtc026 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte026 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte026;}
     }
     if (jjte026 instanceof ParseException) {
       {if (true) throw (ParseException)jjte026;}
     }
     {if (true) throw (Error)jjte026;}
      } finally {
     if (jjtc026) {
       jjtree.closeNodeScope(jjtn026, jjtree.nodeArity() > 1);
       jjtreeCloseNodeScope(jjtn026);
     }
      }
      break;
    case 55:
     RollDateFunction jjtn027 = new RollDateFunction(JJTROLLDATEFUNCTION);
     boolean jjtc027 = true;
     jjtree.openNodeScope(jjtn027);
     jjtreeOpenNodeScope(jjtn027);
      try {
        jj_consume_token(55);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte027) {
     if (jjtc027) {
       jjtree.clearNodeScope(jjtn027);
       jjtc027 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte027 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte027;}
     }
     if (jjte027 instanceof ParseException) {
       {if (true) throw (ParseException)jjte027;}
     }
     {if (true) throw (Error)jjte027;}
      } finally {
     if (jjtc027) {
       jjtree.closeNodeScope(jjtn027,  3);
       jjtreeCloseNodeScope(jjtn027);
     }
      }
      break;
    case 56:
     AddDateFunction jjtn028 = new AddDateFunction(JJTADDDATEFUNCTION);
     boolean jjtc028 = true;
     jjtree.openNodeScope(jjtn028);
     jjtreeOpenNodeScope(jjtn028);
      try {
        jj_consume_token(56);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte028) {
     if (jjtc028) {
       jjtree.clearNodeScope(jjtn028);
       jjtc028 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte028 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte028;}
     }
     if (jjte028 instanceof ParseException) {
       {if (true) throw (ParseException)jjte028;}
     }
     {if (true) throw (Error)jjte028;}
      } finally {
     if (jjtc028) {
       jjtree.closeNodeScope(jjtn028,  3);
       jjtreeCloseNodeScope(jjtn028);
     }
      }
      break;
    case 57:
     TokenizeFunction jjtn029 = new TokenizeFunction(JJTTOKENIZEFUNCTION);
     boolean jjtc029 = true;
     jjtree.openNodeScope(jjtn029);
     jjtreeOpenNodeScope(jjtn029);
      try {
        jj_consume_token(57);
        Argument();
        jj_consume_token(SEPARATOR);
        Argument();
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte029) {
     if (jjtc029) {
       jjtree.clearNodeScope(jjtn029);
       jjtc029 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte029 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte029;}
     }
     if (jjte029 instanceof ParseException) {
       {if (true) throw (ParseException)jjte029;}
     }
     {if (true) throw (Error)jjte029;}
      } finally {
     if (jjtc029) {
       jjtree.closeNodeScope(jjtn029,  2);
       jjtreeCloseNodeScope(jjtn029);
     }
      }
      break;
    case IDENTIFIER:
     UserFunction jjtn030 = new UserFunction(JJTUSERFUNCTION);
     boolean jjtc030 = true;
     jjtree.openNodeScope(jjtn030);
     jjtreeOpenNodeScope(jjtn030);
      try {
        Identifier();
        jj_consume_token(SCOPE_LIMIT);
        Identifier();
        jj_consume_token(FUNCTION_BEGIN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case LIST_BEGIN:
        case FUNCTION_BEGIN:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:
        case 36:
        case 37:
        case 38:
        case 39:
        case 40:
        case 41:
        case 42:
        case 43:
        case 44:
        case 45:
        case 46:
        case 47:
        case 48:
        case 49:
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 57:
        case SCOPE_LIMIT_NAME:
        case BOOLEAN_LITERAL:
        case STRING_LITERAL:
        case NUMBER_LITERAL:
        case IDENTIFIER:
          Argument();
          label_12:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SEPARATOR:
              ;
              break;
            default:
              jj_la1[21] = jj_gen;
              break label_12;
            }
            jj_consume_token(SEPARATOR);
            Argument();
          }
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
        jj_consume_token(FUNCTION_END);
      } catch (Throwable jjte030) {
     if (jjtc030) {
       jjtree.clearNodeScope(jjtn030);
       jjtc030 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte030 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte030;}
     }
     if (jjte030 instanceof ParseException) {
       {if (true) throw (ParseException)jjte030;}
     }
     {if (true) throw (Error)jjte030;}
      } finally {
     if (jjtc030) {
       jjtree.closeNodeScope(jjtn030, jjtree.nodeArity() > 1);
       jjtreeCloseNodeScope(jjtn030);
     }
      }
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [] Argument ::= Expr */
  final public void Argument() throws ParseException {
    Expr();
  }

/* [] ScopeLimitExpr ::= ScopeLimitName Identifier */
  final public void ScopeLimitExpr() throws ParseException {
   Token t;
    ScopeLimitName();
      ScopeLimitOperator jjtn001 = new ScopeLimitOperator(JJTSCOPELIMITOPERATOR);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
    try {
      Identifier();
    } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
    } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2);
        jjtreeCloseNodeScope(jjtn001);
      }
    }
  }

/* [] Identifier ::= Letter ( Letter | Digit )* */
  final public void Identifier() throws ParseException {
 /*@bgen(jjtree) Identifier */
   Identifier jjtn000 = new Identifier(JJTIDENTIFIER);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
        jjtn000.val = t.image;
        jjtn000.image = t.image;
        jjtn000.beginColumn = t.beginColumn;
        jjtn000.endColumn = t.endColumn;
        jjtn000.beginLine = t.beginLine;
        jjtn000.endLine = t.endLine;
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtreeCloseNodeScope(jjtn000);
     }
    }
  }

/* ScopeLimitName ::= 'page' | 'request' | 'session' | 'application' | ...  */
  final public void ScopeLimitName() throws ParseException {
 /*@bgen(jjtree) ScopeLimitName */
   ScopeLimitName jjtn000 = new ScopeLimitName(JJTSCOPELIMITNAME);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(SCOPE_LIMIT_NAME);
                                                                                   jjtree.closeNodeScope(jjtn000, true);
                                                                                   jjtc000 = false;
                                                                                   jjtreeCloseNodeScope(jjtn000);
                                                                                   jjtn000.val = t.image;
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/* Literal ::= UnaryLiteral | ListLiteral */
  final public void Literal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN_LITERAL:
    case STRING_LITERAL:
    case NUMBER_LITERAL:
      UnaryLiteral();
      break;
    case LIST_BEGIN:
      ListLiteral();
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* UnaryLiteral ::= BooleanLiteral | NumberLiteral | StringLiteral */
  final public void UnaryLiteral() throws ParseException {
   Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN_LITERAL:
   BooleanLiteral jjtn001 = new BooleanLiteral(JJTBOOLEANLITERAL);
   boolean jjtc001 = true;
   jjtree.openNodeScope(jjtn001);
   jjtreeOpenNodeScope(jjtn001);
      try {
        t = jj_consume_token(BOOLEAN_LITERAL);
      jjtree.closeNodeScope(jjtn001, true);
      jjtc001 = false;
      jjtreeCloseNodeScope(jjtn001);
       jjtn001.val = Boolean.valueOf(t.image).booleanValue();
      } finally {
   if (jjtc001) {
     jjtree.closeNodeScope(jjtn001, true);
     jjtreeCloseNodeScope(jjtn001);
   }
      }
      break;
    case NUMBER_LITERAL:
   NumberLiteral jjtn002 = new NumberLiteral(JJTNUMBERLITERAL);
   boolean jjtc002 = true;
   jjtree.openNodeScope(jjtn002);
   jjtreeOpenNodeScope(jjtn002);
      try {
        t = jj_consume_token(NUMBER_LITERAL);
      jjtree.closeNodeScope(jjtn002, true);
      jjtc002 = false;
      jjtreeCloseNodeScope(jjtn002);
       jjtn002.val = Double.parseDouble(t.image);
      } finally {
   if (jjtc002) {
     jjtree.closeNodeScope(jjtn002, true);
     jjtreeCloseNodeScope(jjtn002);
   }
      }
      break;
    case STRING_LITERAL:
   StringLiteral jjtn003 = new StringLiteral(JJTSTRINGLITERAL);
   boolean jjtc003 = true;
   jjtree.openNodeScope(jjtn003);
   jjtreeOpenNodeScope(jjtn003);
      try {
        t = jj_consume_token(STRING_LITERAL);
      jjtree.closeNodeScope(jjtn003, true);
      jjtc003 = false;
      jjtreeCloseNodeScope(jjtn003);
       jjtn003.val = t.image.substring(1, (t.image.length() - 1));
      } finally {
   if (jjtc003) {
     jjtree.closeNodeScope(jjtn003, true);
     jjtreeCloseNodeScope(jjtn003);
   }
      }
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* ListLiteral ::= '{' UnaryExpr ( ',' UnaryExpr )* '}' */
  final public void ListLiteral() throws ParseException {
 /*@bgen(jjtree) ListLiteral */
  ListLiteral jjtn000 = new ListLiteral(JJTLISTLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(LIST_BEGIN);
      Expr();
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEPARATOR:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_13;
        }
        jj_consume_token(SEPARATOR);
        Expr();
      }
                                                  ListLiteral jjtn001 = new ListLiteral(JJTLISTLITERAL);
                                                  boolean jjtc001 = true;
                                                  jjtree.openNodeScope(jjtn001);
                                                  jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(LIST_END);
      } finally {
                                                  if (jjtc001) {
                                                    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
                                                    jjtreeCloseNodeScope(jjtn001);
                                                  }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(34)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(SCOPE_LIMIT_NAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_54()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(33)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(32)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(31)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(30)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(29)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(FUNCTION_BEGIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3_2()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_69()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE_LIMIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(57)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(LIST_BEGIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(56)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(55)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(54)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(53)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(52)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FUNCTION_END)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(51)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(50)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(49)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FUNCTION_END)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(48)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FUNCTION_END)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_59()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(47)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FUNCTION_END)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(46)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(NUMBER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(45)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(44)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(43)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(BOOLEAN_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(42)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(41)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_57()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(40)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(39)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_71()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(38)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_70()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(37)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(36)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(35)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public ParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[27];
  final private int[] jj_la1_0 = {0x200000,0x100000,0x1800,0x1800,0x1e000,0x1e000,0x600,0x600,0x1c0,0x1c0,0xe2400400,0x40000,0x20000,0x8000000,0x2400000,0x0,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0xe2400400,0xe0000000,0x400000,0x0,0x1000000,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdfffffff,0x0,0x0,0x0,0x58000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0xdfffffff,0x83ffffff,0x58000000,0x58000000,0x0,};
  final private int[] jj_la1_2 = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[65];
    for (int i = 0; i < 65; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 27; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 65; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
