/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chart.ReportDonutChart;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.image.ImageCreator;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.util.DateUtil;

public class DetailedFeatureDisplay
extends Display
implements DestinationAware {
    private Feature feature;
    private float finalY;
    private int destinationY;
    private static final PDFont FEATURE_FONT = ReportFont.BOLD_FONT;
    private static final int FEATURE_FONT_SIZE = 14;
    private static final PDFont TAGS_FONT = ReportFont.REGULAR_FONT;
    private static final int TAGS_FONT_SIZE = 10;
    private static final float STATUS_COLUMN_WIDTH = 100.0f;
    private static final float DURATION_COLUMN_WIDTH = 300.0f;
    private static final float SCENARIO_COUNT_COLUMN_WIDTH = 70.0f;
    private static final float SCENARIO_CHART_COLUMN_WIDTH = 110.0f;
    private static final float STEP_COUNT_COLUMN_WIDTH = 70.0f;
    private static final float STEP_CHART_COLUMN_WIDTH = 110.0f;
    private static final float FEATURE_PADDING = 7.0f;
    private static final TextLengthOptimizer tagsTextOptimizer = TextLengthOptimizer.builder().font(TAGS_FONT).fontsize(10).availableSpace(392.0f).maxLines(3).build();

    @Override
    public void display() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        String tags = this.feature.getTags().stream().collect(Collectors.joining(" "));
        Table.TableBuilder nameTableBuilder = Table.builder().addColumnOfWidth(760.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).addRow(Row.builder().font(FEATURE_FONT).fontSize(Integer.valueOf(14)).borderWidth(0.0f).padding(7.0f).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().wordBreak(Boolean.valueOf(true))).text(sanitizer.sanitizeText(this.feature.getName())).textColor(this.reportConfig.getDetailedFeatureConfig().featureNameColor())).build()).build());
        Object nameTableCreator = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(nameTableBuilder)).document(this.document)).startX(40.0f)).startY(this.ylocation)).endY(40.0f)).splitRow(true)).repeatRows(0)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageWithHeaderAndNumberSupplier("DETAILED SECTION"))).build();
        ((TableCreator)nameTableCreator).displayTable();
        this.ylocation = ((TableCreator)nameTableCreator).getFinalY();
        this.page = ((TableCreator)nameTableCreator).getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 550;
        }
        this.createDestination();
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{100.0f, 300.0f, 70.0f, 110.0f, 70.0f, 110.0f}).borderWidth(1.0f).borderColor(Color.GRAY).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).font(ReportFont.REGULAR_FONT).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(ReportFont.ITALIC_FONT).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(this.feature.getStatus().toString()).backgroundColor(this.statusColor(this.feature.getStatus()))).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("DURATION - " + DateUtil.durationValue(this.feature.calculatedDuration())).textColor(this.reportConfig.getDetailedFeatureConfig().durationColor())).backgroundColor(this.reportConfig.getDetailedScenarioConfig().durationBackgroundColor())).build()).add((AbstractCell)((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().lineSpacing(1.4f).rowSpan(3)).paragraph(this.scenariosData()).font(ReportFont.REGULAR_FONT).backgroundColor(this.reportConfig.getDetailedFeatureConfig().dataBackgroundColor())).build()).add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().rowSpan(3)).image(this.scenariosDonut()).horizontalAlignment(HorizontalAlignment.CENTER)).verticalAlignment(VerticalAlignment.MIDDLE)).build()).add((AbstractCell)((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().lineSpacing(1.4f).rowSpan(3)).paragraph(this.stepsData()).font(ReportFont.REGULAR_FONT).backgroundColor(this.reportConfig.getDetailedFeatureConfig().dataBackgroundColor())).build()).add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().rowSpan(3)).image(this.stepsDonut()).horizontalAlignment(HorizontalAlignment.CENTER)).verticalAlignment(VerticalAlignment.MIDDLE)).build()).build()).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(ReportFont.ITALIC_FONT).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(2)).text("/ " + DateUtil.formatTimeWithMillis(this.feature.getStartTime()) + " // " + DateUtil.formatTimeWithMillis(this.feature.getEndTime()) + " /").textColor(this.reportConfig.getDetailedFeatureConfig().startEndTimeColor())).build()).build()).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(TAGS_FONT).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(2)).wordBreak(Boolean.valueOf(true))).text(sanitizer.sanitizeText(tagsTextOptimizer.optimizeTextLines(tags))).textColor(this.reportConfig.getDetailedFeatureConfig().tagColor())).build()).build());
        Object tableCreator = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(tableBuilder)).document(this.document)).startX(40.0f)).startY(this.ylocation)).endY(40.0f)).repeatRows(3)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageWithHeaderAndNumberSupplier("DETAILED SECTION"))).build();
        ((TableCreator)tableCreator).displayTable();
        this.finalY = ((TableCreator)tableCreator).getFinalY();
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().yCoord(this.destinationY).page(this.page).build();
        this.feature.setDestination(destination);
    }

    private ParagraphCell.Paragraph scenariosData() {
        return this.createData("Scenarios", this.feature.getTotalScenarios(), this.feature.getPassedScenarios(), this.feature.getFailedScenarios(), this.feature.getSkippedScenarios());
    }

    private PDImageXObject scenariosDonut() {
        ReportDonutChart chart = new ReportDonutChart(80, 80);
        this.updateChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", this.feature.getPassedScenarios());
        data.put("Failed", this.feature.getFailedScenarios());
        data.put("Skipped", this.feature.getSkippedScenarios());
        chart.updateData(data);
        return ImageCreator.builder().chart((Chart<?, ?>)chart).document(this.document).build().generateChartImageXObject();
    }

    private ParagraphCell.Paragraph stepsData() {
        return this.createData("Steps", this.feature.getTotalSteps(), this.feature.getPassedSteps(), this.feature.getFailedSteps(), this.feature.getSkippedSteps());
    }

    private PDImageXObject stepsDonut() {
        ReportDonutChart chart = new ReportDonutChart(80, 80);
        this.updateChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", this.feature.getPassedSteps());
        data.put("Failed", this.feature.getFailedSteps());
        data.put("Skipped", this.feature.getSkippedSteps());
        chart.updateData(data);
        return ImageCreator.builder().chart((Chart<?, ?>)chart).document(this.document).build().generateChartImageXObject();
    }

    private void updateChartStyler(PieStyler styler) {
        styler.setSumFontSize(16.0f);
        styler.setDonutThickness(0.4);
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    private ParagraphCell.Paragraph createData(String header, int total, int pass, int fail, int skip) {
        return ParagraphCell.Paragraph.builder().append(StyledText.builder().fontSize(Float.valueOf(11.0f)).text(header).color(this.reportConfig.getDetailedFeatureConfig().dataHeaderColor()).build()).appendNewLine().append(this.createDataTitle("Total", this.reportConfig.getDetailedFeatureConfig().totalColor())).append(this.createDataValue(total, this.reportConfig.getDetailedFeatureConfig().totalColor())).appendNewLine().append(this.createDataTitle("Pass", this.reportConfig.passedColor())).append(this.createDataValue(pass, this.reportConfig.passedColor())).appendNewLine().append(this.createDataTitle("Fail", this.reportConfig.failedColor())).append(this.createDataValue(fail, this.reportConfig.failedColor())).appendNewLine().append(this.createDataTitle("Skip", this.reportConfig.skippedColor())).append(this.createDataValue(skip, this.reportConfig.skippedColor())).appendNewLine().build();
    }

    private StyledText createDataTitle(String text, Color color) {
        return StyledText.builder().fontSize(Float.valueOf(10.0f)).text(text + " - ").color(color).build();
    }

    private StyledText createDataValue(int value, Color color) {
        return StyledText.builder().fontSize(Float.valueOf(11.0f)).text(String.valueOf(value)).color(color).build();
    }

    protected DetailedFeatureDisplay(DetailedFeatureDisplayBuilder<?, ?> b) {
        super(b);
        this.feature = ((DetailedFeatureDisplayBuilder)b).feature;
        this.finalY = ((DetailedFeatureDisplayBuilder)b).finalY;
        this.destinationY = ((DetailedFeatureDisplayBuilder)b).destinationY;
    }

    public static DetailedFeatureDisplayBuilder<?, ?> builder() {
        return new DetailedFeatureDisplayBuilderImpl();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setFinalY(float finalY) {
        this.finalY = finalY;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    @Override
    public String toString() {
        return "DetailedFeatureDisplay(feature=" + this.getFeature() + ", finalY=" + this.getFinalY() + ", destinationY=" + this.getDestinationY() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedFeatureDisplay)) {
            return false;
        }
        DetailedFeatureDisplay other = (DetailedFeatureDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getFinalY(), other.getFinalY()) != 0) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        return !(this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedFeatureDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFinalY());
        result = result * 59 + this.getDestinationY();
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        return result;
    }

    public float getFinalY() {
        return this.finalY;
    }

    private static final class DetailedFeatureDisplayBuilderImpl
    extends DetailedFeatureDisplayBuilder<DetailedFeatureDisplay, DetailedFeatureDisplayBuilderImpl> {
        private DetailedFeatureDisplayBuilderImpl() {
        }

        @Override
        protected DetailedFeatureDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedFeatureDisplay build() {
            return new DetailedFeatureDisplay(this);
        }
    }

    public static abstract class DetailedFeatureDisplayBuilder<C extends DetailedFeatureDisplay, B extends DetailedFeatureDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Feature feature;
        private float finalY;
        private int destinationY;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B finalY(float finalY) {
            this.finalY = finalY;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedFeatureDisplay.DetailedFeatureDisplayBuilder(super=" + super.toString() + ", feature=" + this.feature + ", finalY=" + this.finalY + ", destinationY=" + this.destinationY + ")";
        }
    }
}

