/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable.logs;

import java.awt.Color;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.section.details.executable.logs.TableLog;
import tech.grasshopper.pdf.section.details.executable.logs.TextLog;

public class Log {
    protected String content;
    protected Color color;
    protected final int fontsize = 8;
    protected final TextSanitizer sanitizer = TextSanitizer.builder().build();

    public AbstractCell display() {
        return Log.logType(this.content, this.color).display();
    }

    private static Log logType(String content, Color color) {
        if (content.contains("<table")) {
            return ((TableLog.TableLogBuilder)((TableLog.TableLogBuilder)TableLog.builder().content(content)).color(color)).build();
        }
        return ((TextLog.TextLogBuilder)((TextLog.TextLogBuilder)TextLog.builder().content(content)).color(color)).build();
    }

    protected Log(LogBuilder<?, ?> b) {
        this.content = b.content;
        this.color = b.color;
    }

    public static LogBuilder<?, ?> builder() {
        return new LogBuilderImpl();
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private static final class LogBuilderImpl
    extends LogBuilder<Log, LogBuilderImpl> {
        private LogBuilderImpl() {
        }

        @Override
        protected LogBuilderImpl self() {
            return this;
        }

        @Override
        public Log build() {
            return new Log(this);
        }
    }

    public static abstract class LogBuilder<C extends Log, B extends LogBuilder<C, B>> {
        private String content;
        private Color color;

        protected abstract B self();

        public abstract C build();

        public B content(String content) {
            this.content = content;
            return this.self();
        }

        public B color(Color color) {
            this.color = color;
            return this.self();
        }

        public String toString() {
            return "Log.LogBuilder(content=" + this.content + ", color=" + this.color + ")";
        }
    }
}

