/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.scenario;

import java.awt.Color;
import java.util.stream.IntStream;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import tech.grasshopper.pdf.chart.ReportStackedBarChart;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.image.ImageCreator;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.structure.Display;

public class ScenarioStackedBarChart
extends Display {
    private int fromXData;
    private int toXData;

    @Override
    public void display() {
        this.createBarChart();
    }

    private void createBarChart() {
        int[] passed = new int[this.toXData - this.fromXData];
        int[] failed = new int[this.toXData - this.fromXData];
        int[] skipped = new int[this.toXData - this.fromXData];
        int[] xData = new int[this.toXData - this.fromXData];
        xData = IntStream.rangeClosed(this.fromXData + 1, this.toXData).toArray();
        ReportStackedBarChart chart = new ReportStackedBarChart(600, 200);
        chart.setYAxisTitle("# of Steps");
        this.updateBarChartStyler((CategoryStyler)chart.getStyler());
        this.createStackedBarChartData(passed, failed, skipped);
        chart.updateData(xData, passed, failed, skipped);
        ImageCreator.builder().document(this.document).chart((Chart<?, ?>)chart).content(this.content).build().generateAndDisplayChartImage(120.0f, 350.0f);
    }

    private void updateBarChartStyler(CategoryStyler styler) {
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
        styler.setAvailableSpaceFill(0.4 * (double)(this.toXData - this.fromXData) / 10.0);
    }

    private void createStackedBarChartData(int[] passed, int[] failed, int[] skipped) {
        ScenarioData scenarioData = (ScenarioData)this.displayData;
        for (int i = 0; i < scenarioData.getScenarios().size(); ++i) {
            Scenario scenario = scenarioData.getScenarios().get(i);
            passed[i] = scenario.getPassedSteps();
            failed[i] = scenario.getFailedSteps();
            skipped[i] = scenario.getSkippedSteps();
        }
    }

    protected ScenarioStackedBarChart(ScenarioStackedBarChartBuilder<?, ?> b) {
        super(b);
        this.fromXData = b.fromXData;
        this.toXData = b.toXData;
    }

    public static ScenarioStackedBarChartBuilder<?, ?> builder() {
        return new ScenarioStackedBarChartBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioStackedBarChart)) {
            return false;
        }
        ScenarioStackedBarChart other = (ScenarioStackedBarChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.fromXData != other.fromXData) {
            return false;
        }
        return this.toXData == other.toXData;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioStackedBarChart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.fromXData;
        result = result * 59 + this.toXData;
        return result;
    }

    private static final class ScenarioStackedBarChartBuilderImpl
    extends ScenarioStackedBarChartBuilder<ScenarioStackedBarChart, ScenarioStackedBarChartBuilderImpl> {
        private ScenarioStackedBarChartBuilderImpl() {
        }

        @Override
        protected ScenarioStackedBarChartBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioStackedBarChart build() {
            return new ScenarioStackedBarChart(this);
        }
    }

    public static abstract class ScenarioStackedBarChartBuilder<C extends ScenarioStackedBarChart, B extends ScenarioStackedBarChartBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private int fromXData;
        private int toXData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B fromXData(int fromXData) {
            this.fromXData = fromXData;
            return (B)this.self();
        }

        public B toXData(int toXData) {
            this.toXData = toXData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioStackedBarChart.ScenarioStackedBarChartBuilder(super=" + super.toString() + ", fromXData=" + this.fromXData + ", toXData=" + this.toXData + ")";
        }
    }
}

