/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure;

import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.structure.PageCreator;

public abstract class Section {
    @NonNull
    protected PDDocument document;
    @NonNull
    protected DisplayData displayData;
    protected ReportConfig reportConfig;
    protected Destination.DestinationStore destinations;

    public abstract void createSection();

    protected PDPage createPage() {
        return PageCreator.builder().document(this.document).build().createLandscapePageAndAddToDocument();
    }

    protected Section(SectionBuilder<?, ?> b) {
        this.document = b.document;
        if (this.document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.displayData = b.displayData;
        if (this.displayData == null) {
            throw new NullPointerException("displayData is marked non-null but is null");
        }
        this.reportConfig = b.reportConfig;
        this.destinations = b.destinations;
    }

    @NonNull
    public PDDocument getDocument() {
        return this.document;
    }

    @NonNull
    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public Destination.DestinationStore getDestinations() {
        return this.destinations;
    }

    public void setDocument(@NonNull PDDocument document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.document = document;
    }

    public void setDisplayData(@NonNull DisplayData displayData) {
        if (displayData == null) {
            throw new NullPointerException("displayData is marked non-null but is null");
        }
        this.displayData = displayData;
    }

    public void setReportConfig(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public void setDestinations(Destination.DestinationStore destinations) {
        this.destinations = destinations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Section)) {
            return false;
        }
        Section other = (Section)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        DisplayData this$displayData = this.getDisplayData();
        DisplayData other$displayData = other.getDisplayData();
        if (this$displayData == null ? other$displayData != null : !this$displayData.equals(other$displayData)) {
            return false;
        }
        ReportConfig this$reportConfig = this.getReportConfig();
        ReportConfig other$reportConfig = other.getReportConfig();
        if (this$reportConfig == null ? other$reportConfig != null : !((Object)this$reportConfig).equals(other$reportConfig)) {
            return false;
        }
        Destination.DestinationStore this$destinations = this.getDestinations();
        Destination.DestinationStore other$destinations = other.getDestinations();
        return !(this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Section;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        DisplayData $displayData = this.getDisplayData();
        result = result * 59 + ($displayData == null ? 43 : $displayData.hashCode());
        ReportConfig $reportConfig = this.getReportConfig();
        result = result * 59 + ($reportConfig == null ? 43 : ((Object)$reportConfig).hashCode());
        Destination.DestinationStore $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        return result;
    }

    public String toString() {
        return "Section(document=" + this.getDocument() + ", displayData=" + this.getDisplayData() + ", reportConfig=" + this.getReportConfig() + ", destinations=" + this.getDestinations() + ")";
    }

    public static abstract class SectionBuilder<C extends Section, B extends SectionBuilder<C, B>> {
        private PDDocument document;
        private DisplayData displayData;
        private ReportConfig reportConfig;
        private Destination.DestinationStore destinations;

        protected abstract B self();

        public abstract C build();

        public B document(@NonNull PDDocument document) {
            if (document == null) {
                throw new NullPointerException("document is marked non-null but is null");
            }
            this.document = document;
            return this.self();
        }

        public B displayData(@NonNull DisplayData displayData) {
            if (displayData == null) {
                throw new NullPointerException("displayData is marked non-null but is null");
            }
            this.displayData = displayData;
            return this.self();
        }

        public B reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this.self();
        }

        public B destinations(Destination.DestinationStore destinations) {
            this.destinations = destinations;
            return this.self();
        }

        public String toString() {
            return "Section.SectionBuilder(document=" + this.document + ", displayData=" + this.displayData + ", reportConfig=" + this.reportConfig + ", destinations=" + this.destinations + ")";
        }
    }
}

