/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.header;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import tech.grasshopper.pdf.font.ReportFont;

public class PageNumber {
    private PDPageContentStream content;
    private int number;

    public void displayNumber() {
        PositionedStyledText textDetails = PositionedStyledText.builder().x(750.0f).y(570.0f).text("-- " + this.number + " --").font(ReportFont.ITALIC_FONT).fontSize(11).color(Color.LIGHT_GRAY).build();
        DrawingUtil.drawText((PDPageContentStream)this.content, (PositionedStyledText)textDetails);
    }

    PageNumber(PDPageContentStream content, int number) {
        this.content = content;
        this.number = number;
    }

    public static PageNumberBuilder builder() {
        return new PageNumberBuilder();
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public static class PageNumberBuilder {
        private PDPageContentStream content;
        private int number;

        PageNumberBuilder() {
        }

        public PageNumberBuilder content(PDPageContentStream content) {
            this.content = content;
            return this;
        }

        public PageNumberBuilder number(int number) {
            this.number = number;
            return this;
        }

        public PageNumber build() {
            return new PageNumber(this.content, this.number);
        }

        public String toString() {
            return "PageNumber.PageNumberBuilder(content=" + this.content + ", number=" + this.number + ")";
        }
    }
}

