/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.drawing.cell;

import java.awt.Color;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedLine;
import org.vandeseer.easytable.drawing.PositionedRectangle;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import org.vandeseer.easytable.drawing.cell.TextCellDrawer;
import org.vandeseer.easytable.structure.cell.AbstractTextCell;
import org.vandeseer.easytable.util.PdfUtil;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;

public class TextLabelCellDrawer<T extends TextLabelCell>
extends TextCellDrawer<TextLabelCell> {
    private Color labelColor;

    public TextLabelCellDrawer(T cell) {
        this.cell = cell;
        this.labelColor = ((TextLabelCell)cell).getLabelColor();
    }

    @Override
    public void drawContent(DrawingContext drawingContext) {
        float startX = drawingContext.getStartingPoint().x;
        PDFont currentFont = ((AbstractTextCell)this.cell).getFont();
        int currentFontSize = ((AbstractTextCell)this.cell).getFontSize();
        float yOffset = drawingContext.getStartingPoint().y + this.getAdaptionForVerticalAlignment();
        float xOffset = startX + ((AbstractTextCell)this.cell).getPaddingLeft();
        List<String> lines = this.calculateAndGetLines(currentFont, currentFontSize, ((AbstractTextCell)this.cell).getMaxWidth());
        this.drawColorLabel(drawingContext, lines, xOffset, yOffset);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.drawText(drawingContext, PositionedStyledText.builder().x(xOffset).y(yOffset -= this.calculateYOffset(currentFont, currentFontSize, i)).text(line).font(currentFont).fontSize(currentFontSize).color(Color.WHITE).build());
        }
    }

    protected float calculateHeight(int lineCnt) {
        return PdfUtil.getFontHeight(((AbstractTextCell)this.cell).getFont(), ((AbstractTextCell)this.cell).getFontSize()) * (float)lineCnt + PdfUtil.getFontHeight(((AbstractTextCell)this.cell).getFont(), ((AbstractTextCell)this.cell).getFontSize()) * ((AbstractTextCell)this.cell).getLineSpacing() * (float)(lineCnt - 1);
    }

    @Override
    protected float calculateYOffset(PDFont currentFont, int currentFontSize, int lineIndex) {
        return PdfUtil.getFontHeight(currentFont, currentFontSize) + (lineIndex > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * ((AbstractTextCell)this.cell).getLineSpacing() : 0.0f);
    }

    protected void drawLine(DrawingContext drawingContext, PositionedLine positionedLine) throws IOException {
        DrawingUtil.drawLine(drawingContext.getContentStream(), positionedLine);
    }

    protected void drawColorLabel(DrawingContext drawingContext, List<String> lines, float xOffset, float yOffset) throws IOException {
        float marginOffset = (float)((AbstractTextCell)this.cell).getFontSize().intValue() * ((AbstractTextCell)this.cell).getFont().getFontDescriptor().getAscent() / 4000.0f;
        float labelHeight = this.calculateHeight(lines.size()) + 2.0f * marginOffset;
        float labelWidth = lines.stream().map(l -> Float.valueOf(PdfUtil.getStringWidth(l, ((AbstractTextCell)this.cell).getFont(), ((AbstractTextCell)this.cell).getFontSize()))).max(Comparator.naturalOrder()).orElse(Float.valueOf(((AbstractTextCell)this.cell).getMaxWidth())).floatValue() + 2.0f * marginOffset;
        DrawingUtil.drawRectangle(drawingContext.getContentStream(), PositionedRectangle.builder().color(this.labelColor).x(xOffset - marginOffset).y(yOffset - this.calculateHeight(lines.size()) - marginOffset).height(labelHeight).width(labelWidth).build());
    }

    public TextLabelCellDrawer() {
    }
}

