package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJBigIntegerRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJBigIntegerRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJBigIntegerRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJBigIntegerRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJBigIntegerRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJBigIntegerRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AbstractBigIntegerAssertIsEqualToRecipe(),
                new AbstractBigIntegerAssertIsNotEqualToRecipe(),
                new AbstractBigIntegerAssertIsZeroRecipe(),
                new AbstractBigIntegerAssertIsNotZeroRecipe(),
                new AbstractBigIntegerAssertIsOneRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJBigIntegerRules.AbstractBigIntegerAssertIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractBigIntegerAssertIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractBigIntegerAssertIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJBigIntegerRules.AbstractBigIntegerAssertIsEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBigIntegerAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {\n        return Refaster.anyOf(bigIntegerAssert.isCloseTo(n, offset(BigInteger.ZERO)), bigIntegerAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {\n        return bigIntegerAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isCloseTo(#{n:any(java.math.BigInteger)}, org.assertj.core.data.Offset.offset(java.math.BigInteger.ZERO))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isCloseTo(#{n:any(java.math.BigInteger)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(#{n:any(java.math.BigInteger)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isCloseTo(..)", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)", true),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJBigIntegerRules.AbstractBigIntegerAssertIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractBigIntegerAssertIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractBigIntegerAssertIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJBigIntegerRules.AbstractBigIntegerAssertIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBigIntegerAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {\n        return Refaster.anyOf(bigIntegerAssert.isNotCloseTo(n, offset(BigInteger.ZERO)), bigIntegerAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {\n        return bigIntegerAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotCloseTo(#{n:any(java.math.BigInteger)}, org.assertj.core.data.Offset.offset(java.math.BigInteger.ZERO))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotCloseTo(#{n:any(java.math.BigInteger)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotEqualTo(#{n:any(java.math.BigInteger)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isNotCloseTo(..)", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)", true),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJBigIntegerRules.AbstractBigIntegerAssertIsZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractBigIntegerAssertIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractBigIntegerAssertIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJBigIntegerRules.AbstractBigIntegerAssertIsZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBigIntegerAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {\n        return Refaster.anyOf(bigIntegerAssert.isZero(), bigIntegerAssert.isEqualTo(0L), bigIntegerAssert.isEqualTo(BigInteger.ZERO));\n    }\n    \n    @AfterTemplate\n    AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {\n        return bigIntegerAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(0L)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$2 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(java.math.BigInteger.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isZero(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isEqualTo(..)", true),
                            Preconditions.and(
                                new UsesType<>("java.math.BigInteger", true),
                                new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJBigIntegerRules.AbstractBigIntegerAssertIsNotZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractBigIntegerAssertIsNotZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractBigIntegerAssertIsNotZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJBigIntegerRules.AbstractBigIntegerAssertIsNotZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBigIntegerAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {\n        return Refaster.anyOf(bigIntegerAssert.isNotZero(), bigIntegerAssert.isNotEqualTo(0L), bigIntegerAssert.isNotEqualTo(BigInteger.ZERO));\n    }\n    \n    @AfterTemplate\n    AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {\n        return bigIntegerAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotEqualTo(0L)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$2 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotEqualTo(java.math.BigInteger.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isNotEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isNotZero(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isNotEqualTo(..)", true),
                            Preconditions.and(
                                new UsesType<>("java.math.BigInteger", true),
                                new UsesMethod<>("org.assertj.core.api.AbstractAssert isNotEqualTo(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJBigIntegerRules.AbstractBigIntegerAssertIsOne}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractBigIntegerAssertIsOneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractBigIntegerAssertIsOneRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJBigIntegerRules.AbstractBigIntegerAssertIsOne`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBigIntegerAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {\n        return Refaster.anyOf(bigIntegerAssert.isOne(), bigIntegerAssert.isEqualTo(1L), bigIntegerAssert.isEqualTo(BigInteger.ONE));\n    }\n    \n    @AfterTemplate\n    AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {\n        return bigIntegerAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isOne()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(1L)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$2 = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(java.math.BigInteger.ONE)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{bigIntegerAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isEqualTo(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isOne(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBigIntegerAssert isEqualTo(..)", true),
                            Preconditions.and(
                                new UsesType<>("java.math.BigInteger", true),
                                new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

}
