package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJLongRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJLongRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJLongRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJLongRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJLongRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJLongRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AbstractLongAssertIsEqualToRecipe(),
                new AbstractLongAssertIsNotEqualToRecipe(),
                new AbstractLongAssertIsZeroRecipe(),
                new AbstractLongAssertIsNotZeroRecipe(),
                new AbstractLongAssertIsOneRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJLongRules.AbstractLongAssertIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractLongAssertIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractLongAssertIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert, long n) {\n        return Refaster.anyOf(longAssert.isCloseTo(n, offset(0L)), longAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert, long n) {\n        return longAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isCloseTo(#{n:any(long)}, org.assertj.core.data.Offset.offset(0L))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isCloseTo(#{n:any(long)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(#{n:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isCloseTo(..)", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)", true),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJLongRules.AbstractLongAssertIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractLongAssertIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractLongAssertIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert, long n) {\n        return Refaster.anyOf(longAssert.isNotCloseTo(n, offset(0L)), longAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert, long n) {\n        return longAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotCloseTo(#{n:any(long)}, org.assertj.core.data.Offset.offset(0L))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotCloseTo(#{n:any(long)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotEqualTo(#{n:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isNotCloseTo(..)", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)", true),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJLongRules.AbstractLongAssertIsZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractLongAssertIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractLongAssertIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {\n        return longAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {\n        return longAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isZero(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJLongRules.AbstractLongAssertIsNotZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractLongAssertIsNotZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractLongAssertIsNotZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsNotZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {\n        return longAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {\n        return longAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isNotZero(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJLongRules.AbstractLongAssertIsOne}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractLongAssertIsOneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractLongAssertIsOneRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsOne`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {\n        return longAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {\n        return longAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isOne()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isOne(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
