package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJNumberRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJNumberRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJNumberRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJNumberRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJNumberRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJNumberRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new NumberAssertIsPositiveRecipe(),
                new NumberAssertIsNotPositiveRecipe(),
                new NumberAssertIsNegativeRecipe(),
                new NumberAssertIsNotNegativeRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJNumberRules.NumberAssertIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NumberAssertIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NumberAssertIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsPositive`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsPositive {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan((byte)0), numberAssert.isGreaterThanOrEqualTo((byte)1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan((short)0), numberAssert.isGreaterThanOrEqualTo((short)1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan(0), numberAssert.isGreaterThanOrEqualTo(1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan(0), numberAssert.isGreaterThanOrEqualTo(1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isGreaterThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isGreaterThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan(BigInteger.ZERO), numberAssert.isGreaterThanOrEqualTo(BigInteger.valueOf(1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isGreaterThan(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isPositive();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThan((byte)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThanOrEqualTo((byte)1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThan((short)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThanOrEqualTo((short)1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThanOrEqualTo(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThanOrEqualTo(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before3 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isGreaterThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before4 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isGreaterThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThan(java.math.BigInteger.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThanOrEqualTo(java.math.BigInteger.valueOf(1))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before6 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isGreaterThan(java.math.BigDecimal.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isPositive()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigDecimal");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isGreaterThanOrEqualTo(..)", true),
                        new UsesMethod<>("java.math.BigInteger valueOf(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigDecimal", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigDecimalAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true)
                    )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJNumberRules.NumberAssertIsNotPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NumberAssertIsNotPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NumberAssertIsNotPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsNotPositive`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsNotPositive {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo((byte)0), numberAssert.isLessThan((byte)1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo((short)0), numberAssert.isLessThan((short)1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo(0), numberAssert.isLessThan(1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo(0), numberAssert.isLessThan(1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isLessThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isLessThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo(BigInteger.ZERO), numberAssert.isLessThan(BigInteger.valueOf(1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isLessThanOrEqualTo(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isNotPositive();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThanOrEqualTo((byte)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThan((byte)1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThanOrEqualTo((short)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThan((short)1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThan(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThan(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before3 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isLessThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before4 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isLessThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThanOrEqualTo(java.math.BigInteger.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThan(java.math.BigInteger.valueOf(1))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before6 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isLessThanOrEqualTo(java.math.BigDecimal.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isNotPositive()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigDecimal");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isLessThanOrEqualTo(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true),
                        new UsesMethod<>("java.math.BigInteger valueOf(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigDecimal", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigDecimalAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractBigDecimalAssert isLessThanOrEqualTo(..)", true)
                    )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJNumberRules.NumberAssertIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NumberAssertIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NumberAssertIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsNegative`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsNegative {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan((byte)0), numberAssert.isLessThanOrEqualTo((byte)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan((short)0), numberAssert.isLessThanOrEqualTo((short)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan(0), numberAssert.isLessThanOrEqualTo(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan(0), numberAssert.isLessThanOrEqualTo(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isLessThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isLessThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan(BigInteger.ZERO), numberAssert.isLessThanOrEqualTo(BigInteger.valueOf(-1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isLessThan(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isNegative();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThan((byte)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThanOrEqualTo((byte)-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThan((short)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThanOrEqualTo((short)-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThanOrEqualTo(-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThanOrEqualTo(-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before3 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isLessThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before4 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isLessThan(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThan(java.math.BigInteger.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThanOrEqualTo(java.math.BigInteger.valueOf(-1))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before6 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isLessThan(java.math.BigDecimal.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isNegative()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigDecimal");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isLessThanOrEqualTo(..)", true),
                        new UsesMethod<>("java.math.BigInteger valueOf(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigDecimal", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigDecimalAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true)
                    )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJNumberRules.NumberAssertIsNotNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NumberAssertIsNotNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NumberAssertIsNotNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsNotNegative`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsNotNegative {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo((byte)0), numberAssert.isGreaterThan((byte)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo((short)0), numberAssert.isGreaterThan((short)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo(0), numberAssert.isGreaterThan(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo(0), numberAssert.isGreaterThan(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isGreaterThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isGreaterThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo(BigInteger.ZERO), numberAssert.isGreaterThan(BigInteger.valueOf(-1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isGreaterThanOrEqualTo(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isNotNegative();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThanOrEqualTo((byte)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThan((byte)-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThanOrEqualTo((short)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThan((short)-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before1$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThan(-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before2$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThan(-1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before3 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isGreaterThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before4 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isGreaterThanOrEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$0 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThanOrEqualTo(java.math.BigInteger.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before5$1 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThan(java.math.BigInteger.valueOf(-1))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before6 = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isGreaterThanOrEqualTo(java.math.BigDecimal.ZERO)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isNotNegative()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before5$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigInteger");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.math.BigDecimal");
                        maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isGreaterThanOrEqualTo(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigInteger", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true),
                        new UsesMethod<>("java.math.BigInteger valueOf(..)", true)
                    ),
                        Preconditions.and(
                        new UsesType<>("java.math.BigDecimal", true),
                        new UsesType<>("org.assertj.core.api.AbstractBigDecimalAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractBigDecimalAssert isGreaterThanOrEqualTo(..)", true)
                    )
                    ),
                    javaVisitor
            );
        }
    }

}
