package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to AssertJ expressions and statements";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatOptionalDoubleRecipe(),
                new AssertThatOptionalIntRecipe(),
                new AssertThatOptionalLongRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatOptionalDouble}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalDoubleRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalDoubleRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalDouble`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalDouble {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(OptionalDouble optional, double expected) {\n        return assertThat(optional.getAsDouble()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalDoubleAssert after(OptionalDouble optional, double expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}.getAsDouble()).isEqualTo(#{expected:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}).hasValue(#{expected:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractDoubleAssert", true),
                        new UsesType<>("java.util.OptionalDouble", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                        new UsesMethod<>("java.util.OptionalDouble getAsDouble(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatOptionalInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalIntRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalInt`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalInt {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(OptionalInt optional, int expected) {\n        return assertThat(optional.getAsInt()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalIntAssert after(OptionalInt optional, int expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}.getAsInt()).isEqualTo(#{expected:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}).hasValue(#{expected:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                        new UsesType<>("java.util.OptionalInt", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                        new UsesMethod<>("java.util.OptionalInt getAsInt(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatOptionalLong}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalLongRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalLongRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalLong`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalLong {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(OptionalLong optional, long expected) {\n        return assertThat(optional.getAsLong()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalLongAssert after(OptionalLong optional, long expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}.getAsLong()).isEqualTo(#{expected:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}).hasValue(#{expected:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                        new UsesType<>("java.util.OptionalLong", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                        new UsesMethod<>("java.util.OptionalLong getAsLong(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
