package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJShortRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJShortRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJShortRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJShortRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJShortRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJShortRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AbstractShortAssertIsEqualToRecipe(),
                new AbstractShortAssertIsNotEqualToRecipe(),
                new AbstractShortAssertIsZeroRecipe(),
                new AbstractShortAssertIsNotZeroRecipe(),
                new AbstractShortAssertIsOneRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJShortRules.AbstractShortAssertIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractShortAssertIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractShortAssertIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {\n        return Refaster.anyOf(shortAssert.isCloseTo(n, offset((short)0)), shortAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {\n        return shortAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isCloseTo(#{n:any(short)}, org.assertj.core.data.Offset.offset((short)0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isCloseTo(#{n:any(short)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo(#{n:any(short)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractShortAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractShortAssert isCloseTo(..)", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)", true),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJShortRules.AbstractShortAssertIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractShortAssertIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractShortAssertIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {\n        return Refaster.anyOf(shortAssert.isNotCloseTo(n, offset((short)0)), shortAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {\n        return shortAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotCloseTo(#{n:any(short)}, org.assertj.core.data.Offset.offset((short)0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotCloseTo(#{n:any(short)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo(#{n:any(short)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractShortAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractShortAssert isNotCloseTo(..)", true),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)", true),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJShortRules.AbstractShortAssertIsZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractShortAssertIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractShortAssertIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isEqualTo((short)0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo((short)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractShortAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractShortAssert isZero(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJShortRules.AbstractShortAssertIsNotZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractShortAssertIsNotZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractShortAssertIsNotZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsNotZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isNotEqualTo((short)0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo((short)0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractShortAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractShortAssert isNotZero(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJShortRules.AbstractShortAssertIsOne}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractShortAssertIsOneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractShortAssertIsOneRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsOne`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isEqualTo((short)1);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isOne()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo((short)1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractShortAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractShortAssert isOne(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
