package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssortedRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssortedRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssortedRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Assorted Refaster rules that do not (yet) belong in one of the other classes with more topical Refaster rules";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssortedRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssortedRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new CheckIndexRecipe(),
                new LogicalImplicationRecipe(),
                new SplitToStreamRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.CheckIndex}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CheckIndexRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CheckIndexRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Objects#checkIndex(int, int)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CheckIndex {\n    \n    @BeforeTemplate\n    int before(int index, int size) {\n        return checkElementIndex(index, size);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    int after(int index, int size) {\n        return checkIndex(index, size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.base.Preconditions.checkElementIndex(#{index:any(int)}, #{size:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.util.Objects.checkIndex(#{index:any(int)}, #{size:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.Preconditions.checkElementIndex");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.base.Preconditions checkElementIndex(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.LogicalImplication}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LogicalImplicationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LogicalImplicationRecipe() {}

        @Override
        public String getDisplayName() {
            return "Don't unnecessarily repeat boolean expressions";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LogicalImplication {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S2589\")\n    boolean before(boolean firstTest, boolean secondTest) {\n        return firstTest || (!firstTest && secondTest);\n    }\n    \n    @AfterTemplate\n    boolean after(boolean firstTest, boolean secondTest) {\n        return firstTest || secondTest;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{firstTest:any(boolean)} || (!#{firstTest} && #{secondTest:any(boolean)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{firstTest:any(boolean)} || #{secondTest:any(boolean)}")
                        .build();

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.SplitToStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SplitToStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SplitToStreamRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Splitter#splitToStream(CharSequence)` over less efficient alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SplitToStream {\n    \n    @BeforeTemplate\n    Stream<String> before(Splitter splitter, CharSequence charSequence) {\n        return Refaster.anyOf(Streams.stream(splitter.split(charSequence)), splitter.splitToList(charSequence).stream());\n    }\n    \n    @AfterTemplate\n    Stream<String> after(Splitter splitter, CharSequence charSequence) {\n        return splitter.splitToStream(charSequence);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.collect.Streams.stream(#{splitter:any(com.google.common.base.Splitter)}.split(#{charSequence:any(java.lang.CharSequence)}))")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{splitter:any(com.google.common.base.Splitter)}.splitToList(#{charSequence:any(java.lang.CharSequence)}).stream()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{splitter:any(com.google.common.base.Splitter)}.splitToStream(#{charSequence:any(java.lang.CharSequence)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.util.stream.Stream", true),
                        new UsesType<>("com.google.common.base.Splitter", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.Streams", true),
                                new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                new UsesMethod<>("com.google.common.base.Splitter split(..)", true)
                            ),
                            Preconditions.and(
                                new UsesMethod<>("java.util.Collection stream(..)", true),
                                new UsesMethod<>("com.google.common.base.Splitter splitToList(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

}
