package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.BugCheckerRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class BugCheckerRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public BugCheckerRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to `com.google.errorprone.bugpatterns.BugChecker` classes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.BugCheckerRules`. [Source](https://error-prone.picnic.tech/refasterrules/BugCheckerRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new BugCheckerRefactoringTestHelperIdentityRecipe(),
                new BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe(),
                new ConstantsFormatRecipe(),
                new NameContentEqualsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.BugCheckerRefactoringTestHelperIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BugCheckerRefactoringTestHelperIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BugCheckerRefactoringTestHelperIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            return "Avoid calling `BugCheckerRefactoringTestHelper#setFixChooser(FixChooser)` or `BugCheckerRefactoringTestHelper#setImportOrder(String)` with their respective default values";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BugCheckerRefactoringTestHelperIdentity {\n    \n    @BeforeTemplate\n    BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper) {\n        return Refaster.anyOf(helper.setFixChooser(FixChoosers.FIRST), helper.setImportOrder(\"static-first\"));\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper) {\n        return helper;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setFixChooser(com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers.FIRST)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setImportOrder(\"static-first\")")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.errorprone.BugCheckerRefactoringTestHelper", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers", true),
                                new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper setFixChooser(..)", true)
                            ),
                            new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper setImportOrder(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `BugCheckerRefactoringTestHelper.ExpectOutput#expectUnchanged()` over repeating the input";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged {\n    \n    @BeforeTemplate\n    BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper, String path, String source) {\n        return helper.addInputLines(path, source).addOutputLines(path, source);\n    }\n    \n    @AfterTemplate\n    BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper, String path, String source) {\n        return helper.addInputLines(path, source).expectUnchanged();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).addOutputLines(#{path}, #{source})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).expectUnchanged()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.errorprone.BugCheckerRefactoringTestHelper", true),
                        new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput addOutputLines(..)", true),
                        new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper addInputLines(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.ConstantsFormat}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConstantsFormatRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConstantsFormatRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer using the `Constants` API over more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConstantsFormat {\n    \n    @BeforeTemplate\n    String before(String value) {\n        return String.format(\"\\\"%s\\\"\", Convert.quote(value));\n    }\n    \n    @AfterTemplate\n    String after(String value) {\n        return Constants.format(value);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("String.format(\"\\\"%s\\\"\", com.sun.tools.javac.util.Convert.quote(#{value:any(java.lang.String)}))")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("com.sun.tools.javac.util.Constants.format(#{value:any(java.lang.String)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.sun.tools.javac.util.Convert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.sun.tools.javac.util.Convert", true),
                        new UsesMethod<>("java.lang.String format(..)", true),
                        new UsesMethod<>("com.sun.tools.javac.util.Convert quote(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.NameContentEquals}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NameContentEqualsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NameContentEqualsRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Name#contentEquals(CharSequence)` over more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NameContentEquals {\n    \n    @BeforeTemplate\n    boolean before(Name name, CharSequence string) {\n        return name.toString().equals(string.toString());\n    }\n    \n    @BeforeTemplate\n    boolean before(Name name, String string) {\n        return name.toString().equals(string);\n    }\n    \n    @AfterTemplate\n    boolean after(Name name, CharSequence string) {\n        return name.contentEquals(string);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.CharSequence)}.toString())")
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.String)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("javax.lang.model.element.Name", true),
                        new UsesMethod<>("java.lang.String equals(..)", true),
                        new UsesMethod<>("java.lang.CharSequence toString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
