package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.FileRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class FileRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public FileRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with files";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.FileRules`. [Source](https://error-prone.picnic.tech/refasterrules/FileRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new PathOfUriRecipe(),
                new PathInstanceRecipe(),
                new FilesReadStringWithCharsetRecipe(),
                new FilesReadStringRecipe(),
                new FilesCreateTempFileToFileRecipe(),
                new FilesCreateTempFileInCustomDirectoryToFileRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.PathOfUri}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PathOfUriRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PathOfUriRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer the more idiomatic `Path#of(URI)` over `Paths#get(URI)`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class PathOfUri {\n    \n    @BeforeTemplate\n    Path before(URI uri) {\n        return Paths.get(uri);\n    }\n    \n    @AfterTemplate\n    Path after(URI uri) {\n        return Path.of(uri);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("java.nio.file.Paths.get(#{uri:any(java.net.URI)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.nio.file.Path.of(#{uri:any(java.net.URI)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.file.Paths");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.nio.file.Paths", true),
                        new UsesType<>("java.nio.file.Path", true),
                        new UsesType<>("java.net.URI", true),
                        new UsesMethod<>("java.nio.file.Paths get(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.PathInstance}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PathInstanceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PathInstanceRecipe() {}

        @Override
        public String getDisplayName() {
            return "Avoid redundant conversions from `Path` to `File`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class PathInstance {\n    \n    @BeforeTemplate\n    Path before(Path path) {\n        return path.toFile().toPath();\n    }\n    \n    @AfterTemplate\n    Path after(Path path) {\n        return path;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{path:any(java.nio.file.Path)}.toFile().toPath()")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{path:any(java.nio.file.Path)}")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.nio.file.Path", true),
                        new UsesMethod<>("java.io.File toPath(..)", true),
                        new UsesMethod<>("java.nio.file.Path toFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesReadStringWithCharset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesReadStringWithCharsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesReadStringWithCharsetRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Files#readString(Path, Charset)` over more contrived alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesReadStringWithCharset {\n    \n    @BeforeTemplate\n    String before(Path path, Charset charset) throws IOException {\n        return new String(Files.readAllBytes(path), charset);\n    }\n    \n    @AfterTemplate\n    String after(Path path, Charset charset) throws IOException {\n        return Files.readString(path, charset);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("new String(java.nio.file.Files.readAllBytes(#{path:any(java.nio.file.Path)}), #{charset:any(java.nio.charset.Charset)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)})")
                        .build();

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.nio.file.Files", true),
                        new UsesType<>("java.nio.file.Path", true),
                        new UsesType<>("java.nio.charset.Charset", true),
                        new UsesMethod<>("java.lang.String <constructor>(..)", true),
                        new UsesMethod<>("java.nio.file.Files readAllBytes(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesReadString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesReadStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesReadStringRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Files#readString(Path)` over more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesReadString {\n    \n    @BeforeTemplate\n    String before(Path path) throws IOException {\n        return Files.readString(path, UTF_8);\n    }\n    \n    @AfterTemplate\n    String after(Path path) throws IOException {\n        return Files.readString(path);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, java.nio.charset.StandardCharsets.UTF_8)")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.nio.file.Files.readString(#{path:any(java.nio.file.Path)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.nio.file.Files", true),
                        new UsesType<>("java.nio.file.Path", true),
                        new UsesMethod<>("java.nio.file.Files readString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesCreateTempFileToFile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesCreateTempFileToFileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesCreateTempFileToFileRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesCreateTempFileToFile {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = {\"FilesCreateTempFileInCustomDirectoryToFile\", \"java:S5443\", \"key-to-resolve-AnnotationUseStyle-and-TrailingComment-check-conflict\"})\n    File before(String prefix, String suffix) throws IOException {\n        return Refaster.anyOf(File.createTempFile(prefix, suffix), File.createTempFile(prefix, suffix, null));\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"java:S5443\")\n    File after(String prefix, String suffix) throws IOException {\n        return Files.createTempFile(prefix, suffix).toFile();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)})")
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, null)")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.io.File", true),
                        new UsesMethod<>("java.io.File createTempFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesCreateTempFileInCustomDirectoryToFile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesCreateTempFileInCustomDirectoryToFileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesCreateTempFileInCustomDirectoryToFileRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(Path, String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesCreateTempFileInCustomDirectoryToFile {\n    \n    @BeforeTemplate\n    File before(File directory, String prefix, String suffix) throws IOException {\n        return File.createTempFile(prefix, suffix, directory);\n    }\n    \n    @AfterTemplate\n    File after(File directory, String prefix, String suffix) throws IOException {\n        return Files.createTempFile(directory.toPath(), prefix, suffix).toFile();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, #{directory:any(java.io.File)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.nio.file.Files.createTempFile(#{directory:any(java.io.File)}.toPath(), #{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(2), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.io.File", true),
                        new UsesMethod<>("java.io.File createTempFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
