package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.InputStreamRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class InputStreamRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public InputStreamRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `InputStream`s";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.InputStreamRules`. [Source](https://error-prone.picnic.tech/refasterrules/InputStreamRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new InputStreamTransferToRecipe(),
                new InputStreamReadAllBytesRecipe(),
                new InputStreamReadNBytesRecipe(),
                new InputStreamSkipNBytesRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code InputStreamRules.InputStreamTransferTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InputStreamTransferToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InputStreamTransferToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamTransferTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamTransferTo {\n    \n    @BeforeTemplate\n    long before(InputStream in, OutputStream out) throws IOException {\n        return ByteStreams.copy(in, out);\n    }\n    \n    @AfterTemplate\n    long after(InputStream in, OutputStream out) throws IOException {\n        return in.transferTo(out);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.io.ByteStreams.copy(#{in:any(java.io.InputStream)}, #{out:any(java.io.OutputStream)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{in:any(java.io.InputStream)}.transferTo(#{out:any(java.io.OutputStream)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.io.ByteStreams");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.io.ByteStreams", true),
                        new UsesType<>("java.io.InputStream", true),
                        new UsesType<>("java.io.OutputStream", true),
                        new UsesMethod<>("com.google.common.io.ByteStreams copy(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code InputStreamRules.InputStreamReadAllBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InputStreamReadAllBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InputStreamReadAllBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamReadAllBytes`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamReadAllBytes {\n    \n    @BeforeTemplate\n    byte[] before(InputStream in) throws IOException {\n        return ByteStreams.toByteArray(in);\n    }\n    \n    @AfterTemplate\n    byte[] after(InputStream in) throws IOException {\n        return in.readAllBytes();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.io.ByteStreams.toByteArray(#{in:any(java.io.InputStream)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{in:any(java.io.InputStream)}.readAllBytes()")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.io.ByteStreams");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.io.ByteStreams", true),
                        new UsesType<>("java.io.InputStream", true),
                        new UsesMethod<>("com.google.common.io.ByteStreams toByteArray(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code InputStreamRules.InputStreamReadNBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InputStreamReadNBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InputStreamReadNBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamReadNBytes`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamReadNBytes {\n    \n    @BeforeTemplate\n    byte[] before(InputStream in, int n) throws IOException {\n        return ByteStreams.limit(in, n).readAllBytes();\n    }\n    \n    @AfterTemplate\n    byte[] after(InputStream in, int n) throws IOException {\n        return in.readNBytes(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.io.ByteStreams.limit(#{in:any(java.io.InputStream)}, #{n:any(int)}).readAllBytes()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{in:any(java.io.InputStream)}.readNBytes(#{n:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.io.ByteStreams");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.io.ByteStreams", true),
                        new UsesType<>("java.io.InputStream", true),
                        new UsesMethod<>("java.io.InputStream readAllBytes(..)", true),
                        new UsesMethod<>("com.google.common.io.ByteStreams limit(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code InputStreamRules.InputStreamSkipNBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InputStreamSkipNBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InputStreamSkipNBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamSkipNBytes`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamSkipNBytes {\n    \n    @BeforeTemplate\n    void before(InputStream in, long n) throws IOException {\n        ByteStreams.skipFully(in, n);\n    }\n    \n    @AfterTemplate\n    void after(InputStream in, long n) throws IOException {\n        in.skipNBytes(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.io.ByteStreams.skipFully(#{in:any(java.io.InputStream)}, #{n:any(long)});")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{in:any(java.io.InputStream)}.skipNBytes(#{n:any(long)});")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.io.ByteStreams");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.io.ByteStreams", true),
                        new UsesType<>("java.io.InputStream", true),
                        new UsesMethod<>("com.google.common.io.ByteStreams skipFully(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
