package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.MicrometerRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class MicrometerRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public MicrometerRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with Micrometer";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.MicrometerRules`. [Source](https://error-prone.picnic.tech/refasterrules/MicrometerRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new TagsOf1Recipe(),
                new TagsOf2Recipe(),
                new TagsOf3Recipe(),
                new TagsOf4Recipe(),
                new TagsOf5Recipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf1}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf1Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf1Recipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf1 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag) {\n        return Refaster.anyOf(ImmutableSet.of(tag), ImmutableList.of(tag));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag) {\n        return Tags.of(tag);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableSet.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableList.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("io.micrometer.core.instrument.Tags.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                        new UsesType<>("io.micrometer.core.instrument.Tag", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                            ),
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableList", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf2Recipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf2 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2), ImmutableList.of(tag1, tag2));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2) {\n        return Tags.of(tag1, tag2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                        new UsesType<>("io.micrometer.core.instrument.Tag", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                            ),
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableList", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf3}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf3Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf3Recipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf3 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2, Tag tag3) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2, tag3), ImmutableList.of(tag1, tag2, tag3));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2, Tag tag3) {\n        return Tags.of(tag1, tag2, tag3);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                        new UsesType<>("io.micrometer.core.instrument.Tag", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                            ),
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableList", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf4}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf4Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf4Recipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf4 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2, Tag tag3, Tag tag4) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2, tag3, tag4), ImmutableList.of(tag1, tag2, tag3, tag4));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2, Tag tag3, Tag tag4) {\n        return Tags.of(tag1, tag2, tag3, tag4);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                        new UsesType<>("io.micrometer.core.instrument.Tag", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                            ),
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableList", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf5}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf5Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf5Recipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf5 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2, Tag tag3, Tag tag4, Tag tag5) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2, tag3, tag4, tag5), ImmutableList.of(tag1, tag2, tag3, tag4, tag5));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2, Tag tag3, Tag tag4, Tag tag5) {\n        return Tags.of(tag1, tag2, tag3, tag4, tag5);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                        new UsesType<>("io.micrometer.core.instrument.Tag", true),
                        Preconditions.or(
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                            ),
                            Preconditions.and(
                                new UsesType<>("com.google.common.collect.ImmutableList", true),
                                new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                            )
                        )
                    ),
                    javaVisitor
            );
        }
    }

}
