package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.PrimitiveRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class PrimitiveRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public PrimitiveRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with primitives";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.PrimitiveRules`. [Source](https://error-prone.picnic.tech/refasterrules/PrimitiveRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new LessThanRecipe(),
                new LessThanOrEqualToRecipe(),
                new GreaterThanRecipe(),
                new GreaterThanOrEqualToRecipe(),
                new LongToIntExactRecipe(),
                new BooleanHashCodeRecipe(),
                new ByteHashCodeRecipe(),
                new CharacterHashCodeRecipe(),
                new ShortHashCodeRecipe(),
                new IntegerHashCodeRecipe(),
                new LongHashCodeRecipe(),
                new FloatHashCodeRecipe(),
                new DoubleHashCodeRecipe(),
                new CharacterBytesRecipe(),
                new ShortBytesRecipe(),
                new IntegerBytesRecipe(),
                new LongBytesRecipe(),
                new FloatBytesRecipe(),
                new DoubleBytesRecipe(),
                new FloatIsFiniteRecipe(),
                new DoubleIsFiniteRecipe(),
                new IntegerSignumIsPositiveRecipe(),
                new IntegerSignumIsNegativeRecipe(),
                new LongSignumIsPositiveRecipe(),
                new LongSignumIsNegativeRecipe(),
                new IntegerCompareUnsignedRecipe(),
                new LongCompareUnsignedRecipe(),
                new IntegerDivideUnsignedRecipe(),
                new LongDivideUnsignedRecipe(),
                new IntegerRemainderUnsignedRecipe(),
                new LongRemainderUnsignedRecipe(),
                new IntegerParseUnsignedIntRecipe(),
                new LongParseUnsignedLongRecipe(),
                new IntegerParseUnsignedIntWithRadixRecipe(),
                new LongParseUnsignedLongWithRadixRecipe(),
                new IntegerToUnsignedStringRecipe(),
                new LongToUnsignedStringRecipe(),
                new IntegerToUnsignedStringWithRadixRecipe(),
                new LongToUnsignedStringWithRadixRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LessThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LessThanRecipe() {}

        @Override
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"less than\" relationship";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LessThan {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a >= b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a < b;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("!(#{a:any(double)} >= #{b:any(double)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{a:any(double)} < #{b:any(double)}")
                        .build();

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"less than or equal to\" relationship";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LessThanOrEqualTo {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a > b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a <= b;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("!(#{a:any(double)} > #{b:any(double)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{a:any(double)} <= #{b:any(double)}")
                        .build();

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.GreaterThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class GreaterThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public GreaterThanRecipe() {}

        @Override
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"greater than\" relationship";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class GreaterThan {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a <= b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a > b;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("!(#{a:any(double)} <= #{b:any(double)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{a:any(double)} > #{b:any(double)}")
                        .build();

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.GreaterThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class GreaterThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public GreaterThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"greater than or equal to\" relationship";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class GreaterThanOrEqualTo {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a < b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a >= b;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("!(#{a:any(double)} < #{b:any(double)})")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{a:any(double)} >= #{b:any(double)}")
                        .build();

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongToIntExact}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongToIntExactRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongToIntExactRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Math#toIntExact(long)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongToIntExact {\n    \n    @BeforeTemplate\n    int before(long l) {\n        return Ints.checkedCast(l);\n    }\n    \n    @AfterTemplate\n    int after(long l) {\n        return Math.toIntExact(l);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Ints.checkedCast(#{l:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Math.toIntExact(#{l:any(long)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Ints", true),
                        new UsesMethod<>("com.google.common.primitives.Ints checkedCast(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.BooleanHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BooleanHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BooleanHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Boolean#hashCode(boolean)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BooleanHashCode {\n    \n    @BeforeTemplate\n    int before(boolean b) {\n        return Booleans.hashCode(b);\n    }\n    \n    @AfterTemplate\n    int after(boolean b) {\n        return Boolean.hashCode(b);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Booleans.hashCode(#{b:any(boolean)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Boolean.hashCode(#{b:any(boolean)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Booleans");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Booleans", true),
                        new UsesMethod<>("com.google.common.primitives.Booleans hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ByteHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ByteHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ByteHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Byte#hashCode(byte)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ByteHashCode {\n    \n    @BeforeTemplate\n    int before(byte b) {\n        return Bytes.hashCode(b);\n    }\n    \n    @AfterTemplate\n    int after(byte b) {\n        return Byte.hashCode(b);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Bytes.hashCode(#{b:any(byte)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Byte.hashCode(#{b:any(byte)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Bytes");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Bytes", true),
                        new UsesMethod<>("com.google.common.primitives.Bytes hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.CharacterHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CharacterHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CharacterHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Character#hashCode(char)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CharacterHashCode {\n    \n    @BeforeTemplate\n    int before(char c) {\n        return Chars.hashCode(c);\n    }\n    \n    @AfterTemplate\n    int after(char c) {\n        return Character.hashCode(c);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Chars.hashCode(#{c:any(char)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Character.hashCode(#{c:any(char)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Chars");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Chars", true),
                        new UsesMethod<>("com.google.common.primitives.Chars hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ShortHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ShortHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ShortHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Short#hashCode(short)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ShortHashCode {\n    \n    @BeforeTemplate\n    int before(short s) {\n        return Shorts.hashCode(s);\n    }\n    \n    @AfterTemplate\n    int after(short s) {\n        return Short.hashCode(s);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Shorts.hashCode(#{s:any(short)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Short.hashCode(#{s:any(short)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Shorts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Shorts", true),
                        new UsesMethod<>("com.google.common.primitives.Shorts hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Integer#hashCode(int)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerHashCode {\n    \n    @BeforeTemplate\n    int before(int i) {\n        return Ints.hashCode(i);\n    }\n    \n    @AfterTemplate\n    int after(int i) {\n        return Integer.hashCode(i);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Ints.hashCode(#{i:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.hashCode(#{i:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Ints", true),
                        new UsesMethod<>("com.google.common.primitives.Ints hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Long#hashCode(long)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongHashCode {\n    \n    @BeforeTemplate\n    int before(long l) {\n        return Longs.hashCode(l);\n    }\n    \n    @AfterTemplate\n    int after(long l) {\n        return Long.hashCode(l);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Longs.hashCode(#{l:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.hashCode(#{l:any(long)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Longs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Longs", true),
                        new UsesMethod<>("com.google.common.primitives.Longs hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.FloatHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FloatHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FloatHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Float#hashCode(float)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatHashCode {\n    \n    @BeforeTemplate\n    int before(float f) {\n        return Floats.hashCode(f);\n    }\n    \n    @AfterTemplate\n    int after(float f) {\n        return Float.hashCode(f);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Floats.hashCode(#{f:any(float)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Float.hashCode(#{f:any(float)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Floats");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Floats", true),
                        new UsesMethod<>("com.google.common.primitives.Floats hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.DoubleHashCode}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DoubleHashCodeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DoubleHashCodeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Double#hashCode(double)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleHashCode {\n    \n    @BeforeTemplate\n    int before(double d) {\n        return Doubles.hashCode(d);\n    }\n    \n    @AfterTemplate\n    int after(double d) {\n        return Double.hashCode(d);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Doubles.hashCode(#{d:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Double.hashCode(#{d:any(double)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Doubles");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Doubles", true),
                        new UsesMethod<>("com.google.common.primitives.Doubles hashCode(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.CharacterBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CharacterBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CharacterBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Character#BYTES` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CharacterBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Chars.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Character.BYTES;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Chars.BYTES")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Character.BYTES")
                        .build();

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Chars");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Chars");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Chars", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ShortBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ShortBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ShortBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Short#BYTES` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ShortBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Shorts.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Short.BYTES;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Shorts.BYTES")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Short.BYTES")
                        .build();

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Shorts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Shorts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Shorts", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Integer#BYTES` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Ints.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Integer.BYTES;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Ints.BYTES")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.BYTES")
                        .build();

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Ints", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Long#BYTES` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Longs.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Long.BYTES;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Longs.BYTES")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.BYTES")
                        .build();

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Longs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Longs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Longs", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.FloatBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FloatBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FloatBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Float#BYTES` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Floats.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Float.BYTES;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Floats.BYTES")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Float.BYTES")
                        .build();

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Floats");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Floats");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Floats", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.DoubleBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DoubleBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DoubleBytesRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Double#BYTES` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Doubles.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Double.BYTES;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Doubles.BYTES")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Double.BYTES")
                        .build();

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Doubles");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Doubles");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Doubles", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.FloatIsFinite}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FloatIsFiniteRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FloatIsFiniteRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Float#isFinite(float)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatIsFinite {\n    \n    @BeforeTemplate\n    boolean before(float f) {\n        return Floats.isFinite(f);\n    }\n    \n    @AfterTemplate\n    boolean after(float f) {\n        return Float.isFinite(f);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Floats.isFinite(#{f:any(float)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Float.isFinite(#{f:any(float)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Floats");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Floats", true),
                        new UsesMethod<>("com.google.common.primitives.Floats isFinite(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.DoubleIsFinite}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DoubleIsFiniteRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DoubleIsFiniteRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Double#isFinite(double)` over the Guava alternative";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleIsFinite {\n    \n    @BeforeTemplate\n    boolean before(double d) {\n        return Doubles.isFinite(d);\n    }\n    \n    @AfterTemplate\n    boolean after(double d) {\n        return Double.isFinite(d);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.Doubles.isFinite(#{d:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Double.isFinite(#{d:any(double)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Doubles");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.Doubles", true),
                        new UsesMethod<>("com.google.common.primitives.Doubles isFinite(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerSignumIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerSignumIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerSignumIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer an `Integer#signum(int)` comparison to 1 over less clear alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerSignumIsPositive {\n    \n    @BeforeTemplate\n    boolean before(int i) {\n        return Refaster.anyOf(Integer.signum(i) > 0, Integer.signum(i) >= 1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(int i) {\n        return Integer.signum(i) == 1;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("Integer.signum(#{i:any(int)}) > 0")
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Integer.signum(#{i:any(int)}) >= 1")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.signum(#{i:any(int)}) == 1")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Integer signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerSignumIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerSignumIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerSignumIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer an `Integer#signum(int)` comparison to -1 over less clear alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerSignumIsNegative {\n    \n    @BeforeTemplate\n    boolean before(int i) {\n        return Refaster.anyOf(Integer.signum(i) < 0, Integer.signum(i) <= -1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(int i) {\n        return Integer.signum(i) == -1;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("Integer.signum(#{i:any(int)}) < 0")
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Integer.signum(#{i:any(int)}) <= -1")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.signum(#{i:any(int)}) == -1")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Integer signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongSignumIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongSignumIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongSignumIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer an `Long#signum(long)` comparison to 1 over less clear alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongSignumIsPositive {\n    \n    @BeforeTemplate\n    boolean before(long l) {\n        return Refaster.anyOf(Long.signum(l) > 0, Long.signum(l) >= 1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(long l) {\n        return Long.signum(l) == 1;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("Long.signum(#{l:any(long)}) > 0")
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Long.signum(#{l:any(long)}) >= 1")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.signum(#{l:any(long)}) == 1")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Long signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongSignumIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongSignumIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongSignumIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer an `Long#signum(long)` comparison to -1 over less clear alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongSignumIsNegative {\n    \n    @BeforeTemplate\n    boolean before(long l) {\n        return Refaster.anyOf(Long.signum(l) < 0, Long.signum(l) <= -1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(long l) {\n        return Long.signum(l) == -1;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("Long.signum(#{l:any(long)}) < 0")
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Long.signum(#{l:any(long)}) <= -1")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.signum(#{l:any(long)}) == -1")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Long signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerCompareUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerCompareUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerCompareUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#compareUnsigned(int, int)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerCompareUnsigned {\n    \n    @BeforeTemplate\n    int before(int x, int y) {\n        return UnsignedInts.compare(x, y);\n    }\n    \n    @AfterTemplate\n    int after(int x, int y) {\n        return Integer.compareUnsigned(x, y);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.compare(#{x:any(int)}, #{y:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.compareUnsigned(#{x:any(int)}, #{y:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts compare(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongCompareUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongCompareUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongCompareUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#compareUnsigned(long, long)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongCompareUnsigned {\n    \n    @BeforeTemplate\n    long before(long x, long y) {\n        return UnsignedLongs.compare(x, y);\n    }\n    \n    @AfterTemplate\n    long after(long x, long y) {\n        return Long.compareUnsigned(x, y);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.compare(#{x:any(long)}, #{y:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.compareUnsigned(#{x:any(long)}, #{y:any(long)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs compare(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerDivideUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerDivideUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerDivideUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#divideUnsigned(int, int)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerDivideUnsigned {\n    \n    @BeforeTemplate\n    int before(int x, int y) {\n        return UnsignedInts.divide(x, y);\n    }\n    \n    @AfterTemplate\n    int after(int x, int y) {\n        return Integer.divideUnsigned(x, y);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.divide(#{x:any(int)}, #{y:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.divideUnsigned(#{x:any(int)}, #{y:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts divide(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongDivideUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongDivideUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongDivideUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#divideUnsigned(long, long)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongDivideUnsigned {\n    \n    @BeforeTemplate\n    long before(long x, long y) {\n        return UnsignedLongs.divide(x, y);\n    }\n    \n    @AfterTemplate\n    long after(long x, long y) {\n        return Long.divideUnsigned(x, y);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.divide(#{x:any(long)}, #{y:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.divideUnsigned(#{x:any(long)}, #{y:any(long)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs divide(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerRemainderUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerRemainderUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerRemainderUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#remainderUnsigned(int, int)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerRemainderUnsigned {\n    \n    @BeforeTemplate\n    int before(int x, int y) {\n        return UnsignedInts.remainder(x, y);\n    }\n    \n    @AfterTemplate\n    int after(int x, int y) {\n        return Integer.remainderUnsigned(x, y);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.remainder(#{x:any(int)}, #{y:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.remainderUnsigned(#{x:any(int)}, #{y:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts remainder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongRemainderUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongRemainderUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongRemainderUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#remainderUnsigned(long, long)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongRemainderUnsigned {\n    \n    @BeforeTemplate\n    long before(long x, long y) {\n        return UnsignedLongs.remainder(x, y);\n    }\n    \n    @AfterTemplate\n    long after(long x, long y) {\n        return Long.remainderUnsigned(x, y);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.remainder(#{x:any(long)}, #{y:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.remainderUnsigned(#{x:any(long)}, #{y:any(long)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs remainder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerParseUnsignedInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerParseUnsignedIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerParseUnsignedIntRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#parseUnsignedInt(String)` over third-party or more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerParseUnsignedInt {\n    \n    @BeforeTemplate\n    int before(String string) {\n        return Refaster.anyOf(UnsignedInts.parseUnsignedInt(string), Integer.parseUnsignedInt(string, 10));\n    }\n    \n    @AfterTemplate\n    int after(String string) {\n        return Integer.parseUnsignedInt(string);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.parseUnsignedInt(#{string:any(java.lang.String)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)}, 10)")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts parseUnsignedInt(..)", true)
                    ),
                        new UsesMethod<>("java.lang.Integer parseUnsignedInt(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongParseUnsignedLong}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongParseUnsignedLongRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongParseUnsignedLongRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#parseUnsignedLong(String)` over third-party or more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongParseUnsignedLong {\n    \n    @BeforeTemplate\n    long before(String string) {\n        return Refaster.anyOf(UnsignedLongs.parseUnsignedLong(string), Long.parseUnsignedLong(string, 10));\n    }\n    \n    @AfterTemplate\n    long after(String string) {\n        return Long.parseUnsignedLong(string);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.parseUnsignedLong(#{string:any(java.lang.String)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Long.parseUnsignedLong(#{string:any(java.lang.String)}, 10)")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.parseUnsignedLong(#{string:any(java.lang.String)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs parseUnsignedLong(..)", true)
                    ),
                        new UsesMethod<>("java.lang.Long parseUnsignedLong(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerParseUnsignedIntWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerParseUnsignedIntWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerParseUnsignedIntWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#parseUnsignedInt(String, int)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerParseUnsignedIntWithRadix {\n    \n    @BeforeTemplate\n    int before(String string, int radix) {\n        return UnsignedInts.parseUnsignedInt(string, radix);\n    }\n    \n    @AfterTemplate\n    int after(String string, int radix) {\n        return Integer.parseUnsignedInt(string, radix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.parseUnsignedInt(#{string:any(java.lang.String)}, #{radix:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)}, #{radix:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts parseUnsignedInt(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongParseUnsignedLongWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongParseUnsignedLongWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongParseUnsignedLongWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#parseUnsignedLong(String, int)` over third-party alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongParseUnsignedLongWithRadix {\n    \n    @BeforeTemplate\n    long before(String string, int radix) {\n        return UnsignedLongs.parseUnsignedLong(string, radix);\n    }\n    \n    @AfterTemplate\n    long after(String string, int radix) {\n        return Long.parseUnsignedLong(string, radix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.parseUnsignedLong(#{string:any(java.lang.String)}, #{radix:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.parseUnsignedLong(#{string:any(java.lang.String)}, #{radix:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs parseUnsignedLong(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerToUnsignedString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerToUnsignedStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerToUnsignedStringRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#toUnsignedString(int)` over third-party or more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerToUnsignedString {\n    \n    @BeforeTemplate\n    String before(int i) {\n        return Refaster.anyOf(UnsignedInts.toString(i), Integer.toUnsignedString(i, 10));\n    }\n    \n    @AfterTemplate\n    String after(int i) {\n        return Integer.toUnsignedString(i);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.toString(#{i:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Integer.toUnsignedString(#{i:any(int)}, 10)")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.toUnsignedString(#{i:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts toString(..)", true)
                    ),
                        new UsesMethod<>("java.lang.Integer toUnsignedString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongToUnsignedString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongToUnsignedStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongToUnsignedStringRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#toUnsignedString(long)` over third-party or more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongToUnsignedString {\n    \n    @BeforeTemplate\n    String before(long i) {\n        return Refaster.anyOf(UnsignedLongs.toString(i), Long.toUnsignedString(i, 10));\n    }\n    \n    @AfterTemplate\n    String after(long i) {\n        return Long.toUnsignedString(i);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.toString(#{i:any(long)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("Long.toUnsignedString(#{i:any(long)}, 10)")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.toUnsignedString(#{i:any(long)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                        Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs toString(..)", true)
                    ),
                        new UsesMethod<>("java.lang.Long toUnsignedString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerToUnsignedStringWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerToUnsignedStringWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerToUnsignedStringWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Integer#toUnsignedString(int,int)` over third-party or more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerToUnsignedStringWithRadix {\n    \n    @BeforeTemplate\n    String before(int i, int radix) {\n        return UnsignedInts.toString(i, radix);\n    }\n    \n    @AfterTemplate\n    String after(int i, int radix) {\n        return Integer.toUnsignedString(i, radix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedInts.toString(#{i:any(int)}, #{radix:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Integer.toUnsignedString(#{i:any(int)}, #{radix:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedInts toString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongToUnsignedStringWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongToUnsignedStringWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongToUnsignedStringWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer JDK's `Long#toUnsignedString(long,int)` over third-party or more verbose alternatives";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongToUnsignedStringWithRadix {\n    \n    @BeforeTemplate\n    String before(long i, int radix) {\n        return UnsignedLongs.toString(i, radix);\n    }\n    \n    @AfterTemplate\n    String after(long i, int radix) {\n        return Long.toUnsignedString(i, radix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("com.google.common.primitives.UnsignedLongs.toString(#{i:any(long)}, #{radix:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("Long.toUnsignedString(#{i:any(long)}, #{radix:any(int)})")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                        new UsesMethod<>("com.google.common.primitives.UnsignedLongs toString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
