package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.RxJava2AdapterRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class RxJava2AdapterRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public RxJava2AdapterRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `RxJava2Adapter`";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.RxJava2AdapterRules`. [Source](https://error-prone.picnic.tech/refasterrules/RxJava2AdapterRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new CompletableToMonoRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.CompletableToMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CompletableToMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CompletableToMonoRecipe() {}

        @Override
        public String getDisplayName() {
            return "Use the fluent API style when using `RxJava2Adapter#completableToMono`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CompletableToMono {\n    \n    @BeforeTemplate\n    Mono<@Nullable Void> before(Completable completable) {\n        return Refaster.anyOf(RxJava2Adapter.completableToMono(completable), completable.to(RxJava2Adapter::completableToMono));\n    }\n    \n    @AfterTemplate\n    Mono<@Nullable Void> after(Completable completable) {\n        return completable.as(RxJava2Adapter::completableToMono);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("reactor.adapter.rxjava.RxJava2Adapter.completableToMono(#{completable:any(io.reactivex.Completable)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{completable:any(io.reactivex.Completable)}.to(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                        new UsesType<>("reactor.core.publisher.Mono", true),
                        new UsesType<>("io.reactivex.Completable", true),
                        Preconditions.or(
                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter completableToMono(..)", true),
                            new UsesMethod<>("io.reactivex.Completable to(..)", true)
                        )
                    ),
                    javaVisitor
            );
        }
    }

}
