package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.StreamRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class StreamRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public StreamRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `Stream`s";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.StreamRules`. [Source](https://error-prone.picnic.tech/refasterrules/StreamRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new JoiningRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.Joining}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class JoiningRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public JoiningRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `Collectors#joining()` over `Collectors#joining(CharSequence)` with an empty delimiter string";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Joining {\n    \n    @BeforeTemplate\n    Collector<CharSequence, ?, String> before() {\n        return joining(\"\");\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Collector<CharSequence, ?, String> after() {\n        return joining();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("java.util.stream.Collectors.joining(\"\")")
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("java.util.stream.Collectors.joining()")
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("java.util.stream.Collector", true),
                        new UsesMethod<>("java.util.stream.Collectors joining(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
