package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.WebClientRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class WebClientRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public WebClientRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `org.springframework.web.reactive.function.client.WebClient` and related types";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.WebClientRules`. [Source](https://error-prone.picnic.tech/refasterrules/WebClientRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new WebClientGetRecipe(),
                new WebClientHeadRecipe(),
                new WebClientOptionsRecipe(),
                new WebClientPatchRecipe(),
                new WebClientPostRecipe(),
                new WebClientPutRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientGet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientGetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientGetRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `WebClient#get()` over `WebClient#method(HttpMethod)` with `HttpMethod#GET`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientGet {\n    \n    @BeforeTemplate\n    RequestHeadersSpec<?> before(WebClient webClient) {\n        return webClient.method(GET);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {\n        return webClient.method(GET);\n    }\n    \n    @AfterTemplate\n    RequestHeadersSpec<?> after(WebClient webClient) {\n        return webClient.get();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.GET)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.GET)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.get()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                        new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientHead}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientHeadRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientHeadRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `WebClient#head()` over `WebClient#method(HttpMethod)` with `HttpMethod#HEAD`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientHead {\n    \n    @BeforeTemplate\n    RequestHeadersSpec<?> before(WebClient webClient) {\n        return webClient.method(HEAD);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {\n        return webClient.method(HEAD);\n    }\n    \n    @AfterTemplate\n    RequestHeadersSpec<?> after(WebClient webClient) {\n        return webClient.head();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.HEAD)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.HEAD)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.head()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                        new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientOptions}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientOptionsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientOptionsRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `WebClient#options()` over `WebClient#method(HttpMethod)` with `HttpMethod#OPTIONS`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientOptions {\n    \n    @BeforeTemplate\n    RequestHeadersSpec<?> before(WebClient webClient) {\n        return webClient.method(OPTIONS);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {\n        return webClient.method(OPTIONS);\n    }\n    \n    @AfterTemplate\n    RequestHeadersSpec<?> after(WebClient webClient) {\n        return webClient.options();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.OPTIONS)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.OPTIONS)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.options()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                        new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientPatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientPatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientPatchRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `WebClient#patch()` over `WebClient#method(HttpMethod)` with `HttpMethod#PATCH`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientPatch {\n    \n    @BeforeTemplate\n    RequestBodyUriSpec before(WebClient webClient) {\n        return webClient.method(PATCH);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {\n        return webClient.method(PATCH);\n    }\n    \n    @AfterTemplate\n    RequestBodyUriSpec after(WebClient webClient) {\n        return webClient.patch();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.PATCH)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.PATCH)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.patch()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                        new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientPost}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientPostRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientPostRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `WebClient#post()` over `WebClient#method(HttpMethod)` with `HttpMethod#POST`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientPost {\n    \n    @BeforeTemplate\n    RequestBodyUriSpec before(WebClient webClient) {\n        return webClient.method(POST);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {\n        return webClient.method(POST);\n    }\n    \n    @AfterTemplate\n    RequestBodyUriSpec after(WebClient webClient) {\n        return webClient.post();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.POST)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.POST)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.post()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                        new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientPut}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientPutRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientPutRecipe() {}

        @Override
        public String getDisplayName() {
            return "Prefer `WebClient#put()` over `WebClient#method(HttpMethod)` with `HttpMethod#PUT`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientPut {\n    \n    @BeforeTemplate\n    RequestBodyUriSpec before(WebClient webClient) {\n        return webClient.method(PUT);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {\n        return webClient.method(PUT);\n    }\n    \n    @AfterTemplate\n    RequestBodyUriSpec after(WebClient webClient) {\n        return webClient.put();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.PUT)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.PUT)")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.put()")
                        .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                        new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
