/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.bugpatterns.AutoValue_NonStaticImport_UndesiredStaticImport;
import tech.picnic.errorprone.bugpatterns.StaticImport;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Member should not be statically imported", link="https://error-prone.picnic.tech/bugpatterns/NonStaticImport", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class NonStaticImport
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    static final ImmutableSet<String> NON_STATIC_IMPORT_CANDIDATE_TYPES = ImmutableSet.of((Object)ASTHelpers.class.getCanonicalName(), (Object)Clock.class.getCanonicalName(), (Object)Strings.class.getCanonicalName(), (Object)VisitorState.class.getCanonicalName(), (Object)ZoneOffset.class.getCanonicalName(), (Object)"com.google.errorprone.BugCheckerRefactoringTestHelper.TestMode", (Object[])new String[]{"reactor.core.publisher.Flux", "reactor.core.publisher.Mono"});
    static final ImmutableSetMultimap<String, String> NON_STATIC_IMPORT_CANDIDATE_MEMBERS = ImmutableSetMultimap.builder().putAll((Object)Collections.class.getCanonicalName(), (Object[])new String[]{"addAll", "copy", "fill", "list", "max", "min", "nCopies", "rotate", "sort", "swap"}).put((Object)Locale.class.getCanonicalName(), (Object)"ROOT").put((Object)Optional.class.getCanonicalName(), (Object)"empty").putAll((Object)Pattern.class.getCanonicalName(), (Object[])new String[]{"compile", "matches", "quote"}).put((Object)Predicates.class.getCanonicalName(), (Object)"contains").put((Object)"org.springframework.http.MediaType", (Object)"ALL").build();
    static final ImmutableSet<String> NON_STATIC_IMPORT_CANDIDATE_IDENTIFIERS = ImmutableSet.of((Object)"builder", (Object)"copyOf", (Object)"create", (Object)"from", (Object)"getDefaultInstance", (Object)"INSTANCE", (Object[])new String[]{"MAX", "MAX_VALUE", "MIN", "MIN_VALUE", "newBuilder", "newInstance", "of", "parse", "valueOf"});

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableTable<String, String, UndesiredStaticImport> undesiredStaticImports = NonStaticImport.getUndesiredStaticImports(tree, state);
        if (!undesiredStaticImports.isEmpty()) {
            NonStaticImport.replaceUndesiredStaticImportUsages(tree, undesiredStaticImports, state);
            for (UndesiredStaticImport staticImport : undesiredStaticImports.values()) {
                state.reportMatch(this.describeMatch(staticImport.importTree(), (Fix)staticImport.fixBuilder().build()));
            }
        }
        return Description.NO_MATCH;
    }

    private static ImmutableTable<String, String, UndesiredStaticImport> getUndesiredStaticImports(CompilationUnitTree tree, VisitorState state) {
        ImmutableTable.Builder imports = ImmutableTable.builder();
        for (ImportTree importTree : tree.getImports()) {
            String member;
            MemberSelectTree memberSelect;
            String type;
            Tree qualifiedIdentifier = importTree.getQualifiedIdentifier();
            if (!importTree.isStatic() || !(qualifiedIdentifier instanceof MemberSelectTree) || !NonStaticImport.shouldNotBeStaticallyImported(type = SourceCode.treeToString((Tree)(memberSelect = (MemberSelectTree)qualifiedIdentifier).getExpression(), (VisitorState)state), member = memberSelect.getIdentifier().toString())) continue;
            imports.put((Object)type, (Object)member, (Object)new AutoValue_NonStaticImport_UndesiredStaticImport(importTree, SuggestedFix.builder().removeStaticImport(type + "." + member)));
        }
        return imports.build();
    }

    private static boolean shouldNotBeStaticallyImported(String type, String member) {
        return NON_STATIC_IMPORT_CANDIDATE_TYPES.contains((Object)type) && !StaticImport.STATIC_IMPORT_CANDIDATE_MEMBERS.containsEntry((Object)type, (Object)member) || NON_STATIC_IMPORT_CANDIDATE_MEMBERS.containsEntry((Object)type, (Object)member) || NON_STATIC_IMPORT_CANDIDATE_IDENTIFIERS.contains((Object)member);
    }

    private static void replaceUndesiredStaticImportUsages(CompilationUnitTree tree, final ImmutableTable<String, String, UndesiredStaticImport> undesiredStaticImports, final VisitorState state) {
        new TreeScanner<Void, Void>(){

            @Override
            public @Nullable Void visitIdentifier(IdentifierTree node, @Nullable Void unused) {
                UndesiredStaticImport staticImport;
                Symbol symbol = ASTHelpers.getSymbol((Tree)node);
                if (symbol != null && (staticImport = (UndesiredStaticImport)undesiredStaticImports.get((Object)symbol.owner.getQualifiedName().toString(), (Object)symbol.name.toString())) != null) {
                    SuggestedFix.Builder fix = staticImport.fixBuilder();
                    fix.prefixWith((Tree)node, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)symbol.owner) + ".");
                }
                return (Void)super.visitIdentifier(node, null);
            }
        }.scan(tree, null);
    }

    @AutoValue
    static abstract class UndesiredStaticImport {
        UndesiredStaticImport() {
        }

        abstract ImportTree importTree();

        abstract SuggestedFix.Builder fixBuilder();
    }
}

