/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.function.Function;
import java.util.function.Predicate;

final class ClassRules {
    private ClassRules() {
    }

    static final class ClassReferenceCast<T, S> {
        ClassReferenceCast() {
        }

        Function<T, S> before(Class<? extends S> clazz) {
            return o -> clazz.cast(o);
        }

        Function<T, S> after(Class<? extends S> clazz) {
            return clazz::cast;
        }
    }

    static final class ClassReferenceIsInstancePredicate<T, S> {
        ClassReferenceIsInstancePredicate() {
        }

        Predicate<S> before(Class<T> clazz) {
            return o -> clazz.isInstance(o);
        }

        Predicate<S> after(Class<T> clazz) {
            return clazz::isInstance;
        }
    }

    static final class ClassLiteralIsInstancePredicate<T, S> {
        ClassLiteralIsInstancePredicate() {
        }

        Predicate<S> before() {
            return o -> Refaster.isInstance((Object)o);
        }

        Predicate<S> after() {
            return Refaster.clazz()::isInstance;
        }
    }

    static final class Instanceof<T, S> {
        Instanceof() {
        }

        boolean before(S object) {
            return Refaster.clazz().isInstance(object);
        }

        boolean after(S object) {
            return Refaster.isInstance(object);
        }
    }

    static final class ClassIsInstance<T, S> {
        ClassIsInstance() {
        }

        boolean before(Class<T> clazz, S object) {
            return clazz.isAssignableFrom(object.getClass());
        }

        boolean after(Class<T> clazz, S object) {
            return clazz.isInstance(object);
        }
    }
}

