/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class ImmutableSetRules {
    private ImmutableSetRules() {
    }

    static final class SetsUnion<S, T extends S, U extends S> {
        SetsUnion() {
        }

        ImmutableSet<S> before(Set<T> set1, Set<U> set2) {
            return (ImmutableSet)Stream.concat(set1.stream(), set2.stream()).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<S> after(Set<T> set1, Set<U> set2) {
            return Sets.union(set1, set2).immutableCopy();
        }
    }

    static final class SetsIntersectionMultimap<T, K, V> {
        SetsIntersectionMultimap() {
        }

        ImmutableSet<T> before(Set<T> set, Multimap<K, V> multimap) {
            return (ImmutableSet)set.stream().filter(arg_0 -> multimap.containsKey(arg_0)).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Set<T> set, Multimap<K, V> multimap) {
            return Sets.intersection(set, (Set)multimap.keySet()).immutableCopy();
        }
    }

    static final class SetsIntersectionMap<T, K, V> {
        SetsIntersectionMap() {
        }

        ImmutableSet<T> before(Set<T> set, Map<K, V> map) {
            return (ImmutableSet)set.stream().filter(map::containsKey).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Set<T> set, Map<K, V> map) {
            return Sets.intersection(set, map.keySet()).immutableCopy();
        }
    }

    static final class SetsIntersection<S, T> {
        SetsIntersection() {
        }

        ImmutableSet<S> before(Set<S> set1, Set<T> set2) {
            return (ImmutableSet)set1.stream().filter(set2::contains).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<S> after(Set<S> set1, Set<T> set2) {
            return Sets.intersection(set1, set2).immutableCopy();
        }
    }

    static final class SetsDifferenceMultimap<T, K, V> {
        SetsDifferenceMultimap() {
        }

        ImmutableSet<T> before(Set<T> set, Multimap<K, V> multimap) {
            Object[] objectArray = new Predicate[2];
            objectArray[0] = Predicate.not(arg_0 -> multimap.containsKey(arg_0));
            objectArray[1] = e -> !multimap.containsKey(e);
            return (ImmutableSet)set.stream().filter((Predicate)Refaster.anyOf((Object[])objectArray)).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Set<T> set, Multimap<K, V> multimap) {
            return Sets.difference(set, (Set)multimap.keySet()).immutableCopy();
        }
    }

    static final class SetsDifferenceMap<T, K, V> {
        SetsDifferenceMap() {
        }

        ImmutableSet<T> before(Set<T> set, Map<K, V> map) {
            Object[] objectArray = new Predicate[2];
            objectArray[0] = Predicate.not(map::containsKey);
            objectArray[1] = e -> !map.containsKey(e);
            return (ImmutableSet)set.stream().filter((Predicate)Refaster.anyOf((Object[])objectArray)).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<K> after(Set<K> set, Map<K, V> map) {
            return Sets.difference(set, map.keySet()).immutableCopy();
        }
    }

    static final class SetsDifference<S, T> {
        SetsDifference() {
        }

        ImmutableSet<S> before(Set<S> set1, Set<T> set2) {
            Object[] objectArray = new Predicate[2];
            objectArray[0] = Predicate.not(set2::contains);
            objectArray[1] = e -> !set2.contains(e);
            return (ImmutableSet)set1.stream().filter((Predicate)Refaster.anyOf((Object[])objectArray)).collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<S> after(Set<S> set1, Set<T> set2) {
            return Sets.difference(set1, set2).immutableCopy();
        }
    }

    static final class ImmutableSetOf5<T> {
        ImmutableSetOf5() {
        }

        Set<T> before(T e1, T e2, T e3, T e4, T e5) {
            return Set.of(e1, e2, e3, e4, e5);
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4, T e5) {
            return ImmutableSet.of(e1, e2, e3, e4, e5);
        }
    }

    static final class ImmutableSetOf4<T> {
        ImmutableSetOf4() {
        }

        Set<T> before(T e1, T e2, T e3, T e4) {
            return Set.of(e1, e2, e3, e4);
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4) {
            return ImmutableSet.of(e1, e2, e3, e4);
        }
    }

    static final class ImmutableSetOf3<T> {
        ImmutableSetOf3() {
        }

        Set<T> before(T e1, T e2, T e3) {
            return Set.of(e1, e2, e3);
        }

        ImmutableSet<T> after(T e1, T e2, T e3) {
            return ImmutableSet.of(e1, e2, e3);
        }
    }

    static final class ImmutableSetOf2<T> {
        ImmutableSetOf2() {
        }

        Set<T> before(T e1, T e2) {
            return Set.of(e1, e2);
        }

        ImmutableSet<T> after(T e1, T e2) {
            return ImmutableSet.of(e1, e2);
        }
    }

    static final class ImmutableSetOf1<T> {
        ImmutableSetOf1() {
        }

        Set<T> before(T e1) {
            return (Set)Refaster.anyOf((Object[])new Set[]{ImmutableSet.builder().add(e1).build(), Collections.singleton(e1), Set.of(e1)});
        }

        ImmutableSet<T> after(T e1) {
            return ImmutableSet.of(e1);
        }
    }

    static final class ImmutableSetOf<T> {
        ImmutableSetOf() {
        }

        Set<T> before() {
            return (Set)Refaster.anyOf((Object[])new Set[]{ImmutableSet.builder().build(), (Set)Stream.empty().collect(ImmutableSet.toImmutableSet()), Collections.emptySet(), Set.of()});
        }

        ImmutableSet<T> after() {
            return ImmutableSet.of();
        }
    }

    static final class ImmutableSetCopyOfSetView<T> {
        ImmutableSetCopyOfSetView() {
        }

        ImmutableSet<T> before(Sets.SetView<T> set) {
            return ImmutableSet.copyOf(set);
        }

        ImmutableSet<T> after(Sets.SetView<T> set) {
            return set.immutableCopy();
        }
    }

    static final class StreamToImmutableSet<T> {
        StreamToImmutableSet() {
        }

        ImmutableSet<T> before(Stream<T> stream) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.copyOf(stream.iterator()), (ImmutableSet)stream.distinct().collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> after(Stream<T> stream) {
            return (ImmutableSet)stream.collect(ImmutableSet.toImmutableSet());
        }
    }

    static final class IterableToImmutableSet<T> {
        IterableToImmutableSet() {
        }

        ImmutableSet<T> before(T[] iterable) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.builder().add((Object[])iterable).build(), (ImmutableSet)Arrays.stream(iterable).collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> before(Iterator<T> iterable) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.builder().addAll(iterable).build(), (ImmutableSet)Streams.stream(iterable).collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> before(Iterable<T> iterable) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.builder().addAll(iterable).build(), (ImmutableSet)Streams.stream(iterable).collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> before(Collection<T> iterable) {
            return (ImmutableSet)iterable.stream().collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Iterable<T> iterable) {
            return ImmutableSet.copyOf(iterable);
        }
    }

    static final class ImmutableSetBuilder<T> {
        ImmutableSetBuilder() {
        }

        ImmutableSet.Builder<T> before() {
            return new ImmutableSet.Builder();
        }

        ImmutableSet.Builder<T> after() {
            return ImmutableSet.builder();
        }
    }
}

