/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJThrowingCallableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to AssertJ assertions over expressions that may throw a `Throwable` subtype";
    }

    public String getDescription() {
        return "For reasons of consistency we prefer `org.assertj.core.api.Assertions#assertThatThrownBy` over static methods for specific exception\n types. Note that only the most common assertion expressions are rewritten here; covering all\n cases would require the implementation of an Error Prone check instead. [Source](https://error-prone.picnic.tech/refasterrules/AssertJThrowingCallableRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatThrownByIllegalArgumentExceptionRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageRecipe(), new AssertThatThrownByIllegalArgumentExceptionRootCauseHasMessageRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageContainingRecipe(), new AssertThatThrownByIllegalStateExceptionRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageRecipe(), new AssertThatThrownByIllegalStateExceptionRootCauseHasMessageRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageContainingRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageNotContainingRecipe(), new AssertThatThrownByNullPointerExceptionRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageRecipe(), new AssertThatThrownByNullPointerExceptionRootCauseHasMessageRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageContainingRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageNotContainingRecipe(), new AssertThatThrownByIOExceptionRecipe(), new AssertThatThrownByIOExceptionHasMessageRecipe(), new AssertThatThrownByIOExceptionRootCauseHasMessageRecipe(), new AssertThatThrownByIOExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByIOExceptionHasMessageContainingRecipe(), new AssertThatThrownByIOExceptionHasMessageNotContainingRecipe(), new AssertThatThrownByHasMessageRecipe(), new AssertThatThrownByRootCauseHasMessageRecipe(), new AssertThatThrownByHasMessageStartingWithRecipe(), new AssertThatThrownByHasMessageContainingRecipe(), new AssertThatThrownByHasMessageNotContainingRecipe()});
    }

    @NullMarked
    public static class AssertThatThrownByIllegalArgumentExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalArgumentException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalArgumentException.class)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalArgumentException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalArgumentException.class).hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalArgumentExceptionRootCauseHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionRootCauseHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionRootCauseHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).rootCause().hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalArgumentException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).havingRootCause().withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalArgumentException.class).rootCause().hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative havingRootCause(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalArgumentException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalArgumentException.class).hasMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalArgumentException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalArgumentException.class).hasMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalStateExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalStateException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalStateException.class)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalStateExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalStateException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalStateException.class).hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalStateExceptionRootCauseHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionRootCauseHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionRootCauseHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).rootCause().hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalStateException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).havingRootCause().withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalStateException.class).rootCause().hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative havingRootCause(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalStateExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalStateException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalStateException.class).hasMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalStateExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalStateException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalStateException.class).hasMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIllegalStateExceptionHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIllegalStateException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(IllegalStateException.class).hasMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByNullPointerExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatNullPointerException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(NullPointerException.class)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByNullPointerExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatNullPointerException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(NullPointerException.class).hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByNullPointerExceptionRootCauseHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionRootCauseHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionRootCauseHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).rootCause().hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatNullPointerException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).havingRootCause().withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(NullPointerException.class).rootCause().hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative havingRootCause(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByNullPointerExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatNullPointerException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(NullPointerException.class).hasMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByNullPointerExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatNullPointerException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(NullPointerException.class).hasMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByNullPointerExceptionHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatNullPointerException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(NullPointerException.class).hasMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIOExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatIOException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIOException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(java.io.IOException.class)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIOExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIOException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(java.io.IOException.class).hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIOExceptionRootCauseHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionRootCauseHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionRootCauseHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).rootCause().hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIOException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).havingRootCause().withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(java.io.IOException.class).rootCause().hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative havingRootCause(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIOExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIOException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(java.io.IOException.class).hasMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIOExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIOException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(java.io.IOException.class).hasMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByIOExceptionHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatIOException().isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(java.io.IOException.class).hasMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByAsInstanceOfThrowable\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatExceptionOfType(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByRootCauseHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByRootCauseHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByRootCauseHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByAsInstanceOfThrowable\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).havingRootCause().withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).rootCause().hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatExceptionOfType(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).havingRootCause().withMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).rootCause().hasMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative havingRootCause(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByAsInstanceOfThrowable\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatExceptionOfType(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).hasMessageStartingWith(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByAsInstanceOfThrowable\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatExceptionOfType(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).hasMessageContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatThrownByHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByAsInstanceOfThrowable\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatExceptionOfType(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).isThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{exceptionType:any(java.lang.Class<? extends java.lang.Throwable>)}).hasMessageNotContaining(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)", true), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)", true), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

