/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JUnitToAssertJRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules to replace JUnit assertions with AssertJ equivalents";
    }

    public String getDescription() {
        return "Note that, while both libraries throw an `AssertionError` in case of an assertion\n failure, the exact subtype used generally differs. [Source](https://error-prone.picnic.tech/refasterrules/JUnitToAssertJRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatBooleanArrayContainsExactlyRecipe(), new AssertThatBooleanArrayWithFailMessageContainsExactlyRecipe(), new AssertThatBooleanArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatByteArrayContainsExactlyRecipe(), new AssertThatByteArrayWithFailMessageContainsExactlyRecipe(), new AssertThatByteArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatCharArrayContainsExactlyRecipe(), new AssertThatCharArrayWithFailMessageContainsExactlyRecipe(), new AssertThatCharArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatShortArrayContainsExactlyRecipe(), new AssertThatShortArrayWithFailMessageContainsExactlyRecipe(), new AssertThatShortArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatIntArrayContainsExactlyRecipe(), new AssertThatIntArrayWithFailMessageContainsExactlyRecipe(), new AssertThatIntArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatLongArrayContainsExactlyRecipe(), new AssertThatLongArrayWithFailMessageContainsExactlyRecipe(), new AssertThatLongArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatFloatArrayContainsExactlyRecipe(), new AssertThatFloatArrayWithFailMessageContainsExactlyRecipe(), new AssertThatFloatArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatFloatArrayContainsExactlyWithOffsetRecipe(), new AssertThatFloatArrayWithFailMessageContainsExactlyWithOffsetRecipe(), new AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe(), new AssertThatDoubleArrayContainsExactlyRecipe(), new AssertThatDoubleArrayWithFailMessageContainsExactlyRecipe(), new AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatDoubleArrayContainsExactlyWithOffsetRecipe(), new AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffsetRecipe(), new AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe(), new AssertThatObjectArrayContainsExactlyRecipe(), new AssertThatObjectArrayWithFailMessageContainsExactlyRecipe(), new AssertThatObjectArrayWithFailMessageSupplierContainsExactlyRecipe(), new AssertThatIsTrueRecipe(), new AssertThatWithFailMessageStringIsTrueRecipe(), new AssertThatWithFailMessageSupplierIsTrueRecipe(), new AssertThatIsFalseRecipe(), new AssertThatWithFailMessageStringIsFalseRecipe(), new AssertThatWithFailMessageSupplierIsFalseRecipe(), new AssertThatIsNullRecipe(), new AssertThatWithFailMessageStringIsNullRecipe(), new AssertThatWithFailMessageSupplierIsNullRecipe(), new AssertThatIsNotNullRecipe(), new AssertThatWithFailMessageStringIsNotNullRecipe(), new AssertThatWithFailMessageSupplierIsNotNullRecipe(), new AssertThatIsSameAsRecipe(), new AssertThatWithFailMessageStringIsSameAsRecipe(), new AssertThatWithFailMessageSupplierIsSameAsRecipe(), new AssertThatIsNotSameAsRecipe(), new AssertThatWithFailMessageStringIsNotSameAsRecipe(), new AssertThatWithFailMessageSupplierIsNotSameAsRecipe(), new AssertThatCodeDoesNotThrowAnyExceptionRecipe(), new AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe(), new AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe()});
    }

    @NullMarked
    public static class AssertThatBooleanArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatBooleanArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, boolean[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean[] actual, boolean[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(boolean)}, #{actual:anyArray(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(boolean)}).containsExactly(#{expected:anyArray(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatBooleanArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatBooleanArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, String message, boolean[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean[] actual, String message, boolean[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(boolean)}, #{actual:anyArray(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(boolean)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatBooleanArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatBooleanArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, Supplier<String> message, boolean[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean[] actual, Supplier<String> message, boolean[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(boolean)}, #{actual:anyArray(boolean)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(boolean)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatByteArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatByteArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatByteArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(byte[] actual, byte[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(byte[] actual, byte[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(byte)}, #{actual:anyArray(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(byte)}).containsExactly(#{expected:anyArray(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatByteArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatByteArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatByteArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(byte[] actual, String message, byte[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(byte[] actual, String message, byte[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(byte)}, #{actual:anyArray(byte)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(byte)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatByteArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatByteArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatByteArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(byte[] actual, Supplier<String> message, byte[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(byte[] actual, Supplier<String> message, byte[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(byte)}, #{actual:anyArray(byte)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(byte)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCharArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCharArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(char[] actual, char[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(char[] actual, char[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(char)}, #{actual:anyArray(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(char)}).containsExactly(#{expected:anyArray(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCharArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCharArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(char[] actual, String message, char[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(char[] actual, String message, char[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(char)}, #{actual:anyArray(char)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(char)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCharArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCharArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(char[] actual, Supplier<String> message, char[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(char[] actual, Supplier<String> message, char[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(char)}, #{actual:anyArray(char)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(char)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatShortArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatShortArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatShortArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(short[] actual, short[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(short[] actual, short[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(short)}, #{actual:anyArray(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(short)}).containsExactly(#{expected:anyArray(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatShortArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatShortArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatShortArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(short[] actual, String message, short[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(short[] actual, String message, short[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(short)}, #{actual:anyArray(short)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(short)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatShortArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatShortArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatShortArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(short[] actual, Supplier<String> message, short[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(short[] actual, Supplier<String> message, short[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(short)}, #{actual:anyArray(short)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(short)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIntArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIntArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIntArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(int[] actual, int[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(int[] actual, int[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(int)}, #{actual:anyArray(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(int)}).containsExactly(#{expected:anyArray(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIntArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIntArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIntArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(int[] actual, String message, int[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(int[] actual, String message, int[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(int)}, #{actual:anyArray(int)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(int)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIntArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIntArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIntArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(int[] actual, Supplier<String> message, int[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(int[] actual, Supplier<String> message, int[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(int)}, #{actual:anyArray(int)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(int)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatLongArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatLongArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatLongArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(long[] actual, long[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(long[] actual, long[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(long)}, #{actual:anyArray(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(long)}).containsExactly(#{expected:anyArray(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatLongArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatLongArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatLongArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(long[] actual, String message, long[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(long[] actual, String message, long[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(long)}, #{actual:anyArray(long)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(long)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatLongArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatLongArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatLongArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(long[] actual, Supplier<String> message, long[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(long[] actual, Supplier<String> message, long[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(long)}, #{actual:anyArray(long)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(long)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatFloatArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, float[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(float)}, #{actual:anyArray(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(float)}).containsExactly(#{expected:anyArray(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatFloatArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, String message, float[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(float)}, #{actual:anyArray(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(float)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(float[] actual, Supplier<String> message, float[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, Supplier<String> message, float[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(float)}, #{actual:anyArray(float)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(float)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatFloatArrayContainsExactlyWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayContainsExactlyWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected, float delta) {\n        assertArrayEquals(expected, actual, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, float[] expected, float delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(float)}, #{actual:anyArray(float)}, #{delta:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(float)}).containsExactly(#{expected:anyArray(float)}, org.assertj.core.api.Assertions.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatFloatArrayWithFailMessageContainsExactlyWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected, float delta) {\n        assertArrayEquals(expected, actual, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, String message, float[] expected, float delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(float)}, #{actual:anyArray(float)}, #{delta:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(float)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(float)}, org.assertj.core.api.Assertions.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(float[] actual, Supplier<String> message, float[] expected, float delta) {\n        assertArrayEquals(expected, actual, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, Supplier<String> message, float[] expected, float delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(float)}, #{actual:anyArray(float)}, #{delta:any(float)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(float)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(float)}, org.assertj.core.api.Assertions.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoubleArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, double[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(double)}, #{actual:anyArray(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(double)}).containsExactly(#{expected:anyArray(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoubleArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, String message, double[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(double)}, #{actual:anyArray(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(double)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(double[] actual, Supplier<String> message, double[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, Supplier<String> message, double[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(double)}, #{actual:anyArray(double)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(double)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoubleArrayContainsExactlyWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayContainsExactlyWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected, double delta) {\n        assertArrayEquals(expected, actual, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, double[] expected, double delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(double)}, #{actual:anyArray(double)}, #{delta:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(double)}).containsExactly(#{expected:anyArray(double)}, org.assertj.core.api.Assertions.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected, double delta) {\n        assertArrayEquals(expected, actual, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, String message, double[] expected, double delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(double)}, #{actual:anyArray(double)}, #{delta:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(double)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(double)}, org.assertj.core.api.Assertions.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(double[] actual, Supplier<String> messageSupplier, double[] expected, double delta) {\n        assertArrayEquals(expected, actual, delta, messageSupplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, Supplier<String> messageSupplier, double[] expected, double delta) {\n        assertThat(actual).withFailMessage(messageSupplier).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(double)}, #{actual:anyArray(double)}, #{delta:any(double)}, #{messageSupplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(double)}).withFailMessage(#{messageSupplier:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(double)}, org.assertj.core.api.Assertions.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatObjectArrayContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatObjectArrayContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatObjectArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(java.lang.Object)}, #{actual:anyArray(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(java.lang.Object)}).containsExactly(#{expected:anyArray(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatObjectArrayWithFailMessageContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatObjectArrayWithFailMessageContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatObjectArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(java.lang.Object)}, #{actual:anyArray(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:anyArray(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatObjectArrayWithFailMessageSupplierContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatObjectArrayWithFailMessageSupplierContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatObjectArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    void before(Object[] actual, Supplier<String> message, Object[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Supplier<String> message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:anyArray(java.lang.Object)}, #{actual:anyArray(java.lang.Object)}, #{message:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:anyArray(java.lang.Object)}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:anyArray(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual) {\n        assertTrue(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual) {\n        assertThat(actual).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isTrue();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageStringIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message) {\n        assertTrue(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, String message) {\n        assertThat(actual).withFailMessage(message).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isTrue();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageSupplierIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual, Supplier<String> supplier) {\n        assertTrue(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isTrue();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual) {\n        assertFalse(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual) {\n        assertThat(actual).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isFalse();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageStringIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message) {\n        assertFalse(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, String message) {\n        assertThat(actual).withFailMessage(message).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isFalse();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageSupplierIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual, Supplier<String> supplier) {\n        assertFalse(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isFalse();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual) {\n        assertNull(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual) {\n        assertThat(actual).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageStringIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual, String message) {\n        assertNull(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message) {\n        assertThat(actual).withFailMessage(message).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageSupplierIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier) {\n        assertNull(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual) {\n        assertNotNull(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual) {\n        assertThat(actual).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageStringIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual, String message) {\n        assertNotNull(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message) {\n        assertThat(actual).withFailMessage(message).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageSupplierIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier) {\n        assertNotNull(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNotNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertSame(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageStringIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertSame(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageSupplierIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier, Object expected) {\n        assertSame(expected, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier, Object expected) {\n        assertThat(actual).withFailMessage(supplier).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertSame(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotSame(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageStringIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotSame(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatWithFailMessageSupplierIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier, Object expected) {\n        assertNotSame(expected, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier, Object expected) {\n        assertThat(actual).withFailMessage(supplier).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNotSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertNotSame(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCodeDoesNotThrowAnyExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeDoesNotThrowAnyException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable) {\n        assertDoesNotThrow(throwingCallable);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable) {\n        assertDoesNotThrow(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable) {\n        assertThatCode(throwingCallable).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).doesNotThrowAnyException();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.function.Executable", Boolean.valueOf(true)), new UsesType("org.junit.jupiter.api.function.ThrowingSupplier", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeWithFailMessageStringDoesNotThrowAnyException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeWithFailMessageStringDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, String message) {\n        assertDoesNotThrow(throwingCallable, message);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable, String message) {\n        assertDoesNotThrow(throwingCallable, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, String message) {\n        assertThatCode(throwingCallable).withFailMessage(message).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{message:any(java.lang.String)}).doesNotThrowAnyException();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.function.Executable", Boolean.valueOf(true)), new UsesType("org.junit.jupiter.api.function.ThrowingSupplier", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, Supplier<String> supplier) {\n        assertDoesNotThrow(throwingCallable, supplier);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable, Supplier<String> supplier) {\n        assertDoesNotThrow(throwingCallable, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Supplier<String> supplier) {\n        assertThatCode(throwingCallable).withFailMessage(supplier).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).doesNotThrowAnyException();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.function.Executable", Boolean.valueOf(true)), new UsesType("org.junit.jupiter.api.function.ThrowingSupplier", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }
}

