/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import tech.picnic.errorprone.utils.MoreMatchers;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Nullary JUnit test methods should not be parameterized", link="https://error-prone.picnic.tech/bugpatterns/JUnitNullaryParameterizedTestDeclaration", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class JUnitNullaryParameterizedTestDeclaration
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final MultiMatcher<MethodTree, AnnotationTree> IS_PARAMETERIZED_TEST = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"org.junit.jupiter.params.ParameterizedTest"));
    private static final Matcher<AnnotationTree> IS_ARGUMENT_SOURCE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.jupiter.params.provider.ArgumentsSource"), Matchers.isType((String)"org.junit.jupiter.params.provider.ArgumentsSources"), MoreMatchers.hasMetaAnnotation((String)"org.junit.jupiter.params.provider.ArgumentsSource")});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!tree.getParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        MultiMatcher.MultiMatchResult isParameterizedTest = IS_PARAMETERIZED_TEST.multiMatchResult((Tree)tree, state);
        if (!isParameterizedTest.matches()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.merge(SuggestedFix.replace((Tree)isParameterizedTest.onlyMatchingNode(), (String)("@" + SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"org.junit.jupiter.api.Test"))));
        tree.getModifiers().getAnnotations().stream().filter(a -> IS_ARGUMENT_SOURCE.matches((Tree)a, state)).forEach(a -> fix.merge(SourceCode.deleteWithTrailingWhitespace((Tree)a, (VisitorState)state)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

