/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJComparableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJComparableRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJComparableRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJComparableRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatIsEqualByComparingToRecipe(), new AssertThatIsNotEqualByComparingToRecipe(), new AssertThatIsLessThanRecipe(), new AssertThatIsLessThanOrEqualToRecipe(), new AssertThatIsGreaterThanRecipe(), new AssertThatIsGreaterThanOrEqualToRecipe()});
    }

    @NullMarked
    public static class AssertThatIsEqualByComparingToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJComparableRules.AssertThatIsEqualByComparingTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsEqualByComparingTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isEqualTo(0);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isEqualByComparingTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isEqualTo(0)").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isEqualByComparingTo(#{expected:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Comparable compareTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNotEqualByComparingToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJComparableRules.AssertThatIsNotEqualByComparingTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotEqualByComparingTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNotEqualTo(0);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isNotEqualByComparingTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNotEqualTo(0)").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isNotEqualByComparingTo(#{expected:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Comparable compareTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNotEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsLessThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJComparableRules.AssertThatIsLessThan`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThan<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNegative();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isLessThan(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNegative()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isLessThan(#{expected:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Comparable compareTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNegative(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsLessThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJComparableRules.AssertThatIsLessThanOrEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThanOrEqualTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNotPositive();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isLessThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNotPositive()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isLessThanOrEqualTo(#{expected:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Comparable compareTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNotPositive(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsGreaterThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJComparableRules.AssertThatIsGreaterThan`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThan<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isPositive();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isGreaterThan(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isPositive()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isGreaterThan(#{expected:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Comparable compareTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isPositive(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsGreaterThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJComparableRules.AssertThatIsGreaterThanOrEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThanOrEqualTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNotNegative();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isGreaterThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNotNegative()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isGreaterThanOrEqualTo(#{expected:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Comparable compareTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNotNegative(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

