/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class StreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`StreamRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `Stream`s.\n[Source](https://error-prone.picnic.tech/refasterrules/StreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new JoiningRecipe(), new EmptyStreamRecipe(), new StreamOfNullableRecipe(), new ConcatOneStreamRecipe(), new ConcatTwoStreamsRecipe(), new StreamFilterSortedRecipe(), new StreamFilterSortedWithComparatorRecipe(), new StreamMapFirstRecipe(), new StreamFindAnyIsEmptyRecipe(), new StreamFindAnyIsPresentRecipe(), new StreamMapFilterRecipe(), new StreamMinRecipe(), new StreamMinNaturalOrderRecipe(), new StreamMaxRecipe(), new StreamMaxNaturalOrderRecipe(), new StreamMapToIntSummaryStatisticsRecipe(), new StreamMapToDoubleSummaryStatisticsRecipe(), new StreamMapToLongSummaryStatisticsRecipe(), new StreamCountRecipe(), new StreamReduceRecipe(), new StreamReduceWithIdentityRecipe(), new StreamFilterCollectRecipe(), new StreamMapCollectRecipe(), new StreamFlatMapCollectRecipe(), new StreamTakeWhileRecipe(), new StreamIterateRecipe(), new StreamOf1Recipe(), new StreamOf2Recipe(), new StreamOf3Recipe(), new StreamOf4Recipe(), new StreamOf5Recipe()});
    }

    @NullMarked
    public static class JoiningRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.Joining`";
        }

        public String getDescription() {
            return "Prefer `Collectors#joining()` over `Collectors#joining(CharSequence)` with an empty delimiter string.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.stream.Collectors.joining(\"\")").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Collectors.joining()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors joining(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmptyStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.EmptyStream`";
        }

        public String getDescription() {
            return "Prefer `Stream#empty()` over less clear alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.stream.Stream.of()").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.empty()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamOfNullableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamOfNullable`";
        }

        public String getDescription() {
            return "Prefer `Stream#ofNullable(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{object:any(T)}).filter(java.util.Objects::nonNull)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{object:any(T)}).stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.ofNullable(#{object:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Objects", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional ofNullable(..)", true), new UsesMethod("java.util.Optional stream(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatOneStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.ConcatOneStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily call `Streams#concat(Stream...)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.Stream<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatTwoStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.ConcatTwoStreams`";
        }

        public String getDescription() {
            return "Prefer `Stream#concat(Stream, Stream)` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.Stream<T>)}, #{s2:any(java.util.stream.Stream<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.concat(#{s1:any(java.util.stream.Stream<T>)}, #{s2:any(java.util.stream.Stream<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamFilterSorted`";
        }

        public String getDescription() {
            return "Apply `Stream#filter(Predicate)` before `Stream#sorted()` to reduce the number of elements to sort.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.sorted().filter(#{predicate:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sorted()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("java.util.stream.Stream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFilterSortedWithComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamFilterSortedWithComparator`";
        }

        public String getDescription() {
            return "Apply `Stream#filter(Predicate)` before `Stream#sorted(Comparator)` to reduce the number of elements to sort.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.sorted(#{comparator:any(java.util.Comparator<? super T>)}).filter(#{predicate:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sorted(#{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("java.util.stream.Stream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMapFirstRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMapFirst`";
        }

        public String getDescription() {
            return "Where possible, clarify that a mapping operation will be applied only to a single stream element.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.map(#{function:any(java.util.function.Function<? super T, S>)}).findFirst()").genericTypes(new String[]{"T", "S"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.findFirst().map(#{function:any(java.util.function.Function<? super T, S>)})").genericTypes(new String[]{"T", "S"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream findFirst(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFindAnyIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamFindAnyIsEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.count() == 0").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.count() <= 0").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.count() < 1").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.findFirst().isEmpty()").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$4 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends C>)}).isEmpty()").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$5 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.collectingAndThen(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends C>)}, C::isEmpty))").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.collectingAndThen(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends M>)}, M::isEmpty))").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()").genericTypes(new String[]{"T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>"}).build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.stream.Collectors.collectingAndThen");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.stream.Collectors.collectingAndThen");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.stream.Collectors.collectingAndThen");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collection isEmpty(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional isEmpty(..)", true), new UsesMethod("java.util.stream.Stream findFirst(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Collectors collectingAndThen(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFindAnyIsPresentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamFindAnyIsPresent`";
        }

        public String getDescription() {
            return "Prefer `Stream#findAny()` over `Stream#findFirst()` if one only cares whether the stream is nonempty.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.findFirst().isPresent()").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.findAny().isPresent()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.Optional isPresent(..)", true), new UsesMethod("java.util.stream.Stream findFirst(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMapFilterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMapFilter`";
        }

        public String getDescription() {
            return "Prefer an unconditional `Map#get(Object)` call followed by a `null` check over a call to `Map#containsKey(Object)`, as the former avoids a second lookup operation.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.filter(#{map:any(java.util.Map<K, V>)}::containsKey).map(#{map}::get)").genericTypes(new String[]{"T", "K", "V"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.map(#{map:any(java.util.Map<K, V>)}::get).filter(java.util.Objects::nonNull)").genericTypes(new String[]{"T", "K", "V"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMin<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {\n        return Refaster.anyOf(stream.max(comparator.reversed()), stream.sorted(comparator).findFirst(), stream.collect(minBy(comparator)));\n    }\n    \n    @AfterTemplate\n    Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {\n        return stream.min(comparator);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.max(#{comparator:any(java.util.Comparator<? super T>)}.reversed())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.sorted(#{comparator:any(java.util.Comparator<? super T>)}).findFirst()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.minBy(#{comparator:any(java.util.Comparator<? super T>)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.min(#{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.minBy");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator reversed(..)", true), new UsesMethod("java.util.stream.Stream max(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Collectors minBy(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream findFirst(..)", true), new UsesMethod("java.util.stream.Stream sorted(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMinNaturalOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMinNaturalOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMinNaturalOrder<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    Optional<T> before(Stream<T> stream) {\n        return Refaster.anyOf(stream.max(reverseOrder()), stream.sorted().findFirst());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Optional<T> after(Stream<T> stream) {\n        return stream.min(naturalOrder());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.max(java.util.Comparator.reverseOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.sorted().findFirst()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.min(java.util.Comparator.naturalOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator reverseOrder(..)", true), new UsesMethod("java.util.stream.Stream max(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream findFirst(..)", true), new UsesMethod("java.util.stream.Stream sorted(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMaxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMax`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMax<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {\n        return Refaster.anyOf(stream.min(comparator.reversed()), Streams.findLast(stream.sorted(comparator)), stream.collect(maxBy(comparator)));\n    }\n    \n    @AfterTemplate\n    Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {\n        return stream.max(comparator);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.min(#{comparator:any(java.util.Comparator<? super T>)}.reversed())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.findLast(#{stream:any(java.util.stream.Stream<T>)}.sorted(#{comparator:any(java.util.Comparator<? super T>)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.maxBy(#{comparator:any(java.util.Comparator<? super T>)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.max(#{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.maxBy");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator reversed(..)", true), new UsesMethod("java.util.stream.Stream min(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Collectors maxBy(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams findLast(..)", true), new UsesMethod("java.util.stream.Stream sorted(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMaxNaturalOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMaxNaturalOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMaxNaturalOrder<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    Optional<T> before(Stream<T> stream) {\n        return Refaster.anyOf(stream.min(reverseOrder()), Streams.findLast(stream.sorted()));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Optional<T> after(Stream<T> stream) {\n        return stream.max(naturalOrder());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.min(java.util.Comparator.reverseOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.findLast(#{stream:any(java.util.stream.Stream<T>)}.sorted())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.max(java.util.Comparator.naturalOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator reverseOrder(..)", true), new UsesMethod("java.util.stream.Stream min(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams findLast(..)", true), new UsesMethod("java.util.stream.Stream sorted(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMapToIntSummaryStatisticsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMapToIntSummaryStatistics`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapToIntSummaryStatistics<T> {\n    \n    @BeforeTemplate\n    IntSummaryStatistics before(Stream<T> stream, ToIntFunction<T> mapper) {\n        return stream.collect(summarizingInt(mapper));\n    }\n    \n    @AfterTemplate\n    IntSummaryStatistics after(Stream<T> stream, ToIntFunction<T> mapper) {\n        return stream.mapToInt(mapper).summaryStatistics();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.summarizingInt(#{mapper:any(java.util.function.ToIntFunction<T>)}))").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.mapToInt(#{mapper:any(java.util.function.ToIntFunction<T>)}).summaryStatistics()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.summarizingInt");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.IntSummaryStatistics", Boolean.valueOf(true)), new UsesType("java.util.function.ToIntFunction", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors summarizingInt(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMapToDoubleSummaryStatisticsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMapToDoubleSummaryStatistics`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapToDoubleSummaryStatistics<T> {\n    \n    @BeforeTemplate\n    DoubleSummaryStatistics before(Stream<T> stream, ToDoubleFunction<T> mapper) {\n        return stream.collect(summarizingDouble(mapper));\n    }\n    \n    @AfterTemplate\n    DoubleSummaryStatistics after(Stream<T> stream, ToDoubleFunction<T> mapper) {\n        return stream.mapToDouble(mapper).summaryStatistics();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.summarizingDouble(#{mapper:any(java.util.function.ToDoubleFunction<T>)}))").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.mapToDouble(#{mapper:any(java.util.function.ToDoubleFunction<T>)}).summaryStatistics()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.summarizingDouble");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.DoubleSummaryStatistics", Boolean.valueOf(true)), new UsesType("java.util.function.ToDoubleFunction", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors summarizingDouble(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMapToLongSummaryStatisticsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMapToLongSummaryStatistics`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapToLongSummaryStatistics<T> {\n    \n    @BeforeTemplate\n    LongSummaryStatistics before(Stream<T> stream, ToLongFunction<T> mapper) {\n        return stream.collect(summarizingLong(mapper));\n    }\n    \n    @AfterTemplate\n    LongSummaryStatistics after(Stream<T> stream, ToLongFunction<T> mapper) {\n        return stream.mapToLong(mapper).summaryStatistics();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.summarizingLong(#{mapper:any(java.util.function.ToLongFunction<T>)}))").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.mapToLong(#{mapper:any(java.util.function.ToLongFunction<T>)}).summaryStatistics()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.summarizingLong");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.LongSummaryStatistics", Boolean.valueOf(true)), new UsesType("java.util.function.ToLongFunction", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors summarizingLong(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamCountRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamCount`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamCount<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    long before(Stream<T> stream) {\n        return stream.collect(counting());\n    }\n    \n    @AfterTemplate\n    long after(Stream<T> stream) {\n        return stream.count();\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.counting())").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.count()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.counting");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors counting(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamReduceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamReduce`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamReduce<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    Optional<T> before(Stream<T> stream, BinaryOperator<T> accumulator) {\n        return stream.collect(reducing(accumulator));\n    }\n    \n    @AfterTemplate\n    Optional<T> after(Stream<T> stream, BinaryOperator<T> accumulator) {\n        return stream.reduce(accumulator);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.reducing(#{accumulator:any(java.util.function.BinaryOperator<T>)}))").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.reduce(#{accumulator:any(java.util.function.BinaryOperator<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.reducing");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.BinaryOperator", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors reducing(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamReduceWithIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamReduceWithIdentity`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamReduceWithIdentity<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    T before(Stream<T> stream, T identity, BinaryOperator<T> accumulator) {\n        return stream.collect(reducing(identity, accumulator));\n    }\n    \n    @AfterTemplate\n    T after(Stream<T> stream, T identity, BinaryOperator<T> accumulator) {\n        return stream.reduce(identity, accumulator);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.reducing(#{identity:any(T)}, #{accumulator:any(java.util.function.BinaryOperator<T>)}))").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.reduce(#{identity:any(T)}, #{accumulator:any(java.util.function.BinaryOperator<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.reducing");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BinaryOperator", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors reducing(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFilterCollectRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamFilterCollect`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamFilterCollect<T, R> {\n    \n    @BeforeTemplate\n    R before(Stream<T> stream, Predicate<? super T> predicate, Collector<? super T, ?, R> collector) {\n        return stream.collect(filtering(predicate, collector));\n    }\n    \n    @AfterTemplate\n    R after(Stream<T> stream, Predicate<? super T> predicate, Collector<? super T, ?, R> collector) {\n        return stream.filter(predicate).collect(collector);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.filtering(#{predicate:any(java.util.function.Predicate<? super T>)}, #{collector:any(java.util.stream.Collector<? super T, ?, R>)}))").genericTypes(new String[]{"T", "R"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).collect(#{collector:any(java.util.stream.Collector<? super T, ?, R>)})").genericTypes(new String[]{"T", "R"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.filtering");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors filtering(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamMapCollectRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamMapCollect`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapCollect<T, U, R> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    R before(Stream<T> stream, Function<? super T, ? extends U> mapper, Collector<? super U, ?, R> collector) {\n        return stream.collect(mapping(mapper, collector));\n    }\n    \n    @AfterTemplate\n    R after(Stream<T> stream, Function<? super T, ? extends U> mapper, Collector<? super U, ?, R> collector) {\n        return stream.map(mapper).collect(collector);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.mapping(#{mapper:any(java.util.function.Function<? super T, ? extends U>)}, #{collector:any(java.util.stream.Collector<? super U, ?, R>)}))").genericTypes(new String[]{"T", "U", "R"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.map(#{mapper:any(java.util.function.Function<? super T, ? extends U>)}).collect(#{collector:any(java.util.stream.Collector<? super U, ?, R>)})").genericTypes(new String[]{"T", "U", "R"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.mapping");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors mapping(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFlatMapCollectRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamFlatMapCollect`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamFlatMapCollect<T, U, R> {\n    \n    @BeforeTemplate\n    R before(Stream<T> stream, Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, ?, R> collector) {\n        return stream.collect(flatMapping(mapper, collector));\n    }\n    \n    @AfterTemplate\n    R after(Stream<T> stream, Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, ?, R> collector) {\n        return stream.flatMap(mapper).collect(collector);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.flatMapping(#{mapper:any(java.util.function.Function<? super T, ? extends java.util.stream.Stream<? extends U>>)}, #{collector:any(java.util.stream.Collector<? super U, ?, R>)}))").genericTypes(new String[]{"T", "U", "R"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.flatMap(#{mapper:any(java.util.function.Function<? super T, ? extends java.util.stream.Stream<? extends U>>)}).collect(#{collector:any(java.util.stream.Collector<? super U, ?, R>)})").genericTypes(new String[]{"T", "U", "R"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.flatMapping");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Collectors flatMapping(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamTakeWhile<T> {\n    \n    @BeforeTemplate\n    Stream<T> before(Stream<T> stream, Predicate<? super T> predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    Stream<T> after(Stream<T> stream, Predicate<? super T> predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)}).filter(#{predicate})").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("java.util.stream.Stream takeWhile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamIterateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamIterate`";
        }

        public String getDescription() {
            return "Prefer `Stream#iterate(Object, Predicate, UnaryOperator)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.stream.Stream.iterate(#{seed:any(T)}, #{next:any(java.util.function.UnaryOperator<T>)}).takeWhile(#{hasNext:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.iterate(#{seed:any(T)}, #{hasNext:any(java.util.function.Predicate<? super T>)}, #{next:any(java.util.function.UnaryOperator<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.function.UnaryOperator", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream iterate(..)", true), new UsesMethod("java.util.stream.Stream takeWhile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamOf1Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamOf1`";
        }

        public String getDescription() {
            return "Prefer `Stream#of(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{e1:any(T)}).stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{e1:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamOf2Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamOf2`";
        }

        public String getDescription() {
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}).stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamOf3Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamOf3`";
        }

        public String getDescription() {
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}).stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamOf4Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamOf4`";
        }

        public String getDescription() {
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}).stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamOf5Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StreamRules.StreamOf5`";
        }

        public String getDescription() {
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)}).stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

