/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJByteRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJByteRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJByteRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJByteRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractByteAssertIsEqualToRecipe(), new AbstractByteAssertIsNotEqualToRecipe(), new AbstractByteAssertIsZeroRecipe(), new AbstractByteAssertIsNotZeroRecipe(), new AbstractByteAssertIsOneRecipe()});
    }

    @NullMarked
    public static class AbstractByteAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert, byte n) {\n        return Refaster.anyOf(byteAssert.isCloseTo(n, offset((byte)0)), byteAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert, byte n) {\n        return byteAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isCloseTo(#{n:any(byte)}, org.assertj.core.data.Offset.offset((byte)0))").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo(#{n:any(byte)})").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isCloseTo(#{n:any(byte)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo(#{n:any(byte)})").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractByteAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert, byte n) {\n        return Refaster.anyOf(byteAssert.isNotCloseTo(n, offset((byte)0)), byteAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert, byte n) {\n        return byteAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotCloseTo(#{n:any(byte)}, org.assertj.core.data.Offset.offset((byte)0))").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotEqualTo(#{n:any(byte)})").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotCloseTo(#{n:any(byte)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotEqualTo(#{n:any(byte)})").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isNotCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractByteAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isEqualTo((byte)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo((byte)0)").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isZero(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractByteAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isNotEqualTo((byte)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotEqualTo((byte)0)").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isNotZero(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractByteAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isEqualTo((byte)1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo((byte)1)").bindType("org.assertj.core.api.AbstractByteAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isOne(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

