/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.ThrottleItem;
import Acme.Serve.ThrottledOutputStream;
import Acme.Utils;
import Acme.WildcardDictionary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileServlet
extends HttpServlet {
    static WildcardDictionary throttleTab = null;
    static final String[] DEFAULTINDEXPAGES = new String[]{"index.html", "index.htm", "default.htm", "default.html"};
    static final DecimalFormat lengthftm = new DecimalFormat("#");
    static final String BYTES_UNIT = "bytes";
    protected String charSet = "UTF-8";
    private static final boolean logenabled = false;
    private Method canExecute;
    private Method getFreeSpace;
    private boolean useCompression;

    public FileServlet() {
        try {
            this.canExecute = File.class.getMethod("canExecute", Utils.EMPTY_CLASSES);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.getFreeSpace = File.class.getMethod("getFreeSpace", Utils.EMPTY_CLASSES);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.useCompression = System.getProperty("tjws.fileservlet.usecompression") != null;
    }

    public FileServlet(String string, String string2) throws IOException {
        this();
        if (string2 != null) {
            this.charSet = string2;
        }
        this.readThrottles(string);
    }

    private void readThrottles(String string) throws IOException {
        WildcardDictionary wildcardDictionary = ThrottledOutputStream.parseThrottleFile(string);
        if (throttleTab == null) {
            throttleTab = wildcardDictionary;
        } else {
            Enumeration enumeration = wildcardDictionary.keys();
            Enumeration enumeration2 = wildcardDictionary.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Object e2 = enumeration2.nextElement();
                throttleTab.put(e, e2);
            }
        }
    }

    public String getServletInfo() {
        return "File servlet similar to httpd";
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        if (httpServletRequest.getMethod().equalsIgnoreCase("get")) {
            bl = false;
        } else if (httpServletRequest.getMethod().equalsIgnoreCase("head")) {
            bl = true;
        } else {
            httpServletResponse.sendError(501);
            return;
        }
        httpServletRequest.setCharacterEncoding("UTF-8");
        String string = Utils.canonicalizePath(httpServletRequest.getPathInfo());
        this.dispatchPathname(httpServletRequest, httpServletResponse, bl, string);
    }

    private void dispatchPathname(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string) throws IOException {
        String string2 = httpServletRequest.getPathTranslated() != null ? httpServletRequest.getPathTranslated().replace('/', File.separatorChar) : "";
        File file = new File(string2);
        this.log("showing '" + string2 + "' for path " + string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.serveFile(httpServletRequest, httpServletResponse, bl, string, file);
            } else {
                this.log("showing dir " + file);
                if (!this.redirectDirectory(httpServletRequest, httpServletResponse, string, file)) {
                    this.showIdexFile(httpServletRequest, httpServletResponse, bl, string, string2);
                }
            }
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private void showIdexFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, String string2) throws IOException {
        this.log("showing index in directory " + string2);
        for (int i = 0; i < DEFAULTINDEXPAGES.length; ++i) {
            File file = new File(string2, DEFAULTINDEXPAGES[i]);
            if (!file.exists()) continue;
            this.serveFile(httpServletRequest, httpServletResponse, bl, string, file);
            return;
        }
        this.serveDirectory(httpServletRequest, httpServletResponse, bl, string, new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, File file) throws IOException {
        block34: {
            String string2;
            this.log("getting " + file);
            if (!file.canRead()) {
                httpServletResponse.sendError(403);
                return;
            }
            try {
                file.getCanonicalPath();
            }
            catch (Exception exception) {
                httpServletResponse.sendError(403, "Forbidden, exception:" + exception);
                return;
            }
            httpServletResponse.setStatus(200);
            long l = file.lastModified();
            long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
            if (l2 != -1L && l2 >= l) {
                httpServletResponse.setStatus(304);
                bl = true;
            }
            if ((string2 = this.getServletContext().getMimeType(file.getName())) != null) {
                httpServletResponse.setContentType(string2);
            }
            long l3 = file.length();
            String string3 = httpServletRequest.getHeader("Range");
            long l4 = 0L;
            long l5 = -1L;
            if (string3 != null) {
                int n;
                this.log("Range:" + string3);
                if (string3.regionMatches(true, 0, BYTES_UNIT, 0, BYTES_UNIT.length()) && (n = string3.indexOf(45)) > 0) {
                    try {
                        l4 = Long.parseLong(string3.substring(BYTES_UNIT.length() + 1, n));
                        if (l4 < 0L) {
                            throw new NumberFormatException("Invalid start range value:" + l4);
                        }
                        try {
                            l5 = Long.parseLong(string3.substring(n + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            l5 = l3 - 1L;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.log("range values " + l4 + " to " + l5);
            }
            long l6 = l5 < 0L ? l3 : l5 - l4 + 1L;
            httpServletResponse.setDateHeader("Last-modified", l);
            if (l5 > 0L) {
                if (l4 > l5 || l5 >= l3) {
                    httpServletResponse.setHeader("Content-Range", "bytes */" + l3);
                    httpServletResponse.setStatus(416);
                    return;
                }
                httpServletResponse.setStatus(206);
                httpServletResponse.setHeader("Content-Range", "bytes " + l4 + '-' + l5 + '/' + l3);
                this.log("content-range:bytes " + l4 + '-' + l5 + '/' + l3);
            }
            boolean bl2 = false;
            if (this.useCompression && string2 != null && string2.startsWith("text") && (string2 = httpServletRequest.getHeader("Accept-Encoding")) != null && string2.indexOf("gzip") >= 0) {
                httpServletResponse.setHeader("Content-Encoding", "gzip");
                bl2 = true;
            }
            if (!bl2 || bl) {
                if (l6 < Integer.MAX_VALUE) {
                    httpServletResponse.setContentLength((int)l6);
                } else {
                    httpServletResponse.setHeader("Content-Length", Long.toString(l6));
                }
            }
            FilterOutputStream filterOutputStream = null;
            InputStream inputStream = null;
            try {
                ThrottleItem throttleItem;
                if (bl) break block34;
                FilterOutputStream filterOutputStream2 = filterOutputStream = bl2 ? new GZIPOutputStream((OutputStream)httpServletResponse.getOutputStream()) : httpServletResponse.getOutputStream();
                if (throttleTab != null && (throttleItem = (ThrottleItem)throttleTab.get(string)) != null) {
                    filterOutputStream = new ThrottledOutputStream(filterOutputStream, throttleItem.getMaxBps());
                }
                inputStream = new FileInputStream(file);
                while (l4 > 0L) {
                    long l7 = inputStream.skip(l4);
                    if (l7 > 0L) {
                        l4 -= l7;
                        continue;
                    }
                    httpServletResponse.sendError(409, "Conflict");
                    return;
                }
                this.copyStream(inputStream, filterOutputStream, l6);
                if (bl2) {
                    ((GZIPOutputStream)filterOutputStream).finish();
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (filterOutputStream != null) {
                    ((OutputStream)filterOutputStream).flush();
                    ((OutputStream)filterOutputStream).close();
                }
            }
        }
    }

    public void copyStream(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        Utils.copyStream(inputStream, outputStream, l);
    }

    private void serveDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, File file) throws IOException {
        this.log("indexing " + file);
        if (!file.canRead()) {
            httpServletResponse.sendError(403);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html;charset=" + this.charSet);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (!bl) {
            Object[] objectArray = file.list();
            if (objectArray == null) {
                httpServletResponse.sendError(403, "Can't access " + httpServletRequest.getRequestURI());
                return;
            }
            PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream((OutputStream)servletOutputStream), false, this.charSet);
            printStream.println("<HTML><HEAD>");
            printStream.println("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=" + this.charSet + "\">");
            printStream.println("<TITLE>Index of " + string + "</TITLE>");
            printStream.println("</HEAD><BODY BGCOLOR=\"#D1E9FE\"");
            printStream.println("><H2>Index of " + string + "</H2>");
            printStream.println("<PRE>");
            printStream.println("mode         bytes  last-changed    name");
            printStream.println("<HR>");
            Arrays.sort(objectArray);
            long l = 0L;
            for (int i = 0; i < objectArray.length; ++i) {
                File file2 = new File(file, (String)objectArray[i]);
                String string2 = file2.isDirectory() ? "d" : (file2.isFile() ? "-" : "?");
                String string3 = file2.canRead() ? "r" : "-";
                String string4 = file2.canWrite() ? "w" : "-";
                String string5 = "-";
                if (this.canExecute != null) {
                    try {
                        if (((Boolean)this.canExecute.invoke((Object)file2, Utils.EMPTY_OBJECTS)).booleanValue()) {
                            string5 = "x";
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                long l2 = file2.length();
                String string6 = lengthftm.format(l2);
                l += (l2 + 1023L) / 1024L;
                while (string6.length() < 12) {
                    string6 = " " + string6;
                }
                String string7 = Utils.lsDateStr(new Date(file2.lastModified()));
                while (string7.length() < 14) {
                    string7 = string7 + " ";
                }
                String string8 = file2.isDirectory() ? "/" : "";
                String string9 = file2.isDirectory() ? "/" : "";
                printStream.println(string2 + string3 + string4 + string5 + "  " + string6 + "  " + string7 + "  " + "<A HREF=\"" + URLEncoder.encode((String)objectArray[i], this.charSet) + string8 + "\">" + (String)objectArray[i] + string9 + "</A>");
            }
            if (l != 0L) {
                l += 3L;
            }
            printStream.println("total " + l);
            printStream.println("</PRE>");
            printStream.println("<HR>");
            printStream.print("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">Rogatkin's JWS based on Acme.Serve Version 1.33, $Revision: 1.163 $</A></ADDRESS>");
            printStream.println("</BODY></HTML>");
            printStream.flush();
        }
        servletOutputStream.close();
    }

    private boolean redirectDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, File file) throws IOException {
        int n = string.length();
        if (n > 0 && string.charAt(n - 1) != '/') {
            int n2 = string.lastIndexOf(47);
            string = n2 < 0 ? string + '/' : string.substring(n2 + 1) + '/';
            this.log("redirecting dir " + string);
            httpServletResponse.sendRedirect(string);
            return true;
        }
        return false;
    }

    public void log(String string) {
    }
}

