/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableType;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.string.StringFormat;

final class TableRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableRetriever.class.getName());

    TableRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTables(NamedObjectList<SchemaReference> schemas, String tableNamePattern, TableTypes tableTypes, InclusionRule tableInclusionRule) throws SQLException {
        Objects.requireNonNull(schemas, "No schemas provided");
        Objects.requireNonNull(tableTypes, "No table types provided");
        InclusionRuleFilter<Table> tableFilter = new InclusionRuleFilter<Table>(tableInclusionRule, false);
        if (tableFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tablesRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving tables, using fast data dictionary retrieval");
                this.retrieveTablesFromDataDictionary(schemas, tableNamePattern, tableTypes, tableFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving tables");
                this.retrieveTablesFromMetadata(schemas, tableNamePattern, tableTypes, tableFilter);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving tables");
            }
        }
    }

    private void createTable(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Table> tableFilter, TableTypes filteredTableTypes) {
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
        String tableName = results.getString("TABLE_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving table <%s.%s.%s>", catalogName, schemaName, tableName));
        String tableTypeString = results.getString("TABLE_TYPE");
        String remarks = results.getString("REMARKS");
        Optional<SchemaReference> optionalSchema = schemas.lookup(new NamedObjectKey(catalogName, schemaName));
        if (!optionalSchema.isPresent()) {
            return;
        }
        Schema schema = optionalSchema.get();
        TableType tableType = filteredTableTypes.lookupTableType(tableTypeString).orElse(TableType.UNKNOWN);
        if (tableType.equals(TableType.UNKNOWN)) {
            LOGGER.log(Level.FINE, new StringFormat("Not including table <%s.%s>, since table type <%s> was not requested", schema, tableName, tableTypeString));
            return;
        }
        MutableTable table = tableType.isView() ? new MutableView(schema, tableName) : new MutableTable(schema, tableName);
        if (tableFilter.test(table)) {
            table.setTableType(tableType);
            table.setRemarks(remarks);
            this.catalog.addTable(table);
        }
    }

    private void retrieveTablesFromDataDictionary(NamedObjectList<SchemaReference> schemas, String tableNamePattern, TableTypes tableTypes, InclusionRuleFilter<Table> tableFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLES)) {
            throw new SchemaCrawlerSQLException("No tables SQL provided", null);
        }
        Query tablesSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLES);
        Connection connection = this.getDatabaseConnection();
        TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
        TableTypes filteredTableTypes = tableTypes.isIncludeAll() ? supportedTableTypes : tableTypes;
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tablesSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveTablesFromDataDictionary");
            int numTables = 0;
            while (results.next()) {
                ++numTables;
                this.createTable(results, schemas, tableFilter, filteredTableTypes);
            }
            LOGGER.log(Level.INFO, new StringFormat("Processed %d tables", numTables));
        }
    }

    private void retrieveTablesFromMetadata(NamedObjectList<SchemaReference> schemas, String tableNamePattern, TableTypes tableTypes, InclusionRuleFilter<Table> tableFilter) throws SQLException {
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, new StringFormat("Retrieving tables for schema <%s>", schema));
            TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
            TableTypes filteredTableTypes = supportedTableTypes.subsetFrom(tableTypes);
            LOGGER.log(Level.FINER, new StringFormat("Retrieving table types <%s>", filteredTableTypes));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTables(catalogName, schemaName, tableNamePattern, filteredTableTypes.toArray()));
            Throwable throwable = null;
            try {
                results.setDescription("retrieveTablesFromMetadata");
                int numTables = 0;
                while (results.next()) {
                    ++numTables;
                    this.createTable(results, schemas, tableFilter, supportedTableTypes);
                }
                LOGGER.log(Level.INFO, new StringFormat("Processed %d tables", numTables));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (results == null) continue;
                if (throwable != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                results.close();
            }
        }
    }
}

