/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema;

import schemacrawler.tools.command.text.schema.SchemaTextRenderer;
import schemacrawler.tools.command.text.schema.options.CommandProviderUtility;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptionsBuilder;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;

public final class SchemaTextCommandProvider
extends BaseCommandProvider {
    private static final String DESCRIPTION_HEADER = "Generate text output to show details of a schema";

    public SchemaTextCommandProvider() {
        super(CommandProviderUtility.schemaTextCommands());
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand("schema", "** Generate text output to show details of a schema", () -> new String[]{"Applies to all commands that show schema information"}, () -> new String[0]);
        pluginCommand.addOption("no-info", Boolean.class, "Hide or show database information", "--no-info=<boolean>", "<boolean> can be true or false", "Optional, defaults to false").addOption("no-remarks", Boolean.class, "Hide or show table and column remarks", "--no-remarks=<boolean>", "<boolean> can be true or false", "Optional, defaults to false").addOption("portable-names", Boolean.class, "Allow for easy comparison between databases, by hiding or showing foreign key names, constraint names, trigger names, specific names for routines, or index and primary key names, and fully-qualified table names", "--portable-names=<boolean>", "<boolean> can be true or false", "Optional, defaults to false").addOption("sort-columns", Boolean.class, "Sort columns in a table alphabetically", "--sort-columns=<sortcolumns>", "<sortcolumns> can be true or false", "Optional, defaults to false").addOption("sort-tables", Boolean.class, "Sort tables alphabetically", "--sort-tables=<sorttables>", "<sorttables> can be true or false", "Optional, defaults to true").addOption("sort-routines", Boolean.class, "Sort routines alphabetically", "--sort-routines=<sortroutines>", "<sortroutines> can be true or false", "Optional, defaults to true");
        return pluginCommand;
    }

    @Override
    public SchemaTextRenderer newSchemaCrawlerCommand(String command, Config config) {
        SchemaTextOptions schemaTextOptions = ((SchemaTextOptionsBuilder)SchemaTextOptionsBuilder.builder().fromConfig(config)).toOptions();
        SchemaTextRenderer scCommand = new SchemaTextRenderer(command);
        scCommand.setCommandOptions(schemaTextOptions);
        return scCommand;
    }

    @Override
    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return this.supportsOutputFormat(command, outputOptions, TextOutputFormat::isSupportedFormat);
    }
}

