/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public final class Utility {
    public static String commonPrefix(String string1, String string2) {
        if (string1 == null || string2 == null) {
            return "";
        }
        int index = Utility.indexOfDifference(string1, string2);
        if (index == -1) {
            return null;
        }
        return string1.substring(0, index).toLowerCase();
    }

    public static String convertForComparison(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_' && ch != '.') continue;
            builder.append(Character.toLowerCase(ch));
        }
        String textWithoutQuotes = builder.toString();
        return textWithoutQuotes;
    }

    public static boolean hasNoUpperCase(String text) {
        return text != null && text.equals(text.toLowerCase());
    }

    public static boolean isBlank(CharSequence text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className, false, Utility.class.getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isIntegral(CharSequence text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch) || ch == '+' || ch == '-') continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<String> collection, String separator) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(separator);
        joiner.setEmptyValue("");
        for (String string : collection) {
            joiner.add(string);
        }
        return joiner.toString();
    }

    public static String join(Map<?, ?> map, String separator) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(separator);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            joiner.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return joiner.toString();
    }

    public static String requireNotBlank(String text, String message) {
        if (Utility.isBlank(text)) {
            throw new IllegalArgumentException(message);
        }
        return text;
    }

    public static String toSnakeCase(String identifier) {
        if (Utility.isBlank(identifier)) {
            return identifier;
        }
        Pattern identifyCamelCase = Pattern.compile("([A-Z])");
        String snakeCaseIdentifier = identifyCamelCase.matcher(identifier).replaceAll("_$1").toLowerCase();
        return snakeCaseIdentifier;
    }

    private static int indexOfDifference(String string1, String string2) {
        int i;
        if (string1 == null || string2 == null) {
            return 0;
        }
        for (i = 0; i < string1.length() && i < string2.length() && string1.charAt(i) == string2.charAt(i); ++i) {
        }
        if (i < string2.length() || i < string1.length()) {
            return i;
        }
        return -1;
    }

    private Utility() {
    }
}

