/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import wf.bitcoin.krotjson.HexCoder;

class MapWrapper {
    public final Map m;

    public MapWrapper(Map m) {
        this.m = m;
    }

    public Boolean mapBool(String key) {
        return MapWrapper.mapBool(this.m, key);
    }

    public Integer mapInt(String key) {
        return MapWrapper.mapInt(this.m, key);
    }

    public Long mapLong(String key) {
        return MapWrapper.mapLong(this.m, key);
    }

    public String mapStr(String key) {
        return MapWrapper.mapStr(this.m, key);
    }

    public Date mapCTime(String key) {
        return MapWrapper.mapCTime(this.m, key);
    }

    public BigDecimal mapBigDecimal(String key) {
        return MapWrapper.mapBigDecimal(this.m, key);
    }

    public byte[] mapHex(String key) {
        return MapWrapper.mapHex(this.m, key);
    }

    public static Boolean mapBool(Map m, String key) {
        Object val = m.get(key);
        return val instanceof Boolean ? (Boolean)val : Boolean.FALSE;
    }

    public static BigDecimal mapBigDecimal(Map m, String key) {
        Object val = m.get(key);
        return val instanceof BigDecimal ? (BigDecimal)val : new BigDecimal((String)val);
    }

    public static Integer mapInt(Map m, String key) {
        Object val = m.get(key);
        return val instanceof Number ? Integer.valueOf(((Number)val).intValue()) : null;
    }

    public static Long mapLong(Map m, String key) {
        Object val = m.get(key);
        return val instanceof Number ? Long.valueOf(((Number)val).longValue()) : null;
    }

    public static String mapStr(Map m, String key) {
        Object v = m.get(key);
        return v == null ? null : String.valueOf(v);
    }

    public static Date mapCTime(Map m, String key) {
        Object v = m.get(key);
        return v == null ? null : new Date(MapWrapper.mapLong(m, key) * 1000L);
    }

    public static byte[] mapHex(Map m, String key) {
        Object v = m.get(key);
        return v == null ? null : HexCoder.decode((String)v);
    }

    public String toString() {
        return String.valueOf(this.m);
    }
}

