/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import com.google.common.io.BaseEncoding;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.FlowContext;
import org.littleshoot.proxy.FullFlowContext;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.impl.ClientDetails;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyConnectionPipeHandler;
import org.littleshoot.proxy.impl.ProxyToServerConnection;
import org.littleshoot.proxy.impl.ProxyUtils;

public class ClientToProxyConnection
extends ProxyConnection<HttpRequest> {
    private static final HttpResponseStatus CONNECTION_ESTABLISHED = new HttpResponseStatus(200, "Connection established");
    private static final String HTTP_ENCODER_NAME = "encoder";
    private static final String HTTP_DECODER_NAME = "decoder";
    private static final String HTTP_PROXY_DECODER_NAME = "proxy-protocol-decoder";
    private static final String HTTP_REQUEST_READ_MONITOR_NAME = "requestReadMonitor";
    private static final String HTTP_RESPONSE_WRITTEN_MONITOR_NAME = "responseWrittenMonitor";
    private static final String MAIN_HANDLER_NAME = "handler";
    private static final Pattern ABSOLUTE_URI_PATTERN = Pattern.compile("^(http|ws)://.*", 2);
    private final Map<String, ProxyToServerConnection> serverConnectionsByHostAndPort = new ConcurrentHashMap<String, ProxyToServerConnection>();
    private final AtomicInteger numberOfCurrentlyConnectingServers = new AtomicInteger(0);
    private HAProxyMessage haProxyMessage = null;
    private final AtomicInteger numberOfCurrentlyConnectedServers = new AtomicInteger(0);
    private final AtomicInteger numberOfReusedServerConnections = new AtomicInteger(0);
    private volatile ProxyToServerConnection currentServerConnection;
    private volatile HttpFilters currentFilters = HttpFiltersAdapter.NOOP_FILTER;
    private volatile SSLSession clientSslSession;
    private volatile boolean mitming = false;
    private final AtomicBoolean authenticated = new AtomicBoolean();
    private final GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private volatile HttpRequest currentRequest;
    private final ClientDetails clientDetails = new ClientDetails();
    ConnectionFlowStep RespondCONNECTSuccessful = new ConnectionFlowStep(this, ConnectionState.NEGOTIATING_CONNECT){

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        protected Future<?> execute() {
            ClientToProxyConnection.this.LOG.debug("Responding with CONNECT successful", new Object[0]);
            FullHttpResponse response = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, CONNECTION_ESTABLISHED);
            ProxyUtils.addVia((HttpMessage)response, ClientToProxyConnection.this.proxyServer.getProxyAlias());
            return ClientToProxyConnection.this.writeToChannel(response);
        }
    };
    private final ProxyConnection.BytesReadMonitor bytesReadMonitor = new ProxyConnection.BytesReadMonitor(){

        @Override
        protected void bytesRead(int numberOfBytes) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesReceivedFromClient(flowContext, numberOfBytes);
            }
        }
    };
    private final ProxyConnection.RequestReadMonitor requestReadMonitor = new ProxyConnection.RequestReadMonitor(){

        @Override
        protected void requestRead(HttpRequest httpRequest) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.requestReceivedFromClient(flowContext, httpRequest);
            }
        }
    };
    private final ProxyConnection.BytesWrittenMonitor bytesWrittenMonitor = new ProxyConnection.BytesWrittenMonitor(){

        @Override
        protected void bytesWritten(int numberOfBytes) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesSentToClient(flowContext, numberOfBytes);
            }
        }
    };
    private final ProxyConnection.ResponseWrittenMonitor responseWrittenMonitor = new ProxyConnection.ResponseWrittenMonitor(){

        @Override
        protected void responseWritten(HttpResponse httpResponse) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.responseSentToClient(flowContext, httpResponse);
            }
        }
    };

    ClientToProxyConnection(DefaultHttpProxyServer proxyServer, SslEngineSource sslEngineSource, boolean authenticateClients, ChannelPipeline pipeline, GlobalTrafficShapingHandler globalTrafficShapingHandler) {
        super(ConnectionState.AWAITING_INITIAL, proxyServer, false);
        this.initChannelPipeline(pipeline);
        if (sslEngineSource != null) {
            this.LOG.debug("Enabling encryption of traffic from client to proxy", new Object[0]);
            this.encrypt(pipeline, sslEngineSource.newSslEngine(), authenticateClients).addListener(future -> {
                if (future.isSuccess()) {
                    this.clientSslSession = this.sslEngine.getSession();
                    this.recordClientSSLHandshakeSucceeded();
                }
            });
        }
        this.globalTrafficShapingHandler = globalTrafficShapingHandler;
        this.LOG.debug("Created ClientToProxyConnection", new Object[0]);
    }

    @Override
    protected void readHAProxyMessage(HAProxyMessage msg) {
        this.haProxyMessage = msg;
    }

    @Override
    protected ConnectionState readHTTPInitial(HttpRequest httpRequest) {
        this.LOG.debug("Received raw request: {}", httpRequest);
        if (httpRequest.decoderResult().isFailure()) {
            this.LOG.debug("Could not parse request from client. Decoder result: {}", httpRequest.decoderResult().toString());
            FullHttpResponse response = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, "Unable to parse HTTP request");
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
            this.respondWithShortCircuitResponse((HttpResponse)response);
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        boolean authenticationRequired = this.authenticationRequired(httpRequest);
        if (authenticationRequired) {
            this.LOG.debug("Not authenticated!!", new Object[0]);
            return ConnectionState.AWAITING_PROXY_AUTHENTICATION;
        }
        return this.doReadHTTPInitial(httpRequest);
    }

    private ConnectionState doReadHTTPInitial(HttpRequest httpRequest) {
        this.currentRequest = this.copy(httpRequest);
        HttpFilters filterInstance = this.proxyServer.getFiltersSource().filterRequest(this.currentRequest, this.ctx);
        this.currentFilters = filterInstance != null ? filterInstance : HttpFiltersAdapter.NOOP_FILTER;
        HttpResponse clientToProxyFilterResponse = this.currentFilters.clientToProxyRequest((HttpObject)httpRequest);
        if (clientToProxyFilterResponse != null) {
            this.LOG.debug("Responding to client with short-circuit response from filter: {}", clientToProxyFilterResponse);
            boolean keepAlive = this.respondWithShortCircuitResponse(clientToProxyFilterResponse);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        if (!this.proxyServer.isAllowRequestsToOriginServer() && this.isRequestToOriginServer(httpRequest)) {
            boolean keepAlive = this.writeBadRequest(httpRequest);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        String serverHostAndPort = this.identifyHostAndPort(httpRequest);
        this.LOG.debug("Ensuring that hostAndPort are available in {}", httpRequest.uri());
        if (serverHostAndPort == null || StringUtils.isBlank((CharSequence)serverHostAndPort)) {
            this.LOG.warn("No host and port found in {}", httpRequest.uri());
            boolean keepAlive = this.writeBadGateway(httpRequest);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        this.LOG.debug("Finding ProxyToServerConnection for: {}", serverHostAndPort);
        this.currentServerConnection = this.isMitming() || this.isTunneling() ? this.currentServerConnection : this.serverConnectionsByHostAndPort.get(serverHostAndPort);
        boolean newConnectionRequired = false;
        if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
            this.LOG.debug("Not reusing existing ProxyToServerConnection because request is a CONNECT for: {}", serverHostAndPort);
            newConnectionRequired = true;
        } else if (this.currentServerConnection == null) {
            this.LOG.debug("Didn't find existing ProxyToServerConnection for: {}", serverHostAndPort);
            newConnectionRequired = true;
        }
        if (newConnectionRequired) {
            try {
                this.currentServerConnection = ProxyToServerConnection.create(this.proxyServer, this, serverHostAndPort, this.currentFilters, httpRequest, this.globalTrafficShapingHandler);
                if (this.currentServerConnection == null) {
                    this.LOG.debug("Unable to create server connection, probably no chained proxies available", new Object[0]);
                    boolean keepAlive = this.writeBadGateway(httpRequest);
                    this.resumeReading();
                    if (keepAlive) {
                        return ConnectionState.AWAITING_INITIAL;
                    }
                    return ConnectionState.DISCONNECT_REQUESTED;
                }
                this.serverConnectionsByHostAndPort.put(serverHostAndPort, this.currentServerConnection);
            }
            catch (UnknownHostException uhe) {
                this.LOG.info("Bad Host {}", httpRequest.uri());
                boolean keepAlive = this.writeBadGateway(httpRequest);
                this.resumeReading();
                if (keepAlive) {
                    return ConnectionState.AWAITING_INITIAL;
                }
                return ConnectionState.DISCONNECT_REQUESTED;
            }
        } else {
            this.LOG.debug("Reusing existing server connection: {}", new Object[]{this.currentServerConnection});
            this.numberOfReusedServerConnections.incrementAndGet();
        }
        this.modifyRequestHeadersToReflectProxying(httpRequest);
        HttpResponse proxyToServerFilterResponse = this.currentFilters.proxyToServerRequest((HttpObject)httpRequest);
        if (proxyToServerFilterResponse != null) {
            this.LOG.debug("Responding to client with short-circuit response from filter: {}", proxyToServerFilterResponse);
            boolean keepAlive = this.respondWithShortCircuitResponse(proxyToServerFilterResponse);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        this.LOG.debug("Writing request to ProxyToServerConnection", new Object[0]);
        this.currentServerConnection.write(httpRequest, this.currentFilters);
        if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
            return ConnectionState.NEGOTIATING_CONNECT;
        }
        if (ProxyUtils.isChunked((HttpObject)httpRequest)) {
            return ConnectionState.AWAITING_CHUNK;
        }
        return ConnectionState.AWAITING_INITIAL;
    }

    private boolean isRequestToOriginServer(HttpRequest httpRequest) {
        if (httpRequest.method() == HttpMethod.CONNECT || this.isMitming()) {
            return false;
        }
        String uri = httpRequest.uri();
        return !ABSOLUTE_URI_PATTERN.matcher(uri).matches();
    }

    @Override
    protected void readHTTPChunk(HttpContent chunk) {
        this.currentFilters.clientToProxyRequest((HttpObject)chunk);
        this.currentFilters.proxyToServerRequest((HttpObject)chunk);
        this.currentServerConnection.write(chunk);
    }

    @Override
    protected void readRaw(ByteBuf buf) {
        this.currentServerConnection.write(buf);
    }

    void respond(ProxyToServerConnection serverConnection, HttpFilters filters, HttpRequest currentHttpRequest, HttpResponse currentHttpResponse, HttpObject httpObject) {
        this.resetCurrentRequest();
        httpObject = filters.serverToProxyResponse(httpObject);
        if (httpObject == null) {
            this.forceDisconnect(serverConnection);
            return;
        }
        boolean isSwitchingToWebSocketProtocol = false;
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            isSwitchingToWebSocketProtocol = ProxyUtils.isSwitchingToWebSocketProtocol(httpResponse);
            if (!ProxyUtils.isHEAD(currentHttpRequest) && !ProxyUtils.isResponseSelfTerminating(httpResponse)) {
                if (!(httpResponse instanceof FullHttpResponse)) {
                    HttpResponse duplicateResponse;
                    httpResponse = duplicateResponse = ProxyUtils.duplicateHttpResponse(httpResponse);
                    httpObject = httpResponse;
                }
                HttpUtil.setTransferEncodingChunked((HttpMessage)httpResponse, (boolean)true);
            }
            this.fixHttpVersionHeaderIfNecessary(httpResponse);
            this.modifyResponseHeadersToReflectProxying(httpResponse);
        }
        if ((httpObject = filters.proxyToClientResponse(httpObject)) == null) {
            this.forceDisconnect(serverConnection);
            return;
        }
        this.write(httpObject);
        if (ProxyUtils.isLastChunk(httpObject)) {
            this.writeEmptyBuffer();
        } else if (isSwitchingToWebSocketProtocol) {
            this.switchToWebSocketProtocol(serverConnection);
        }
        this.closeConnectionsAfterWriteIfNecessary(serverConnection, currentHttpRequest, currentHttpResponse, httpObject);
    }

    private void resetCurrentRequest() {
        if (this.currentRequest != null && this.currentRequest instanceof ReferenceCounted) {
            ((ReferenceCounted)this.currentRequest).release();
        }
        this.currentRequest = null;
    }

    private void switchToWebSocketProtocol(ProxyToServerConnection serverConnection) {
        List<String> orderedHandlersToRemove = Arrays.asList(HTTP_REQUEST_READ_MONITOR_NAME, HTTP_RESPONSE_WRITTEN_MONITOR_NAME, HTTP_PROXY_DECODER_NAME, HTTP_ENCODER_NAME, HTTP_DECODER_NAME);
        if (this.channel.pipeline().get(MAIN_HANDLER_NAME) != null) {
            this.channel.pipeline().replace(MAIN_HANDLER_NAME, "pipe-to-server", (ChannelHandler)new ProxyConnectionPipeHandler(serverConnection));
        }
        orderedHandlersToRemove.forEach(this::removeHandlerIfPresent);
        serverConnection.switchToWebSocketProtocol();
    }

    @Override
    protected void connected() {
        super.connected();
        this.become(ConnectionState.AWAITING_INITIAL);
        this.recordClientConnected();
    }

    void timedOut(ProxyToServerConnection serverConnection) {
        if (this.currentServerConnection == serverConnection && this.lastReadTime > this.currentServerConnection.lastReadTime) {
            this.LOG.warn("Server timed out: {}", new Object[]{this.currentServerConnection});
            this.currentFilters.serverToProxyResponseTimedOut();
            this.writeGatewayTimeout(this.currentRequest);
        }
    }

    @Override
    protected void timedOut() {
        if (this.currentServerConnection == null || this.lastReadTime <= this.currentServerConnection.lastReadTime) {
            super.timedOut();
        }
    }

    @Override
    protected void disconnected() {
        super.disconnected();
        for (ProxyToServerConnection serverConnection : this.serverConnectionsByHostAndPort.values()) {
            serverConnection.disconnect();
        }
        this.recordClientDisconnected();
    }

    protected void serverConnectionFlowStarted(ProxyToServerConnection serverConnection) {
        this.stopReading();
        this.numberOfCurrentlyConnectingServers.incrementAndGet();
    }

    protected void serverConnectionSucceeded(ProxyToServerConnection serverConnection, boolean shouldForwardInitialRequest) {
        this.LOG.debug("Connection to server succeeded: {}", serverConnection.getRemoteAddress());
        this.resumeReadingIfNecessary();
        this.become(shouldForwardInitialRequest ? this.getCurrentState() : ConnectionState.AWAITING_INITIAL);
        this.numberOfCurrentlyConnectedServers.incrementAndGet();
    }

    protected boolean serverConnectionFailed(ProxyToServerConnection serverConnection, ConnectionState lastStateBeforeFailure, Throwable cause) {
        this.resumeReadingIfNecessary();
        HttpRequest initialRequest = serverConnection.getInitialRequest();
        try {
            boolean retrying = serverConnection.connectionFailed(cause);
            if (retrying) {
                this.LOG.debug("Failed to connect to upstream server or chained proxy. Retrying connection. Last state before failure: {}", new Object[]{lastStateBeforeFailure, cause});
                return true;
            }
            this.LOG.debug("Connection to upstream server or chained proxy failed: {}.  Last state before failure: {}", new Object[]{serverConnection.getRemoteAddress(), lastStateBeforeFailure, cause});
            this.connectionFailedUnrecoverably(initialRequest, serverConnection);
            return false;
        }
        catch (UnknownHostException uhe) {
            this.connectionFailedUnrecoverably(initialRequest, serverConnection);
            return false;
        }
    }

    private void connectionFailedUnrecoverably(HttpRequest initialRequest, ProxyToServerConnection serverConnection) {
        serverConnection.disconnect();
        this.serverConnectionsByHostAndPort.remove(serverConnection.getServerHostAndPort());
        boolean keepAlive = this.writeBadGateway(initialRequest);
        if (keepAlive) {
            this.become(ConnectionState.AWAITING_INITIAL);
        } else {
            this.become(ConnectionState.DISCONNECT_REQUESTED);
        }
    }

    private void resumeReadingIfNecessary() {
        if (this.numberOfCurrentlyConnectingServers.decrementAndGet() == 0) {
            this.LOG.debug("All servers have finished attempting to connect, resuming reading from client.", new Object[0]);
            this.resumeReading();
        }
    }

    protected void serverDisconnected(ProxyToServerConnection serverConnection) {
        this.numberOfCurrentlyConnectedServers.decrementAndGet();
        if (this.isTunneling() || this.isMitming()) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void becameSaturated() {
        super.becameSaturated();
        Iterator<ProxyToServerConnection> iterator = this.serverConnectionsByHostAndPort.values().iterator();
        while (iterator.hasNext()) {
            ProxyToServerConnection serverConnection;
            ProxyToServerConnection proxyToServerConnection = serverConnection = iterator.next();
            synchronized (proxyToServerConnection) {
                if (this.isSaturated()) {
                    serverConnection.stopReading();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void becameWritable() {
        super.becameWritable();
        Iterator<ProxyToServerConnection> iterator = this.serverConnectionsByHostAndPort.values().iterator();
        while (iterator.hasNext()) {
            ProxyToServerConnection serverConnection;
            ProxyToServerConnection proxyToServerConnection = serverConnection = iterator.next();
            synchronized (proxyToServerConnection) {
                if (!this.isSaturated()) {
                    serverConnection.resumeReading();
                }
            }
        }
    }

    protected synchronized void serverBecameSaturated(ProxyToServerConnection serverConnection) {
        if (serverConnection.isSaturated()) {
            this.LOG.info("Connection to server became saturated, stopping reading", new Object[0]);
            this.stopReading();
        }
    }

    protected synchronized void serverBecameWriteable(ProxyToServerConnection serverConnection) {
        boolean anyServersSaturated = false;
        for (ProxyToServerConnection otherServerConnection : this.serverConnectionsByHostAndPort.values()) {
            if (!otherServerConnection.isSaturated()) continue;
            anyServersSaturated = true;
            break;
        }
        if (!anyServersSaturated) {
            this.LOG.info("All server connections writeable, resuming reading", new Object[0]);
            this.resumeReading();
        }
    }

    @Override
    protected void exceptionCaught(Throwable cause) {
        try {
            if (cause instanceof IOException) {
                this.LOG.info("An IOException occurred on ClientToProxyConnection: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("An IOException occurred on ClientToProxyConnection", cause);
            } else if (cause instanceof RejectedExecutionException) {
                this.LOG.info("An executor rejected a read or write operation on the ClientToProxyConnection (this is normal if the proxy is shutting down). Message: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("A RejectedExecutionException occurred on ClientToProxyConnection", cause);
            } else {
                this.LOG.error("Caught an exception on ClientToProxyConnection", cause);
            }
        }
        finally {
            this.disconnect();
        }
    }

    private void initChannelPipeline(ChannelPipeline pipeline) {
        this.LOG.debug("Configuring ChannelPipeline", new Object[0]);
        pipeline.addLast("bytesReadMonitor", (ChannelHandler)this.bytesReadMonitor);
        pipeline.addLast("bytesWrittenMonitor", (ChannelHandler)this.bytesWrittenMonitor);
        pipeline.addLast(HTTP_ENCODER_NAME, (ChannelHandler)new HttpResponseEncoder());
        if (this.isAcceptProxyProtocol()) {
            pipeline.addLast(HTTP_PROXY_DECODER_NAME, (ChannelHandler)new HAProxyMessageDecoder());
        }
        pipeline.addLast(HTTP_DECODER_NAME, (ChannelHandler)new HttpRequestDecoder(this.proxyServer.getMaxInitialLineLength(), this.proxyServer.getMaxHeaderSize(), this.proxyServer.getMaxChunkSize()));
        int numberOfBytesToBuffer = this.proxyServer.getFiltersSource().getMaximumRequestBufferSizeInBytes();
        if (numberOfBytesToBuffer > 0) {
            this.aggregateContentForFiltering(pipeline, numberOfBytesToBuffer);
        }
        pipeline.addLast(HTTP_REQUEST_READ_MONITOR_NAME, (ChannelHandler)this.requestReadMonitor);
        pipeline.addLast(HTTP_RESPONSE_WRITTEN_MONITOR_NAME, (ChannelHandler)this.responseWrittenMonitor);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.proxyServer.getIdleConnectionTimeout()));
        pipeline.addLast(MAIN_HANDLER_NAME, (ChannelHandler)this);
    }

    private void removeHandlerIfPresent(String name) {
        this.removeHandlerIfPresent(this.channel.pipeline(), name);
    }

    boolean isAcceptProxyProtocol() {
        return this.proxyServer.isAcceptProxyProtocol();
    }

    boolean isSendProxyProtocol() {
        return this.proxyServer.isSendProxyProtocol();
    }

    private void closeConnectionsAfterWriteIfNecessary(ProxyToServerConnection serverConnection, HttpRequest currentHttpRequest, HttpResponse currentHttpResponse, HttpObject httpObject) {
        boolean closeServerConnection = this.shouldCloseServerConnection(currentHttpRequest, currentHttpResponse, httpObject);
        boolean closeClientConnection = this.shouldCloseClientConnection(currentHttpRequest, currentHttpResponse, httpObject);
        if (closeServerConnection) {
            this.LOG.debug("Closing remote connection after writing to client", new Object[0]);
            serverConnection.disconnect();
        }
        if (closeClientConnection) {
            this.LOG.debug("Closing connection to client after writes", new Object[0]);
            this.disconnect();
        }
    }

    private void forceDisconnect(ProxyToServerConnection serverConnection) {
        this.LOG.debug("Forcing disconnect", new Object[0]);
        serverConnection.disconnect();
        this.disconnect();
    }

    private boolean shouldCloseClientConnection(HttpRequest req, HttpResponse res, HttpObject httpObject) {
        if (ProxyUtils.isChunked((HttpObject)res) && httpObject != null) {
            if (!ProxyUtils.isLastChunk(httpObject)) {
                String uri = null;
                if (req != null) {
                    uri = req.uri();
                }
                this.LOG.debug("Not closing client connection on middle chunk for {}", uri);
                return false;
            }
            this.LOG.debug("Handling last chunk. Using normal client connection closing rules.", new Object[0]);
        }
        if (!HttpUtil.isKeepAlive((HttpMessage)req)) {
            this.LOG.debug("Closing client connection since request is not keep alive: {}", req);
            return true;
        }
        this.LOG.debug("Not closing client connection for request: {}", req);
        return false;
    }

    private boolean shouldCloseServerConnection(HttpRequest req, HttpResponse res, HttpObject msg) {
        if (ProxyUtils.isChunked((HttpObject)res) && msg != null) {
            if (!ProxyUtils.isLastChunk(msg)) {
                String uri = null;
                if (req != null) {
                    uri = req.uri();
                }
                this.LOG.debug("Not closing server connection on middle chunk for {}", uri);
                return false;
            }
            this.LOG.debug("Handling last chunk. Using normal server connection closing rules.", new Object[0]);
        }
        if (!HttpUtil.isKeepAlive((HttpMessage)res)) {
            this.LOG.debug("Closing server connection since response is not keep alive: {}", res);
            return true;
        }
        this.LOG.debug("Not closing server connection for response: {}", res);
        return false;
    }

    private boolean authenticationRequired(HttpRequest request) {
        String password;
        if (this.authenticated.get()) {
            return false;
        }
        ProxyAuthenticator authenticator = this.proxyServer.getProxyAuthenticator();
        if (authenticator == null) {
            return false;
        }
        if (!request.headers().contains((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION)) {
            this.writeAuthenticationRequired(authenticator.getRealm());
            return true;
        }
        List values = request.headers().getAll((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION);
        String fullValue = (String)values.iterator().next();
        String value = StringUtils.substringAfter((String)fullValue, (String)"Basic ").trim();
        byte[] decodedValue = BaseEncoding.base64().decode((CharSequence)value);
        String decodedString = new String(decodedValue, StandardCharsets.UTF_8);
        String userName = StringUtils.substringBefore((String)decodedString, (String)":");
        if (!authenticator.authenticate(userName, password = StringUtils.substringAfter((String)decodedString, (String)":"))) {
            this.writeAuthenticationRequired(authenticator.getRealm());
            return true;
        }
        this.clientDetails.setUserName(userName);
        this.LOG.debug("Got proxy authorization!", new Object[0]);
        String authentication = request.headers().get((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION);
        this.LOG.debug(authentication, new Object[0]);
        request.headers().remove((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION);
        this.authenticated.set(true);
        return false;
    }

    private void writeAuthenticationRequired(String realm) {
        String body = "<!DOCTYPE HTML \"-//IETF//DTD HTML 2.0//EN\">\n<html><head>\n<title>407 Proxy Authentication Required</title>\n</head><body>\n<h1>Proxy Authentication Required</h1>\n<p>This server could not verify that you\nare authorized to access the document\nrequested.  Either you supplied the wrong\ncredentials (e.g., bad password), or your\nbrowser doesn't understand how to supply\nthe credentials required.</p>\n</body></html>\n";
        FullHttpResponse response = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED, body);
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)new Date());
        response.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE, (Object)("Basic realm=\"" + (realm == null ? "Restricted Files" : realm) + "\""));
        this.write(response);
    }

    private HttpRequest copy(HttpRequest original) {
        if (original instanceof FullHttpRequest) {
            return ((FullHttpRequest)original).copy();
        }
        DefaultHttpRequest request = new DefaultHttpRequest(original.protocolVersion(), original.method(), original.uri());
        request.headers().set(original.headers());
        return request;
    }

    private void fixHttpVersionHeaderIfNecessary(HttpResponse httpResponse) {
        String te = httpResponse.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (StringUtils.isNotBlank((CharSequence)te) && te.equalsIgnoreCase(HttpHeaderValues.CHUNKED.toString()) && httpResponse.protocolVersion() != HttpVersion.HTTP_1_1) {
            this.LOG.debug("Fixing HTTP version.", new Object[0]);
            httpResponse.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
    }

    private void modifyRequestHeadersToReflectProxying(HttpRequest httpRequest) {
        if (this.isNextHopOriginServer()) {
            this.LOG.debug("Modifying request for proxy chaining", new Object[0]);
            String uri = httpRequest.uri();
            String adjustedUri = ProxyUtils.stripHost(uri);
            this.LOG.debug("Stripped host from uri: {}    yielding: {}", uri, adjustedUri);
            httpRequest.setUri(adjustedUri);
        }
        if (!this.proxyServer.isTransparent()) {
            this.LOG.debug("Modifying request headers for proxying", new Object[0]);
            HttpHeaders headers = httpRequest.headers();
            ProxyUtils.removeSdchEncoding(headers);
            this.switchProxyConnectionHeader(headers);
            this.stripConnectionTokens(headers);
            this.stripHopByHopHeaders(headers);
            ProxyUtils.addVia((HttpMessage)httpRequest, this.proxyServer.getProxyAlias());
        }
    }

    private boolean isNextHopOriginServer() {
        if (!this.currentServerConnection.hasUpstreamChainedProxy()) {
            return true;
        }
        switch (this.currentServerConnection.getChainedProxyType()) {
            case HTTP: {
                return false;
            }
            case SOCKS4: 
            case SOCKS5: {
                return true;
            }
        }
        this.LOG.warn("Assuming upstream chained proxy of unknown type " + (Object)((Object)this.currentServerConnection.getChainedProxyType()) + " should not be treated as an origin server", new Object[0]);
        return false;
    }

    private void modifyResponseHeadersToReflectProxying(HttpResponse httpResponse) {
        if (!this.proxyServer.isTransparent()) {
            HttpHeaders headers = httpResponse.headers();
            this.stripConnectionTokens(headers);
            this.stripHopByHopHeaders(headers);
            ProxyUtils.addVia((HttpMessage)httpResponse, this.proxyServer.getProxyAlias());
            if (!headers.contains((CharSequence)HttpHeaderNames.DATE)) {
                headers.set((CharSequence)HttpHeaderNames.DATE, (Object)new Date());
            }
        }
    }

    private void switchProxyConnectionHeader(HttpHeaders headers) {
        String proxyConnectionKey = "Proxy-Connection";
        if (headers.contains(proxyConnectionKey)) {
            String header = headers.get(proxyConnectionKey);
            headers.remove(proxyConnectionKey);
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)header);
        }
    }

    private void stripConnectionTokens(HttpHeaders headers) {
        if (headers.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            for (String headerValue : headers.getAll((CharSequence)HttpHeaderNames.CONNECTION)) {
                for (String connectionToken : ProxyUtils.splitCommaSeparatedHeaderValues(headerValue)) {
                    if (HttpHeaderNames.TRANSFER_ENCODING.toString().equals(connectionToken.toLowerCase(Locale.US))) continue;
                    headers.remove(connectionToken);
                }
            }
        }
    }

    private void stripHopByHopHeaders(HttpHeaders headers) {
        Set headerNames = headers.names();
        for (String headerName : headerNames) {
            if (!ProxyUtils.shouldRemoveHopByHopHeader(headerName)) continue;
            headers.remove(headerName);
        }
    }

    private boolean writeBadGateway(HttpRequest httpRequest) {
        String body = "Bad Gateway: " + httpRequest.uri();
        FullHttpResponse response = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY, body);
        if (ProxyUtils.isHEAD(httpRequest)) {
            response.content().clear();
        }
        return this.respondWithShortCircuitResponse((HttpResponse)response);
    }

    private boolean writeBadRequest(HttpRequest httpRequest) {
        String body = "Bad Request to URI: " + httpRequest.uri();
        FullHttpResponse response = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, body);
        if (ProxyUtils.isHEAD(httpRequest)) {
            response.content().clear();
        }
        return this.respondWithShortCircuitResponse((HttpResponse)response);
    }

    private boolean writeGatewayTimeout(HttpRequest httpRequest) {
        String body = "Gateway Timeout";
        FullHttpResponse response = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.GATEWAY_TIMEOUT, body);
        if (httpRequest != null && ProxyUtils.isHEAD(httpRequest)) {
            response.content().clear();
        }
        return this.respondWithShortCircuitResponse((HttpResponse)response);
    }

    private boolean respondWithShortCircuitResponse(HttpResponse httpResponse) {
        this.resetCurrentRequest();
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)httpResponse);
        HttpResponse filteredResponse = (HttpResponse)this.currentFilters.proxyToClientResponse((HttpObject)httpResponse);
        if (filteredResponse == null) {
            this.disconnect();
            return false;
        }
        int statusCode = filteredResponse.status().code();
        if (statusCode != HttpResponseStatus.BAD_GATEWAY.code() && statusCode != HttpResponseStatus.GATEWAY_TIMEOUT.code()) {
            this.modifyResponseHeadersToReflectProxying(filteredResponse);
        }
        HttpUtil.setKeepAlive((HttpMessage)filteredResponse, (boolean)isKeepAlive);
        this.write(filteredResponse);
        if (ProxyUtils.isLastChunk((HttpObject)filteredResponse)) {
            this.writeEmptyBuffer();
        }
        if (!HttpUtil.isKeepAlive((HttpMessage)filteredResponse)) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private String identifyHostAndPort(HttpRequest httpRequest) {
        List hosts;
        String hostAndPort = ProxyUtils.parseHostAndPort(httpRequest);
        if (StringUtils.isBlank((CharSequence)hostAndPort) && (hosts = httpRequest.headers().getAll((CharSequence)HttpHeaderNames.HOST)) != null && !hosts.isEmpty()) {
            hostAndPort = (String)hosts.get(0);
        }
        return hostAndPort;
    }

    private void writeEmptyBuffer() {
        this.write(Unpooled.EMPTY_BUFFER);
    }

    public boolean isMitming() {
        return this.mitming;
    }

    protected void setMitming(boolean isMitming) {
        this.mitming = isMitming;
    }

    private void recordClientConnected() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            this.clientDetails.setClientAddress(clientAddress);
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientConnected(clientAddress);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientConnected", e);
        }
    }

    private void recordClientSSLHandshakeSucceeded() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientSSLHandshakeSucceeded(clientAddress, this.clientSslSession);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientSSLHandshakeSucceeded", e);
        }
    }

    private void recordClientDisconnected() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientDisconnected(clientAddress, this.clientSslSession);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientDisconnected", e);
        }
    }

    public InetSocketAddress getClientAddress() {
        if (this.channel == null) {
            return null;
        }
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    private FlowContext flowContext() {
        if (this.currentServerConnection != null) {
            return new FullFlowContext(this, this.currentServerConnection);
        }
        return new FlowContext(this);
    }

    public HAProxyMessage getHaProxyMessage() {
        return this.haProxyMessage;
    }

    public ClientDetails getClientDetails() {
        return this.clientDetails;
    }
}

