/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.cobol.parser.decoders;

import java.nio.charset.StandardCharsets;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.CharRef;
import scala.util.control.NonFatal$;
import za.co.absa.cobrix.cobol.parser.common.Constants$;
import za.co.absa.cobrix.cobol.parser.decoders.BinaryUtils$;
import za.co.absa.cobrix.cobol.parser.decoders.StringTools$;

public final class StringDecoders$ {
    public static StringDecoders$ MODULE$;
    private final int TrimNone;
    private final int TrimLeft;
    private final int TrimRight;
    private final int TrimBoth;
    private final char[] HEX_ARRAY;

    static {
        new StringDecoders$();
    }

    public int TrimNone() {
        return this.TrimNone;
    }

    public int TrimLeft() {
        return this.TrimLeft;
    }

    public int TrimRight() {
        return this.TrimRight;
    }

    public int TrimBoth() {
        return this.TrimBoth;
    }

    private char[] HEX_ARRAY() {
        return this.HEX_ARRAY;
    }

    public final String decodeEbcdicString(byte[] bytes, int trimmingType, char[] conversionTable, boolean improvedNullDetection) {
        if (improvedNullDetection && StringTools$.MODULE$.isArrayNull(bytes)) {
            return null;
        }
        StringBuffer buf = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(conversionTable[(bytes[i] + 256) % 256]);
        }
        return trimmingType == this.TrimNone() ? buf.toString() : (trimmingType == this.TrimLeft() ? StringTools$.MODULE$.trimLeft(buf.toString()) : (trimmingType == this.TrimRight() ? StringTools$.MODULE$.trimRight(buf.toString()) : buf.toString().trim()));
    }

    public final String decodeAsciiString(byte[] bytes, int trimmingType, boolean improvedNullDetection) {
        if (improvedNullDetection && StringTools$.MODULE$.isArrayNull(bytes)) {
            return null;
        }
        StringBuffer buf = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            StringBuffer stringBuffer = bytes[i] < 32 ? buf.append(' ') : buf.append((char)bytes[i]);
        }
        return trimmingType == this.TrimNone() ? buf.toString() : (trimmingType == this.TrimLeft() ? StringTools$.MODULE$.trimLeft(buf.toString()) : (trimmingType == this.TrimRight() ? StringTools$.MODULE$.trimRight(buf.toString()) : buf.toString().trim()));
    }

    public final String decodeUtf16String(byte[] bytes, int trimmingType, boolean isUtf16BigEndian, boolean improvedNullDetection) {
        String utf16Str;
        if (improvedNullDetection && StringTools$.MODULE$.isArrayNull(bytes)) {
            return null;
        }
        String string = utf16Str = isUtf16BigEndian ? new String(bytes, StandardCharsets.UTF_16BE) : new String(bytes, StandardCharsets.UTF_16LE);
        return trimmingType == this.TrimNone() ? utf16Str : (trimmingType == this.TrimLeft() ? StringTools$.MODULE$.trimLeft(utf16Str) : (trimmingType == this.TrimRight() ? StringTools$.MODULE$.trimRight(utf16Str) : utf16Str.trim()));
    }

    public final String decodeHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = this.HEX_ARRAY()[v >>> 4];
            hexChars[i * 2 + 1] = this.HEX_ARRAY()[v & 0xF];
        }
        return new String(hexChars);
    }

    public final byte[] decodeRaw(byte[] bytes) {
        return bytes;
    }

    public final String decodeEbcdicNumber(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        if (improvedNullDetection && StringTools$.MODULE$.isArrayNull(bytes)) {
            return null;
        }
        StringBuffer buf = new StringBuffer(bytes.length + 1);
        int sign = 32;
        boolean malformed = false;
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            int ch = 32;
            if (sign != 32) {
                if (b >= 240 && b <= 249) {
                    ch = (char)(b - 240 + 48);
                } else if (b == Constants$.MODULE$.dotCharEBCIDIC() || b == Constants$.MODULE$.commaCharEBCIDIC()) {
                    ch = 46;
                } else if (b == Constants$.MODULE$.spaceCharEBCIDIC() || b == 0) {
                    ch = 32;
                } else {
                    malformed = true;
                }
            } else if (b >= 240 && b <= 249) {
                ch = (char)(b - 240 + 48);
            } else if (!isUnsigned && b >= 192 && b <= 201) {
                ch = (char)(b - 192 + 48);
                sign = 43;
            } else if (!isUnsigned && b >= 208 && b <= 217) {
                ch = (char)(b - 208 + 48);
                sign = 45;
            } else if (b == Constants$.MODULE$.minusCharEBCIDIC()) {
                sign = 45;
            } else if (b == Constants$.MODULE$.plusCharEBCIDIC()) {
                sign = 43;
            } else if (b == Constants$.MODULE$.dotCharEBCIDIC() || b == Constants$.MODULE$.commaCharEBCIDIC()) {
                ch = 46;
            } else if (b == Constants$.MODULE$.spaceCharEBCIDIC() || b == 0) {
                ch = 32;
            } else {
                malformed = true;
            }
            Object object = ch != 32 ? buf.append((char)ch) : BoxedUnit.UNIT;
        }
        return malformed ? null : (sign != 32 ? (sign == 45 && isUnsigned ? null : new StringBuilder(0).append((char)sign).append(buf.toString().trim()).toString()) : buf.toString());
    }

    public final String decodeAsciiNumber(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        String allowedDigitChars = " 0123456789";
        String punchedSignChars = "{ABCDEFGHI}JKLMNOPQR";
        if (improvedNullDetection && StringTools$.MODULE$.isArrayNull(bytes)) {
            return null;
        }
        StringBuffer buf = new StringBuffer(bytes.length);
        CharRef sign = CharRef.create((char)' ');
        for (int i = 0; i < bytes.length; ++i) {
            StringBuffer stringBuffer;
            char c = (char)bytes[i];
            if (new StringOps(Predef$.MODULE$.augmentString(allowedDigitChars)).contains((Object)BoxesRunTime.boxToCharacter((char)c))) {
                stringBuffer = buf.append(c);
                continue;
            }
            if (c == '-' || c == '+') {
                sign.elem = c;
                stringBuffer = BoxedUnit.UNIT;
                continue;
            }
            if (c == '.' || c == ',') {
                stringBuffer = buf.append('.');
                continue;
            }
            if (isUnsigned || i != 0 && i != bytes.length - 1 || !new StringOps(Predef$.MODULE$.augmentString(punchedSignChars)).contains((Object)BoxesRunTime.boxToCharacter((char)c))) {
                return null;
            }
            StringDecoders$.decodeOverpunchedSign$1(c, punchedSignChars, sign, buf);
            stringBuffer = BoxedUnit.UNIT;
        }
        return sign.elem != ' ' ? (sign.elem == '-' && isUnsigned ? null : new StringBuilder(0).append(sign.elem).append(buf.toString().trim()).toString()) : buf.toString().trim();
    }

    public final Integer decodeEbcdicInt(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(this.decodeEbcdicNumber(bytes, isUnsigned, improvedNullDetection))).toInt());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            n = var4_7;
        }
        return n;
    }

    public final Integer decodeAsciiInt(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(this.decodeAsciiNumber(bytes, isUnsigned, improvedNullDetection))).toInt());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            n = var4_7;
        }
        return n;
    }

    public final Long decodeEbcdicLong(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        Long l;
        try {
            l = Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(this.decodeEbcdicNumber(bytes, isUnsigned, improvedNullDetection))).toLong());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            l = var4_7;
        }
        return l;
    }

    public final Long decodeAsciiLong(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        Long l;
        try {
            l = Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(this.decodeAsciiNumber(bytes, isUnsigned, improvedNullDetection))).toLong());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            l = var4_7;
        }
        return l;
    }

    public final BigDecimal decodeEbcdicBigNumber(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection, int scale, int scaleFactor) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(BinaryUtils$.MODULE$.addDecimalPoint(this.decodeEbcdicNumber(bytes, isUnsigned, improvedNullDetection), scale, scaleFactor));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var6_9 = null;
            bigDecimal = var6_9;
        }
        return bigDecimal;
    }

    public final int decodeEbcdicBigNumber$default$4() {
        return 0;
    }

    public final int decodeEbcdicBigNumber$default$5() {
        return 0;
    }

    public final BigDecimal decodeAsciiBigNumber(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection, int scale, int scaleFactor) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(BinaryUtils$.MODULE$.addDecimalPoint(this.decodeAsciiNumber(bytes, isUnsigned, improvedNullDetection), scale, scaleFactor));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var6_9 = null;
            bigDecimal = var6_9;
        }
        return bigDecimal;
    }

    public final int decodeAsciiBigNumber$default$4() {
        return 0;
    }

    public final int decodeAsciiBigNumber$default$5() {
        return 0;
    }

    public final BigDecimal decodeEbcdicBigDecimal(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(this.decodeEbcdicNumber(bytes, isUnsigned, improvedNullDetection));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            bigDecimal = var4_7;
        }
        return bigDecimal;
    }

    public final BigDecimal decodeAsciiBigDecimal(byte[] bytes, boolean isUnsigned, boolean improvedNullDetection) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(this.decodeAsciiNumber(bytes, isUnsigned, improvedNullDetection));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            bigDecimal = var4_7;
        }
        return bigDecimal;
    }

    private static final void decodeOverpunchedSign$1(char c, String punchedSignChars$1, CharRef sign$1, StringBuffer buf$1) {
        int idx = punchedSignChars$1.indexOf(c);
        if (idx >= 10) {
            sign$1.elem = (char)45;
            buf$1.append((char)((byte)48 + idx - 10));
        } else {
            sign$1.elem = (char)43;
            buf$1.append((char)((byte)48 + idx));
        }
    }

    private StringDecoders$() {
        MODULE$ = this;
        this.TrimNone = 1;
        this.TrimLeft = 2;
        this.TrimRight = 3;
        this.TrimBoth = 4;
        this.HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }
}

